/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.extension.diagrameditor;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.papyrus.infra.core.extension.ExtensionException;
import org.eclipse.papyrus.infra.core.extension.ExtensionUtils;
import org.eclipse.papyrus.infra.ui.Activator;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.EditorDescriptor;

public class EditorDescriptorExtensionFactory
extends ExtensionUtils {
    public static final EditorDescriptorExtensionFactory eINSTANCE = new EditorDescriptorExtensionFactory();
    public static final String EDITOR_DIAGRAM_EXTENSIONPOINT = "editorDiagram";
    public static final String FACTORYCLASS_ATTRIBUTE = "factoryClass";
    public static final String ACTIONBARCONTRIBUTORID_ATTRIBUTE = "actionBarContributorId";
    public static final String ICON_ATTRIBUTE = "icon";
    public static final String ORDER_ATTRIBUTE = "order";

    public static EditorDescriptorExtensionFactory getInstance() {
        return eINSTANCE;
    }

    public EditorDescriptor createNestedEditorDescriptor(IConfigurationElement element) throws ExtensionException {
        this.checkTagName(element, EDITOR_DIAGRAM_EXTENSIONPOINT);
        EditorDescriptor res = new EditorDescriptor();
        res.setEditorFactoryClass(this.parseClass(element, FACTORYCLASS_ATTRIBUTE, EDITOR_DIAGRAM_EXTENSIONPOINT));
        res.setActionBarContributorId(element.getAttribute(ACTIONBARCONTRIBUTORID_ATTRIBUTE));
        int order = 0;
        try {
            String orderAttribute = element.getAttribute(ORDER_ATTRIBUTE);
            if (orderAttribute != null) {
                order = Integer.parseInt(orderAttribute);
            }
        }
        catch (NumberFormatException ex) {
            Activator.log.warn("Invalid order provided by " + String.valueOf(element.getContributor()) + ". Order should be an integer value");
        }
        res.setOrder(order);
        String iconPath = element.getAttribute(ICON_ATTRIBUTE);
        if (iconPath != null) {
            res.setIcon(element, iconPath, "org.eclipse.papyrus.infra.ui");
        }
        if (org.eclipse.papyrus.infra.core.Activator.log.isDebugEnabled()) {
            org.eclipse.papyrus.infra.core.Activator.log.debug("Read editor descriptor " + String.valueOf(res));
        }
        return res;
    }
}

