/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.rules;

import java.util.Iterator;
import org.eclipse.papyrus.junit.utils.rules.AbstractHouseKeeperRule;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class HouseKeeper
extends AbstractHouseKeeperRule
implements MethodRule {
    @Override
    boolean isStatic() {
        return false;
    }

    @Override
    Class<?> getTestClass() {
        return this.test.getClass();
    }

    public Statement apply(final Statement base, final FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                HouseKeeper.this.test = target;
                HouseKeeper.this.testName = method.getName();
                try {
                    HouseKeeper.this.registerAutoCleanups();
                    base.evaluate();
                }
                finally {
                    HouseKeeper.this.cleanUp();
                }
            }
        };
    }

    public static interface Disposer<T> {
        public void dispose(T var1) throws Exception;
    }

    public static class Static
    extends AbstractHouseKeeperRule
    implements TestRule {
        @Override
        boolean isStatic() {
            return true;
        }

        @Override
        Class<?> getTestClass() {
            return (Class)this.test;
        }

        public Statement apply(final Statement base, final Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    test = this.findTestClass(description);
                    testName = description.getMethodName();
                    try {
                        this.registerAutoCleanups();
                        base.evaluate();
                    }
                    finally {
                        this.cleanUp();
                    }
                }

                Class<?> findTestClass(Description description2) {
                    Class<?> result = description2.getTestClass();
                    if (result == null) {
                        Iterator iter = description2.getChildren().iterator();
                        while (result == null && iter.hasNext()) {
                            result = this.findTestClass((Description)iter.next());
                        }
                    }
                    return result;
                }
            };
        }
    }
}

