/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ocl.examples.debug.vm.core.VMLineBreakpoint;
import org.eclipse.qvtd.debug.core.QVTiDebugCore;
import org.eclipse.qvtd.debug.core.QVTiLineBreakpoint;
import org.eclipse.qvtd.debug.ui.QVTdDebugUIPlugin;
import org.eclipse.qvtd.debug.ui.actions.BreakpointLocationVerifier;
import org.eclipse.qvtd.debug.ui.messages.DebugUIMessages;
import org.eclipse.qvtd.xtext.qvtimperative.ui.QVTimperativeEditor;
import org.eclipse.ui.IWorkbenchPart;

public class QVTiToggleBreakpointAdapter
implements IToggleBreakpointsTarget {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (!(part instanceof QVTimperativeEditor)) {
            return;
        }
        final QVTimperativeEditor qvtEditor = (QVTimperativeEditor)part;
        IFile unitFile = (IFile)qvtEditor.getEditorInput().getAdapter(IResource.class);
        ITextSelection textSelection = (ITextSelection)selection;
        int lineNumber = textSelection.getStartLine() + 1;
        List breakpoints = QVTiDebugCore.INSTANCE.getOCLBreakpoints(ILineBreakpoint.class);
        for (ILineBreakpoint next : breakpoints) {
            if (!unitFile.equals((Object)next.getMarker().getResource()) || next.getLineNumber() != lineNumber) continue;
            try {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)next, true);
            }
            catch (CoreException e) {
                QVTdDebugUIPlugin.log(e.getStatus());
            }
            next.delete();
            return;
        }
        URI sourceURI = URI.createPlatformResourceURI((String)unitFile.getFullPath().toString(), (boolean)true);
        QVTiLineBreakpoint lineBreakpoint = new QVTiLineBreakpoint(sourceURI, lineNumber);
        lineBreakpoint.register(true);
        Job job = new Job(DebugUIMessages.QVTiToggleBreakpointAdapter_VerifyBreakpointJob, (VMLineBreakpoint)lineBreakpoint){
            private final /* synthetic */ VMLineBreakpoint val$lineBreakpoint;
            {
                this.val$lineBreakpoint = vMLineBreakpoint;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                return new BreakpointLocationVerifier(qvtEditor, (ILineBreakpoint)this.val$lineBreakpoint, DebugUIMessages.QVTiToggleBreakpointAdapter_CannotSetBreakpoint).run();
            }

            public boolean belongsTo(Object family) {
                return VMLineBreakpoint.OCL_BREAKPOINT_JOBFAMILY == family;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return part instanceof QVTimperativeEditor;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }
}

