/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.AbstractQVTb2QVTs;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTcoreScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.TransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.EarlyMerger;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduleModel;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class QVTm2QVTs
extends AbstractQVTb2QVTs {
    public QVTm2QVTs(@NonNull ProblemHandler problemHandler, @NonNull EnvironmentFactory environmentFactory,  @Nullable CompilerOptions.StepOptions schedulerOptions) {
        super(new QVTcoreScheduleManager(environmentFactory, schedulerOptions), problemHandler);
    }

    public @NonNull List<@NonNull MappingRegion> transform() throws IOException {
        ArrayList<@NonNull RuleRegion> orderedRuleRegions = new ArrayList<RuleRegion>();
        for (MappingRegion mappingRegion : QVTscheduleUtil.getOwnedMappingRegions((ScheduleModel)this.scheduleManager.getScheduleModel())) {
            orderedRuleRegions.add((RuleRegion)mappingRegion);
        }
        Collections.sort(orderedRuleRegions, NameUtil.NAMEABLE_COMPARATOR);
        for (TransformationAnalysis transformationAnalysis : this.scheduleManager.getTransformationAnalyses()) {
            RuleAnalysis ruleAnalysis;
            ArrayList ruleAnalyses = Lists.newArrayList(transformationAnalysis.getRuleAnalyses());
            Collections.sort(ruleAnalyses, NameUtil.NAMEABLE_COMPARATOR);
            Iterator iterator = ruleAnalyses.iterator();
            while (iterator.hasNext()) {
                ruleAnalysis = (RuleAnalysis)((Object)iterator.next());
                ruleAnalysis.registerConsumptionsAndProductions();
            }
            iterator = ruleAnalyses.iterator();
            while (iterator.hasNext()) {
                ruleAnalysis = (RuleAnalysis)((Object)iterator.next());
                this.scheduleManager.writeDebugGraphs((Region)ruleAnalysis.getRegion(), null);
            }
        }
        ArrayList<@NonNull MappingRegion> orderedRegions = new ArrayList<MappingRegion>();
        for (RuleRegion ruleRegion : orderedRuleRegions) {
            orderedRegions.add((MappingRegion)ruleRegion);
        }
        boolean noEarlyMerge = this.scheduleManager.isNoEarlyMerge();
        ArrayList<@NonNull MappingRegion> activeRegions = new ArrayList<MappingRegion>(noEarlyMerge ? orderedRegions : EarlyMerger.merge(this.scheduleManager, orderedRegions));
        return activeRegions;
    }
}

