/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ScheduleCache;
import org.eclipse.qvtd.pivot.qvtschedule.DatumConnection;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduledRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class CallTreeBuilder {
    private final @NonNull ScheduleCache scheduleCache;
    private final @NonNull Map<@NonNull NodeConnection, @NonNull Region> connection2commonRegion = new HashMap<NodeConnection, Region>();

    public CallTreeBuilder(@NonNull ScheduleCache scheduleCache) {
        this.scheduleCache = scheduleCache;
    }

    public void buildTree(@NonNull ScheduledRegion rootScheduledRegion, @NonNull List<@NonNull Region> orderedRegions) {
        Stack<@NonNull Region> callStack = new Stack<Region>();
        callStack.push((Region)rootScheduledRegion);
        for (Region region : orderedRegions) {
            this.updateCallStack(callStack, region);
        }
        this.installConnections();
    }

    protected @NonNull Region getCommonRegion(@NonNull Region firstRegion, @NonNull Region secondRegion) {
        Region commonRegion = this.scheduleCache.getCommonRegion(firstRegion, secondRegion);
        assert (commonRegion != null);
        return commonRegion;
    }

    protected @NonNull Region getMinimumDepthParentRegion(@NonNull Region childRegion) {
        Region minimumDepthParentRegion = this.scheduleCache.getMinimumDepthParentRegion(childRegion);
        assert (minimumDepthParentRegion != null);
        return minimumDepthParentRegion;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void installConnections() {
        List<Region> intermediateRegions;
        Region commonRegion;
        ArrayList<@NonNull NodeConnection> connections = new ArrayList<NodeConnection>(this.connection2commonRegion.keySet());
        Collections.sort(connections, new Comparator<NodeConnection>(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public int compare(@NonNull NodeConnection o1, @NonNull NodeConnection o2) {
                @NonNull List l1 = o1.getIndexes();
                @NonNull List l2 = o2.getIndexes();
                int x1 = l1.size() > 0 ? (Integer)l1.get(0) : -1;
                int x2 = l2.size() > 0 ? (Integer)l2.get(0) : -1;
                return x1 - x2;
            }
        });
        for (NodeConnection connection : connections) {
            if (!connection.isPassed()) continue;
            commonRegion = this.connection2commonRegion.get(connection);
            assert (commonRegion != null);
            intermediateRegions = new ArrayList();
            for (Region sourceRegion : this.scheduleCache.getSourceRegions((DatumConnection<?>)connection)) {
                if (sourceRegion == commonRegion) continue;
                List<@NonNull Region> sourceRegions = Collections.singletonList(sourceRegion);
                this.installConnectionsLocateIntermediates(intermediateRegions, sourceRegions, commonRegion);
            }
            for (Region targetRegion : this.scheduleCache.getTargetRegions((DatumConnection<?>)connection)) {
                if (targetRegion == commonRegion || !connection.isPassed(targetRegion)) continue;
                @NonNull Iterable targetRegions2 = targetRegion.getCallableParents();
                this.installConnectionsLocateIntermediates(intermediateRegions, targetRegions2, commonRegion);
            }
            connection.setCommonRegion(commonRegion, intermediateRegions);
        }
        for (NodeConnection connection : connections) {
            if (!connection.isPassed()) continue;
            commonRegion = connection.getCommonRegion();
            assert (commonRegion != null);
            intermediateRegions = connection.getIntermediateRegions();
            for (Region intermediateRegion : intermediateRegions) {
                Region checkCommonRegion;
                Object object = checkCommonRegion = commonRegion.getLoopingConnections().size() > 0 ? QVTscheduleUtil.getContainingScheduledRegion((Region)commonRegion) : commonRegion;
                assert (!(commonRegion.getLoopingConnections().size() > 0 ? !Iterables.contains((Iterable)commonRegion.getCallableParents(), (Object)this.getCommonRegion(commonRegion, intermediateRegion)) : this.getCommonRegion(commonRegion, intermediateRegion) != checkCommonRegion));
            }
        }
    }

    protected void installConnectionsLocateIntermediates(@NonNull List<@NonNull Region> intermediateRegions, @NonNull Iterable<@NonNull Region> callableParents, @NonNull Region commonRegion) {
        for (Region callableParent : callableParents) {
            if (callableParent == commonRegion || intermediateRegions.contains(callableParent)) continue;
            intermediateRegions.add(callableParent);
            this.installConnectionsLocateIntermediates(intermediateRegions, callableParent.getCallableParents(), commonRegion);
        }
    }

    protected void updateCallStack(@NonNull Stack<@NonNull Region> callStack, @NonNull Region region) {
        QVTm2QVTs.REGION_STACK.println(String.valueOf(region.getSymbolName()) + " => " + callStack);
        Region topOfStack = callStack.peek();
        assert (topOfStack != null);
        @NonNull Region commonRegion = this.getCommonRegion(topOfStack, region);
        for (DatumConnection<?> incomingConnection1 : this.scheduleCache.getIncomingConnections(region)) {
            for (Region sourceRegion1 : this.scheduleCache.getSourceRegions(incomingConnection1)) {
                for (DatumConnection<?> incomingConnection2 : this.scheduleCache.getIncomingConnections(sourceRegion1)) {
                    for (Region sourceRegion2 : this.scheduleCache.getSourceRegions(incomingConnection2)) {
                        commonRegion = this.getCommonRegion(commonRegion, sourceRegion2);
                    }
                }
            }
        }
        while (!callStack.contains(commonRegion)) {
            commonRegion = this.getMinimumDepthParentRegion(commonRegion);
            assert (commonRegion != null);
        }
        while (topOfStack != commonRegion && topOfStack != region) {
            callStack.pop();
            Region topOfStack2 = callStack.peek();
            assert (topOfStack2 != null);
            topOfStack = topOfStack2;
        }
        for (DatumConnection<?> incomingConnection : this.scheduleCache.getIncomingConnections(region)) {
            if (!incomingConnection.isPassed(region)) continue;
            commonRegion = this.updateConnectionLocality((NodeConnection)incomingConnection, commonRegion);
        }
        if (topOfStack != region) {
            topOfStack.addCallToChild(region);
            callStack.push(region);
            topOfStack = region;
        }
        assert (topOfStack == callStack.peek());
        assert (topOfStack == region);
    }

    protected @NonNull Region updateConnectionLocality(@NonNull NodeConnection connection, @NonNull Region commonStackRegion) {
        Region commonRegion;
        assert (connection.isPassed());
        Region oldCommonRegion = this.connection2commonRegion.get(connection);
        if (oldCommonRegion == null) {
            commonRegion = commonStackRegion;
            for (Region sourceRegion : this.scheduleCache.getSourceRegions((DatumConnection<?>)connection)) {
                commonRegion = this.getCommonRegion(commonRegion, sourceRegion);
            }
        } else {
            commonRegion = this.getCommonRegion(oldCommonRegion, commonStackRegion);
        }
        if (oldCommonRegion != commonRegion) {
            this.connection2commonRegion.put(connection, commonRegion);
        }
        return commonRegion;
    }
}

