/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.bigmde2016.tests.qvto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.StringBufferLog;
import org.eclipse.ocl.pivot.internal.resource.ProjectMap;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.qvtd.doc.bigmde2016.tests.FamiliesGenerator;
import org.eclipse.qvtd.doc.bigmde2016.tests.PrintAndLog;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.BigMDE2016CGTests;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.Families.FamiliesPackage;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.Persons.PersonsPackage;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvto.QVToSimpleUMLGenerator;
import org.junit.Test;
import rdb.RdbPackage;
import simpleuml.SimpleumlPackage;

public class BigMDE2016QVToTests
extends TestCase {
    @Test
    public void testQVToCompiler_UML2RDBMS() throws Exception {
        int[] tests;
        PrintAndLog logger = new PrintAndLog("results/" + this.getName());
        logger.printf("%s\n", this.getName());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("simpleuml", new XMIResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("rdb", new XMIResourceFactoryImpl());
        SimpleumlPackage.eINSTANCE.getClass();
        RdbPackage.eINSTANCE.getClass();
        ProjectMap projectMap = new ProjectMap(false);
        projectMap.initializeResourceSet(null);
        String uri = "platform:/resource/org.eclipse.qvtd.doc.bigmde2016.tests/src/org/eclipse/qvtd/doc/bigmde2016/tests/qvto/Simpleuml_To_Rdb.qvto";
        URI txURI = URI.createURI((String)uri, (boolean)true);
        TransformationExecutor transformationExecutor = new TransformationExecutor(txURI);
        Diagnostic diagnostic = transformationExecutor.loadTransformation();
        if (diagnostic.getSeverity() != 0) {
            StringBuilder s = new StringBuilder();
            s.append("Failed to load ");
            s.append(txURI);
            for (Diagnostic child : diagnostic.getChildren()) {
                s.append("\n  " + child.getMessage());
            }
            throw new Exception(String.valueOf(s.toString()) + txURI);
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        QVToSimpleUMLGenerator generator = new QVToSimpleUMLGenerator();
        int[] nArray = tests = PrintAndLog.getTestSizes();
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            int testSize;
            int nPackages = testSize = nArray[n2];
            int nClasses = testSize * 8;
            int nTypes = 0;
            int nProperties = 0;
            int nAssociations = 0;
            int nElements = nPackages + nClasses + nTypes + nProperties + nAssociations;
            ArrayList<@NonNull BasicModelExtent> modelExtents = new ArrayList<BasicModelExtent>();
            modelExtents.add(new BasicModelExtent(generator.createSimpleUMLModel(nPackages, nClasses, nTypes, nProperties, nAssociations)));
            modelExtents.add(new BasicModelExtent());
            StringBufferLog qvtoLog = new StringBufferLog();
            ExecutionContextImpl executionContext = new ExecutionContextImpl();
            executionContext.setLog((Log)qvtoLog);
            BigMDE2016CGTests.garbageCollect();
            logger.printf("%9d, ", nElements);
            long startTime = System.nanoTime();
            ExecutionDiagnostic executionDiagnostic = transformationExecutor.execute((ExecutionContext)executionContext, modelExtents.toArray(new ModelExtent[modelExtents.size()]));
            long endTime = System.nanoTime();
            logger.printf("%9.6f\n", (double)(endTime - startTime) / 1.0E9);
            if (executionDiagnostic.getSeverity() != 0) {
                StringBuilder s = new StringBuilder();
                s.append("Failed to execute ");
                s.append(txURI);
                s.append(": ");
                s.append(executionDiagnostic.getMessage());
                for (Diagnostic child : diagnostic.getChildren()) {
                    s.append("\n  " + child.getMessage());
                }
                throw new Exception(String.valueOf(s.toString()) + txURI);
            }
            String qvtoLogContents = qvtoLog.getContents().trim();
            URI outURI = URI.createURI((String)("src/org/eclipse/qvtd/doc/bigmde2016/tests/qvto/pim" + nElements + ".rdb"), (boolean)true);
            XMLResource outResource = (XMLResource)resourceSet.createResource(outURI, null);
            outResource.getContents().addAll((Collection)((ModelExtent)modelExtents.get(modelExtents.size() - 1)).getContents());
            int count = 0;
            for (Object eObject1 : outResource.getContents()) {
                for (EObject eObject2 : new TreeIterable((EObject)eObject1, true)) {
                    ++count;
                }
            }
            System.out.println(String.valueOf(outResource.getContents().size()) + " => " + count);
            Map options = XMIUtil.createSaveOptions();
            options.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
            options.put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
            options.put("SCHEMA_LOCATION", Boolean.TRUE);
            outResource.save(options);
            ++n2;
        }
        logger.dispose();
    }

    @Test
    public void testQVToCompiler_Families2Persons() throws Exception {
        int[] tests;
        PrintAndLog logger = new PrintAndLog("results/" + this.getName());
        logger.printf("%s\n", this.getName());
        FamiliesPackage.eINSTANCE.getClass();
        PersonsPackage.eINSTANCE.getClass();
        ProjectMap projectMap = new ProjectMap(false);
        projectMap.initializeResourceSet(null);
        String uri = "platform:/resource/org.eclipse.qvtd.doc.bigmde2016.tests/src/org/eclipse/qvtd/doc/bigmde2016/tests/qvto/Families2Persons.qvto";
        URI txURI = URI.createURI((String)uri, (boolean)true);
        TransformationExecutor transformationExecutor = new TransformationExecutor(txURI);
        Diagnostic diagnostic = transformationExecutor.loadTransformation();
        if (diagnostic.getSeverity() != 0) {
            StringBuilder s = new StringBuilder();
            s.append("Failed to load ");
            s.append(txURI);
            for (Diagnostic child : diagnostic.getChildren()) {
                s.append("\n  " + child.getMessage());
            }
            throw new Exception(String.valueOf(s.toString()) + txURI);
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        int[] nArray = tests = PrintAndLog.getTestSizes();
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            int testSize = nArray[n2];
            List<@NonNull ? extends EObject> rootObjects = FamiliesGenerator.createFamiliesModel(testSize, 9);
            ArrayList<@NonNull BasicModelExtent> modelExtents = new ArrayList<BasicModelExtent>();
            modelExtents.add(new BasicModelExtent(rootObjects));
            modelExtents.add(new BasicModelExtent());
            StringBufferLog qvtoLog = new StringBufferLog();
            ExecutionContextImpl executionContext = new ExecutionContextImpl();
            executionContext.setLog((Log)qvtoLog);
            BigMDE2016CGTests.garbageCollect();
            logger.printf("%9d, ", 10 * testSize);
            long startTime = System.nanoTime();
            ExecutionDiagnostic executionDiagnostic = transformationExecutor.execute((ExecutionContext)executionContext, modelExtents.toArray(new ModelExtent[modelExtents.size()]));
            long endTime = System.nanoTime();
            logger.printf("%9.6f\n", (double)(endTime - startTime) / 1.0E9);
            if (executionDiagnostic.getSeverity() != 0) {
                StringBuilder s = new StringBuilder();
                s.append("Failed to execute ");
                s.append(txURI);
                s.append(": ");
                s.append(executionDiagnostic.getMessage());
                for (Diagnostic child : diagnostic.getChildren()) {
                    s.append("\n  " + child.getMessage());
                }
                throw new Exception(String.valueOf(s.toString()) + txURI);
            }
            transformationExecutor.cleanup();
            String qvtoLogContents = qvtoLog.getContents().trim();
            URI outURI = URI.createURI((String)("src/org/eclipse/qvtd/doc/bigmde2016/tests/qvto/persons" + 10 * testSize + ".xmi"), (boolean)true);
            List contents = ((ModelExtent)modelExtents.get(modelExtents.size() - 1)).getContents();
            int count = 0;
            for (Object eObject1 : contents) {
                for (EObject eObject2 : new TreeIterable((EObject)eObject1, true)) {
                    ++count;
                }
            }
            ++n2;
        }
        logger.dispose();
    }
}

