/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.all.tests;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.NoHttpURIHandlerImpl;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.qvtd.xml.utilities.XMLmodelResourceFactoryImpl;
import org.eclipse.qvtd.xtext.qvtbase.tests.XtextTestCase;

public class XMLmodelTests
extends XtextTestCase {
    protected void doXMLtest(URI inURI, boolean doCompare) throws Exception {
        String testExtension = inURI.fileExtension();
        String testFileName = inURI.trimFileExtension().lastSegment();
        ProjectManager projectManager = this.getTestProjectManager();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        projectManager.initializeResourceSet((ResourceSet)resourceSet);
        TestProject testProject = this.getTestProject();
        TestFile outFile = testProject.getOutputFile(String.valueOf(testFileName) + ".out." + testExtension);
        TestFile xmlFile = testProject.getOutputFile(String.valueOf(testFileName) + ".xml");
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(testExtension, new XMLmodelResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
        Resource xmlResource = resourceSet.getResource(inURI, true);
        xmlResource.toString();
        URI xmlURI = xmlFile.getURI();
        URI outURI = outFile.getURI();
        xmlResource.setURI(outURI);
        xmlResource.save(XMIUtil.createSaveOptions());
        Resource xmlResource2 = resourceSet.createResource(xmlURI);
        xmlResource2.getContents().addAll((Collection)xmlResource.getContents());
        xmlResource2.save(XMIUtil.createSaveOptions());
        if (doCompare) {
            ResourceSetImpl resourceSet2 = new ResourceSetImpl();
            NoHttpURIHandlerImpl.install((ResourceSet)resourceSet2);
            projectManager.initializeResourceSet((ResourceSet)resourceSet2);
            projectManager.configure((ResourceSet)resourceSet2, StandaloneProjectMap.LoadFirstStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
            resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
            resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMLResourceFactoryImpl());
            Resource resource1 = resourceSet2.getResource(inURI, true);
            Resource resource2 = resourceSet2.getResource(outURI, true);
            assert (resource1 != null && resource2 != null);
            TestUtil.assertSameModel((Resource)resource1, (Resource)resource2);
        }
    }

    public static void assertSameModel(@NonNull Resource expectedResource, @NonNull Resource actualResource) throws IOException, InterruptedException {
        TestUtil.assertSameModel((Resource)expectedResource, (Resource)actualResource);
    }

    public void testXML_junit_noframes_xsl() throws Exception {
        String inPath = String.valueOf(this.getTestBundleName()) + "/models/junit-noframes.xsl";
        URI inURI = URI.createPlatformResourceURI((String)inPath, (boolean)true);
        this.doXMLtest(inURI, false);
    }

    public void testXML_Ecore_ecore() throws Exception {
        String inPath = "org.eclipse.emf.ecore/model/Ecore.ecore";
        URI inURI = URI.createPlatformResourceURI((String)inPath, (boolean)true);
        this.doXMLtest(inURI, true);
    }
}

