/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtrelation.tests;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.UnresolvedReferenceException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystemHelper;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.examples.xtext.tests.TestUIUtil;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.qvtd.xtext.qvtbase.tests.XtextTestCase;
import org.eclipse.qvtd.xtext.qvtrelation.tests.FlatStateMachineNormalizer;
import org.eclipse.qvtd.xtext.qvtrelation.tests.Forward2ReverseNormalizer;
import org.eclipse.qvtd.xtext.qvtrelation.tests.QVTrelationTestFileSystemHelper;

public class QVTrDebuggerTests
extends XtextTestCase {
    protected ILaunchConfigurationWorkingCopy createLaunchConfiguration(@NonNull TestProject testProject, @NonNull String launchName, @NonNull TestFile txFile, @NonNull String direction, @NonNull Map<String, String> newInKeys, @NonNull Map<String, String> newOutKeys, boolean interpreted) throws CoreException {
        URI stem = txFile.getURI().trimFileExtension();
        URI stemStem = stem.trimSegments(1);
        HashMap<String, String> intermediateKeys = new HashMap<String, String>();
        intermediateKeys.put("QVTi", stem.appendFileExtension("qvtias").toString());
        if (!interpreted) {
            intermediateKeys.put("GenModel", stem.appendFileExtension("genmodel").toString());
            intermediateKeys.put("Java", stemStem.appendSegment("test-src").toString());
            intermediateKeys.put("Class", stemStem.appendSegment("bin").toString());
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.qvtd.debug.launching.QVTrLaunchConfigurationDelegate");
        ILaunchConfigurationWorkingCopy launchConfiguration = launchConfigurationType.newInstance((IContainer)testProject.getIProject(), launchName);
        launchConfiguration.setAttribute("tx", txFile.getURI().toString());
        launchConfiguration.setAttribute("direction", direction);
        launchConfiguration.setAttribute("dot-graphs", (Object)Boolean.TRUE);
        launchConfiguration.setAttribute("genmodel", stem.appendFileExtension("genmodel").toString());
        launchConfiguration.setAttribute("intermediates", intermediateKeys);
        launchConfiguration.setAttribute("interpreted", interpreted);
        launchConfiguration.setAttribute("in", newInKeys);
        launchConfiguration.setAttribute("out", newOutKeys);
        launchConfiguration.setAttribute("project", testProject.getName());
        launchConfiguration.setAttribute("console-trace", false);
        launchConfiguration.setAttribute("yed-graphs", (Object)Boolean.TRUE);
        return launchConfiguration;
    }

    protected @NonNull String getProjectName() {
        return (String)ClassUtil.nonNullState((Object)((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/'));
    }

    protected @NonNull TestFileSystemHelper getTestFileSystemHelper() {
        return new QVTrelationTestFileSystemHelper(){

            protected void appendBuildSpec(@NonNull Writer s) throws IOException {
            }

            protected void appendNatures(@NonNull Writer s) throws IOException {
            }
        };
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void testDebugger_Run_Forward2Reverse() throws Exception {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return;
        }
        @NonNull String inName = "forward";
        @NonNull String outName = "reverse";
        @NonNull String middleName = "middle";
        TestUIUtil.closeIntro();
        OCL ocl = OCL.newInstance((ProjectManager)OCL.CLASS_PATH);
        URIConverter uriConverter = ocl.getResourceSet().getURIConverter();
        TestProject testProject = this.getTestProject();
        TestFile txFile = testProject.copyFile(uriConverter, null, this.getModelsURI("forward2reverse/Forward2Reverse.qvtr"));
        TestFile inFile = testProject.copyFile(uriConverter, null, this.getModelsURI("forward2reverse/samples/ThreeElementList.xmi"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("forward2reverse/DoublyLinkedList.ecore"));
        TestFile outFile = testProject.getOutputFile("ThreeElementReversedList.xmi");
        TestFile middleFile = testProject.getOutputFile("Forward2Reverse.xmi");
        HashMap<String, String> inMap = new HashMap<String, String>();
        inMap.put("forward", inFile.getURI().toString());
        HashMap<String, String> outMap = new HashMap<String, String>();
        outMap.put("reverse", outFile.getURI().toString());
        outMap.put("middle", middleFile.getURI().toString());
        ILaunchConfigurationWorkingCopy launchConfiguration = this.createLaunchConfiguration(testProject, "Forward2Reverse", txFile, "reverse", inMap, outMap, true);
        launchConfiguration.doSave();
        TestUIUtil.flushEvents();
        ILaunch launch = launchConfiguration.launch("run", null, true);
        assert (launch != null);
        @NonNull List allResults = TestUIUtil.waitForLaunchToTerminate((ILaunch)launch);
        assert (allResults != null);
        assert (allResults.size() == 1);
        QVTrDebuggerTests.assertEquals((int)0, (int)((IStatus)allResults.get(0)).getSeverity());
        int i = 0;
        while (i < 10) {
            testProject.getIProject().refreshLocal(2, null);
            if (outFile.getFile().exists()) break;
            TestUIUtil.wait((int)1000);
            ++i;
        }
        ResourceSetImpl expectedResourceSet = new ResourceSetImpl();
        ocl.getProjectManager().initializeResourceSet((ResourceSet)expectedResourceSet);
        Resource expectedResource = expectedResourceSet.getResource(this.getModelsURI("forward2reverse/samples/ThreeElementList_expected.xmi"), true);
        assert (expectedResource != null);
        ResourceSetImpl actualResourceSet = new ResourceSetImpl();
        Resource actualResource = actualResourceSet.getResource(outFile.getURI(), true);
        assert (actualResource != null);
        Forward2ReverseNormalizer normalizer = Forward2ReverseNormalizer.INSTANCE;
        normalizer.normalize(expectedResource);
        normalizer.normalize(actualResource);
        TestUtil.assertSameModel((Resource)expectedResource, (Resource)actualResource);
        ocl.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void testDebugger_Run_BadForward2Reverse() throws Exception {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return;
        }
        @NonNull String inName = "forward";
        @NonNull String outName = "reverse";
        @NonNull String middleName = "middle";
        TestUIUtil.closeIntro();
        OCL ocl = OCL.newInstance((ProjectManager)OCL.CLASS_PATH);
        URIConverter uriConverter = ocl.getResourceSet().getURIConverter();
        TestProject testProject = this.getTestProject();
        TestFile txFile = testProject.copyFile(uriConverter, null, this.getModelsURI("forward2reverse/Forward2Reverse.qvtr"));
        TestFile inFile = testProject.copyFile(uriConverter, null, this.getModelsURI("forward2reverse/samples/BadThreeElementList.xmi"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("forward2reverse/DoublyLinkedList.ecore"));
        TestFile outFile = testProject.getOutputFile("ThreeElementReversedList.xmi");
        TestFile middleFile = testProject.getOutputFile("Forward2Reverse.xmi");
        HashMap<String, String> inMap = new HashMap<String, String>();
        inMap.put("forward", inFile.getURI().toString());
        HashMap<String, String> outMap = new HashMap<String, String>();
        outMap.put("reverse", outFile.getURI().toString());
        outMap.put("middle", middleFile.getURI().toString());
        ILaunchConfigurationWorkingCopy launchConfiguration = this.createLaunchConfiguration(testProject, "Forward2Reverse", txFile, "reverse", inMap, outMap, true);
        launchConfiguration.doSave();
        TestUIUtil.flushEvents();
        ILaunch launch = launchConfiguration.launch("run", null, true);
        assert (launch != null);
        @NonNull List allResults = TestUIUtil.waitForLaunchToTerminate((ILaunch)launch);
        assert (allResults != null);
        assert (allResults.size() == 1);
        QVTrDebuggerTests.assertEquals((int)1, (int)((IStatus)allResults.get(0)).getSeverity());
        QVTrDebuggerTests.assertEquals(UnresolvedReferenceException.class, ((IStatus)allResults.get(0)).getException().getClass());
        ocl.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void testDebugger_Run_MissingForward2Reverse() throws Exception {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return;
        }
        @NonNull String inName = "forward";
        @NonNull String outName = "reverse";
        @NonNull String middleName = "middle";
        TestUIUtil.closeIntro();
        OCL ocl = OCL.newInstance((ProjectManager)OCL.CLASS_PATH);
        URIConverter uriConverter = ocl.getResourceSet().getURIConverter();
        TestProject testProject = this.getTestProject();
        TestFile txFile = testProject.copyFile(uriConverter, null, this.getModelsURI("forward2reverse/Forward2Reverse.qvtr"));
        TestFile inFile = testProject.copyFile(uriConverter, null, this.getModelsURI("forward2reverse/samples/ThreeElementList.xmi"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("forward2reverse/DoublyLinkedList.ecore"));
        TestFile outFile = testProject.getOutputFile("ThreeElementReversedList.xmi");
        TestFile middleFile = testProject.getOutputFile("Forward2Reverse.xmi");
        HashMap<String, String> inMap = new HashMap<String, String>();
        inMap.put("forward", inFile.getURI().appendFileExtension("xmi").toString());
        HashMap<String, String> outMap = new HashMap<String, String>();
        outMap.put("reverse", outFile.getURI().toString());
        outMap.put("middle", middleFile.getURI().toString());
        ILaunchConfigurationWorkingCopy launchConfiguration = this.createLaunchConfiguration(testProject, "Forward2Reverse", txFile, "reverse", inMap, outMap, true);
        launchConfiguration.doSave();
        TestUIUtil.flushEvents();
        ILaunch launch = launchConfiguration.launch("run", null, true);
        assert (launch != null);
        @NonNull List allResults = TestUIUtil.waitForLaunchToTerminate((ILaunch)launch);
        assert (allResults != null);
        assert (allResults.size() == 1);
        QVTrDebuggerTests.assertEquals((int)1, (int)((IStatus)allResults.get(0)).getSeverity());
        QVTrDebuggerTests.assertEquals(ResourceException.class, ((IStatus)allResults.get(0)).getException().getClass());
        ocl.dispose();
    }

    public void testDebugger_Run_hstm2fstm() throws Exception {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return;
        }
        @NonNull String inName = "hier";
        @NonNull String outName = "flat";
        @NonNull String middleName = "middle";
        TestUIUtil.closeIntro();
        OCL ocl = OCL.newInstance((ProjectManager)OCL.CLASS_PATH);
        URIConverter uriConverter = ocl.getResourceSet().getURIConverter();
        TestProject testProject = this.getTestProject();
        TestFile txFile = testProject.copyFile(uriConverter, null, this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr"));
        TestFile inFile = testProject.copyFile(uriConverter, null, this.getModelsURI("hstm2fstm/samples/SimpleModel.xmi"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("hstm2fstm/FlatStateMachine.ecore"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("hstm2fstm/HierarchicalStateMachine.ecore"));
        TestFile outFile = testProject.getOutputFile("FlatModel.xmi");
        TestFile middleFile = testProject.getOutputFile("HierarchicalStateMachine2FlatStateMachine.xmi");
        HashMap<String, String> inMap = new HashMap<String, String>();
        inMap.put("hier", inFile.getURI().toString());
        HashMap<String, String> outMap = new HashMap<String, String>();
        outMap.put("flat", outFile.getURI().toString());
        outMap.put("middle", middleFile.getURI().toString());
        ILaunchConfigurationWorkingCopy launchConfiguration = this.createLaunchConfiguration(testProject, "HierarchicalStateMachine2FlatStateMachine", txFile, "flat", inMap, outMap, true);
        launchConfiguration.doSave();
        TestUIUtil.flushEvents();
        ILaunch launch = launchConfiguration.launch("run", null, true);
        assert (launch != null);
        TestUIUtil.waitForLaunchToTerminate((ILaunch)launch);
        int i = 0;
        while (i < 10) {
            testProject.getIProject().refreshLocal(2, null);
            if (outFile.getFile().exists()) break;
            TestUIUtil.wait((int)1000);
            ++i;
        }
        ResourceSetImpl expectedResourceSet = new ResourceSetImpl();
        ocl.getProjectManager().initializeResourceSet((ResourceSet)expectedResourceSet);
        Resource expectedResource = expectedResourceSet.getResource(this.getModelsURI("hstm2fstm/samples/SimpleModel_expected.xmi"), true);
        assert (expectedResource != null);
        ResourceSetImpl actualResourceSet = new ResourceSetImpl();
        Resource actualResource = actualResourceSet.getResource(outFile.getURI(), true);
        assert (actualResource != null);
        FlatStateMachineNormalizer normalizer = FlatStateMachineNormalizer.INSTANCE;
        normalizer.normalize(expectedResource);
        normalizer.normalize(actualResource);
        TestUtil.assertSameModel((Resource)expectedResource, (Resource)actualResource);
        ocl.dispose();
    }

    public void testDebugger_Run_hstm2fstm_CG() throws Exception {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return;
        }
        @NonNull String inName = "hier";
        @NonNull String outName = "flat";
        @NonNull String middleName = "middle";
        TestUIUtil.closeIntro();
        OCL ocl = OCL.newInstance((ProjectManager)OCL.CLASS_PATH);
        URIConverter uriConverter = ocl.getResourceSet().getURIConverter();
        TestProject testProject = this.getTestProject();
        TestFile txFile = testProject.copyFile(uriConverter, null, this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr"));
        TestFile inFile = testProject.copyFile(uriConverter, null, this.getModelsURI("hstm2fstm/samples/SimpleModel.xmi"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("hstm2fstm/FlatStateMachine.ecore"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("hstm2fstm/HierarchicalStateMachine.ecore"));
        TestFile outFile = testProject.getOutputFile("FlatModel.xmi");
        TestFile middleFile = testProject.getOutputFile("HierarchicalStateMachine2FlatStateMachine.xmi");
        HashMap<String, String> inMap = new HashMap<String, String>();
        inMap.put("hier", inFile.getURI().toString());
        HashMap<String, String> outMap = new HashMap<String, String>();
        outMap.put("flat", outFile.getURI().toString());
        outMap.put("middle", middleFile.getURI().toString());
        ILaunchConfigurationWorkingCopy launchConfiguration = this.createLaunchConfiguration(testProject, "HierarchicalStateMachine2FlatStateMachine", txFile, "flat", inMap, outMap, false);
        launchConfiguration.doSave();
        TestUIUtil.flushEvents();
        ILaunch launch = launchConfiguration.launch("run", null, true);
        assert (launch != null);
        TestUIUtil.waitForLaunchToTerminate((ILaunch)launch);
        int i = 0;
        while (i < 10) {
            testProject.getIProject().refreshLocal(2, null);
            if (outFile.getFile().exists()) break;
            TestUIUtil.wait((int)1000);
            ++i;
        }
        ResourceSetImpl expectedResourceSet = new ResourceSetImpl();
        ocl.getProjectManager().initializeResourceSet((ResourceSet)expectedResourceSet);
        Resource expectedResource = expectedResourceSet.getResource(this.getModelsURI("hstm2fstm/samples/SimpleModel_expected.xmi"), true);
        assert (expectedResource != null);
        ResourceSetImpl actualResourceSet = new ResourceSetImpl();
        Resource actualResource = actualResourceSet.getResource(outFile.getURI(), true);
        assert (actualResource != null);
        FlatStateMachineNormalizer normalizer = FlatStateMachineNormalizer.INSTANCE;
        normalizer.normalize(expectedResource);
        normalizer.normalize(actualResource);
        TestUtil.assertSameModel((Resource)expectedResource, (Resource)actualResource);
        ocl.dispose();
    }
}

