/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableIntFloatMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableIntFloatMap;
import org.eclipse.collections.api.map.primitive.IntFloatMap;
import org.eclipse.collections.impl.factory.primitive.IntFloatMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntFloatEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntFloatHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntFloatSingletonMap;

@ServiceProvider(value=ImmutableIntFloatMapFactory.class)
public class ImmutableIntFloatMapFactoryImpl
implements ImmutableIntFloatMapFactory {
    public static final ImmutableIntFloatMapFactory INSTANCE = new ImmutableIntFloatMapFactoryImpl();

    public ImmutableIntFloatMap empty() {
        return ImmutableIntFloatEmptyMap.INSTANCE;
    }

    public ImmutableIntFloatMap of() {
        return this.empty();
    }

    public ImmutableIntFloatMap with() {
        return this.empty();
    }

    public ImmutableIntFloatMap of(int key, float value) {
        return this.with(key, value);
    }

    public ImmutableIntFloatMap with(int key, float value) {
        return new ImmutableIntFloatSingletonMap(key, value);
    }

    public ImmutableIntFloatMap ofAll(IntFloatMap map) {
        return this.withAll(map);
    }

    public ImmutableIntFloatMap withAll(IntFloatMap map) {
        if (map instanceof ImmutableIntFloatMap) {
            return (ImmutableIntFloatMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            int key = map.keysView().intIterator().next();
            return new ImmutableIntFloatSingletonMap(key, map.get(key));
        }
        return new ImmutableIntFloatHashMap(map);
    }

    public <T> ImmutableIntFloatMap from(Iterable<T> iterable, IntFunction<? super T> keyFunction, FloatFunction<? super T> valueFunction) {
        return IntFloatMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

