/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.databinding;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;

abstract class ListeningValue<T>
extends AbstractObservableValue<T> {
    private T value;
    private boolean isListening;
    private volatile boolean hasListeners;

    public ListeningValue(Realm realm) {
        super(realm);
    }

    protected final T doGetValue() {
        if (this.isListening) {
            return this.value;
        }
        return this.calculate();
    }

    protected final void protectedSetValue(T value) {
        this.checkRealm();
        if (!this.isListening) {
            throw new IllegalStateException();
        }
        if (this.value != value) {
            this.value = value;
            this.fireValueChange(Diffs.createValueDiff(this.value, this.value));
        }
    }

    protected final void firstListenerAdded() {
        if (this.getRealm().isCurrent()) {
            this.startListeningInternal();
        } else {
            this.getRealm().asyncExec(() -> {
                if (this.hasListeners && !this.isListening) {
                    this.startListeningInternal();
                }
            });
        }
        this.hasListeners = true;
        super.firstListenerAdded();
    }

    protected final void lastListenerRemoved() {
        if (this.getRealm().isCurrent()) {
            this.stopListeningInternal();
        } else {
            this.getRealm().asyncExec(() -> {
                if (!this.hasListeners && this.isListening) {
                    this.stopListeningInternal();
                }
            });
        }
        this.hasListeners = false;
        super.lastListenerRemoved();
    }

    private void startListeningInternal() {
        this.isListening = true;
        this.value = this.calculate();
        this.startListening();
    }

    private void stopListeningInternal() {
        this.isListening = false;
        this.value = null;
        this.stopListening();
    }

    protected abstract void startListening();

    protected abstract void stopListening();

    protected abstract T calculate();
}

