/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.views.markers.internal.MarkerGroup;

public class AttributeMarkerGrouping {
    private static final String DEFAULT_GROUPING_ENTRY = "defaultGroupingEntry";
    private static final String MARKER_TYPE = "markerType";
    private static final String ATTRIBUTE = "attribute";
    private final String attribute;
    private final String markerType;
    private final String defaultGroupingEntry;
    private final IConfigurationElement element;
    private final Collection<MarkerGroup> groups = new HashSet<MarkerGroup>();

    public AttributeMarkerGrouping(IConfigurationElement element) {
        this.attribute = element.getAttribute(ATTRIBUTE);
        this.markerType = element.getAttribute(MARKER_TYPE);
        this.defaultGroupingEntry = element.getAttribute(DEFAULT_GROUPING_ENTRY);
        this.element = element;
    }

    public String getDefaultGroupingEntry() {
        return this.defaultGroupingEntry;
    }

    public String getMarkerType() {
        return this.markerType;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public IConfigurationElement getElement() {
        return this.element;
    }

    public void addGroup(MarkerGroup markerGroup) {
        this.groups.add(markerGroup);
    }

    public void unmap() {
        for (MarkerGroup group : this.groups) {
            group.unmap(this);
        }
    }
}

