/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.ImageGcDrawer;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.SWTFontProvider;
import org.eclipse.swt.internal.gdip.BitmapData;
import org.eclipse.swt.internal.gdip.ColorPalette;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.DIBSECTION;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    int transparentPixel = -1;
    int transparentColor = -1;
    GC memGC;
    private AbstractImageProviderWrapper imageProvider;
    private int styleFlag = 0;
    private int initialNativeZoom = 100;
    static final int DEFAULT_SCANLINE_PAD = 4;
    private Map<Integer, ImageHandle> zoomLevelToImageHandle = new HashMap<Integer, ImageHandle>();
    static int count = 0;

    Image(Device device) {
        this(device, DPIUtil.getNativeDeviceZoom());
    }

    private Image(Device device, int nativeZoom) {
        super(device);
        this.initialNativeZoom = nativeZoom;
    }

    public Image(Device device, int width, int height) {
        this(device, width, height, DPIUtil.getNativeDeviceZoom());
    }

    private Image(Device device, int width, int height, int nativeZoom) {
        super(device);
        this.initialNativeZoom = nativeZoom;
        int zoom = this.getZoom();
        width = DPIUtil.scaleUp(width, zoom);
        height = DPIUtil.scaleUp(height, zoom);
        this.init(width, height);
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, Image srcImage, int flag) {
        super(device);
        device = this.device;
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rect = srcImage.getBoundsInPixels();
        this.type = srcImage.type;
        if (srcImage.imageProvider != null) {
            this.imageProvider = srcImage.imageProvider.createCopy(this);
        }
        this.styleFlag = srcImage.styleFlag | flag;
        this.initialNativeZoom = srcImage.initialNativeZoom;
        long srcImageHandle = Image.win32_getHandle(srcImage, this.getZoom());
        block0 : switch (flag) {
            case 0: {
                switch (this.type) {
                    case 0: {
                        long hDC = device.internal_new_GC(null);
                        long hdcSource = OS.CreateCompatibleDC(hDC);
                        long hdcDest = OS.CreateCompatibleDC(hDC);
                        long hOldSrc = OS.SelectObject(hdcSource, srcImageHandle);
                        BITMAP bm = new BITMAP();
                        OS.GetObject(srcImageHandle, BITMAP.sizeof, bm);
                        ImageHandle imageMetadata = new ImageHandle(OS.CreateCompatibleBitmap(hdcSource, rect.width, bm.bmBits != 0L ? -rect.height : rect.height), this.getZoom());
                        if (imageMetadata.handle == 0L) {
                            SWT.error(2);
                        }
                        long hOldDest = OS.SelectObject(hdcDest, imageMetadata.handle);
                        OS.BitBlt(hdcDest, 0, 0, rect.width, rect.height, hdcSource, 0, 0, 0xCC0020);
                        OS.SelectObject(hdcSource, hOldSrc);
                        OS.SelectObject(hdcDest, hOldDest);
                        OS.DeleteDC(hdcSource);
                        OS.DeleteDC(hdcDest);
                        device.internal_dispose_GC(hDC, null);
                        this.transparentPixel = srcImage.transparentPixel;
                        break;
                    }
                    case 1: {
                        ImageHandle imageMetadata = new ImageHandle(OS.CopyImage(srcImageHandle, 1, rect.width, rect.height, 0), this.getZoom());
                        if (imageMetadata.handle != 0L) break block0;
                        SWT.error(2);
                        break;
                    }
                    default: {
                        SWT.error(40);
                        break;
                    }
                }
                break;
            }
            case 1: {
                ImageData data = srcImage.getImageData(srcImage.getZoom());
                ImageData newData = this.applyDisableImageData(data, rect.height, rect.width);
                this.init(newData, (Integer)this.getZoom());
                break;
            }
            case 2: {
                ImageData data = srcImage.getImageData(srcImage.getZoom());
                ImageData newData = this.applyGrayImageData(data, rect.height, rect.width);
                this.init(newData, (Integer)this.getZoom());
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, Rectangle bounds) {
        super(device);
        if (bounds == null) {
            SWT.error(4);
        }
        this.initialNativeZoom = DPIUtil.getNativeDeviceZoom();
        bounds = DPIUtil.scaleUp(bounds, this.getZoom());
        this.init(bounds.width, bounds.height);
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, ImageData data) {
        super(device);
        if (data == null) {
            SWT.error(4);
        }
        this.initialNativeZoom = DPIUtil.getNativeDeviceZoom();
        data = DPIUtil.autoScaleUp(device, new DPIUtil.ElementAtZoom<ImageData>(data, 100));
        this.init(data, (Integer)this.getZoom());
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, ImageData source, ImageData mask) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            SWT.error(4);
        }
        if (source.width != mask.width || source.height != mask.height) {
            SWT.error(5);
        }
        this.initialNativeZoom = DPIUtil.getNativeDeviceZoom();
        source = DPIUtil.autoScaleUp(device, source);
        mask = DPIUtil.autoScaleUp(device, mask);
        mask = ImageData.convertMask(mask);
        Image.init(this.device, this, source, mask, this.getZoom());
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, InputStream stream) {
        super(device);
        this.initialNativeZoom = DPIUtil.getNativeDeviceZoom();
        ImageData data = DPIUtil.autoScaleUp(device, new DPIUtil.ElementAtZoom<ImageData>(new ImageData(stream), 100));
        this.init(data, (Integer)this.getZoom());
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, String filename) {
        super(device);
        if (filename == null) {
            SWT.error(4);
        }
        this.initialNativeZoom = DPIUtil.getNativeDeviceZoom();
        ImageData data = DPIUtil.autoScaleUp(device, new DPIUtil.ElementAtZoom<ImageData>(new ImageData(filename), 100));
        this.init(data, (Integer)this.getZoom());
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, ImageFileNameProvider imageFileNameProvider) {
        super(device);
        this.imageProvider = new ImageFileNameProviderWrapper(imageFileNameProvider);
        this.initialNativeZoom = DPIUtil.getNativeDeviceZoom();
        DPIUtil.ElementAtZoom<String> fileName = DPIUtil.validateAndGetImagePathAtZoom(imageFileNameProvider, this.getZoom());
        if (fileName.zoom() == this.getZoom()) {
            ImageHandle imageMetadata = this.initNative(fileName.element(), this.getZoom());
            if (imageMetadata == null) {
                this.init(new ImageData(fileName.element()), (Integer)this.getZoom());
            }
        } else {
            ImageData resizedData = DPIUtil.autoScaleImageData(device, new ImageData(fileName.element()), fileName.zoom());
            this.init(resizedData, (Integer)this.getZoom());
        }
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, ImageDataProvider imageDataProvider) {
        super(device);
        this.imageProvider = new ImageDataProviderWrapper(imageDataProvider);
        this.initialNativeZoom = DPIUtil.getNativeDeviceZoom();
        DPIUtil.ElementAtZoom<ImageData> data = DPIUtil.validateAndGetImageDataAtZoom(imageDataProvider, this.getZoom());
        ImageData resizedData = DPIUtil.scaleImageData(device, data.element(), this.getZoom(), data.zoom());
        this.init(resizedData, (Integer)this.getZoom());
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, ImageGcDrawer imageGcDrawer, int width, int height) {
        super(device);
        this.imageProvider = new ImageGcDrawerWrapper(imageGcDrawer, width, height);
        this.initialNativeZoom = DPIUtil.getNativeDeviceZoom();
        this.init();
    }

    private ImageData adaptImageDataIfDisabledOrGray(ImageData data) {
        ImageData returnImageData = null;
        switch (this.styleFlag) {
            case 1: {
                ImageData newData;
                returnImageData = newData = this.applyDisableImageData(data, data.height, data.width);
                break;
            }
            case 2: {
                ImageData newData;
                returnImageData = newData = this.applyGrayImageData(data, data.height, data.width);
                break;
            }
            default: {
                returnImageData = data;
            }
        }
        return returnImageData;
    }

    private ImageData applyDisableImageData(ImageData data, int height, int width) {
        PaletteData palette = data.palette;
        RGB[] rgbs = new RGB[]{this.device.getSystemColor(2).getRGB(), this.device.getSystemColor(18).getRGB(), this.device.getSystemColor(22).getRGB()};
        ImageData newData = new ImageData(width, height, 8, new PaletteData(rgbs));
        newData.alpha = data.alpha;
        newData.alphaData = data.alphaData;
        newData.maskData = data.maskData;
        newData.maskPad = data.maskPad;
        if (data.transparentPixel != -1) {
            newData.transparentPixel = 0;
        }
        int[] scanline = new int[width];
        int[] maskScanline = null;
        ImageData mask = null;
        if (data.maskData != null) {
            mask = data.getTransparencyMask();
        }
        if (mask != null) {
            maskScanline = new int[width];
        }
        int redMask = palette.redMask;
        int greenMask = palette.greenMask;
        int blueMask = palette.blueMask;
        int redShift = palette.redShift;
        int greenShift = palette.greenShift;
        int blueShift = palette.blueShift;
        int y = 0;
        while (y < height) {
            int offset = y * newData.bytesPerLine;
            data.getPixels(0, y, width, scanline, 0);
            if (mask != null) {
                mask.getPixels(0, y, width, maskScanline, 0);
            }
            int x = 0;
            while (x < width) {
                int pixel = scanline[x];
                if (!(data.transparentPixel != -1 && pixel == data.transparentPixel || mask != null && maskScanline[x] == 0)) {
                    int blue;
                    int green;
                    int red;
                    if (palette.isDirect) {
                        red = pixel & redMask;
                        red = redShift < 0 ? red >>> -redShift : red << redShift;
                        green = pixel & greenMask;
                        green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                        blue = pixel & blueMask;
                        blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                    } else {
                        red = palette.colors[pixel].red;
                        green = palette.colors[pixel].green;
                        blue = palette.colors[pixel].blue;
                    }
                    int intensity = red * red + green * green + blue * blue;
                    newData.data[offset] = intensity < 98304 ? 1 : 2;
                }
                ++offset;
                ++x;
            }
            ++y;
        }
        return newData;
    }

    private ImageData applyGrayImageData(ImageData data, int pHeight, int pWidth) {
        PaletteData palette = data.palette;
        ImageData newData = data;
        if (!palette.isDirect) {
            RGB[] rgbs = palette.getRGBs();
            int i = 0;
            while (i < rgbs.length) {
                if (data.transparentPixel != i) {
                    int intensity;
                    RGB color = rgbs[i];
                    int red = color.red;
                    int green = color.green;
                    int blue = color.blue;
                    color.green = color.blue = (intensity = red + red + green + green + green + green + green + blue >> 3);
                    color.red = color.blue;
                }
                ++i;
            }
            newData.palette = new PaletteData(rgbs);
        } else {
            RGB[] rgbs = new RGB[256];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(i, i, i);
                ++i;
            }
            newData = new ImageData(pWidth, pHeight, 8, new PaletteData(rgbs));
            newData.alpha = data.alpha;
            newData.alphaData = data.alphaData;
            newData.maskData = data.maskData;
            newData.maskPad = data.maskPad;
            if (data.transparentPixel != -1) {
                newData.transparentPixel = 254;
            }
            int[] scanline = new int[pWidth];
            int redMask = palette.redMask;
            int greenMask = palette.greenMask;
            int blueMask = palette.blueMask;
            int redShift = palette.redShift;
            int greenShift = palette.greenShift;
            int blueShift = palette.blueShift;
            int y = 0;
            while (y < pHeight) {
                int offset = y * newData.bytesPerLine;
                data.getPixels(0, y, pWidth, scanline, 0);
                int x = 0;
                while (x < pWidth) {
                    int pixel = scanline[x];
                    if (pixel != data.transparentPixel) {
                        int red = pixel & redMask;
                        red = redShift < 0 ? red >>> -redShift : red << redShift;
                        int green = pixel & greenMask;
                        green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                        int blue = pixel & blueMask;
                        blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                        int intensity = red + red + green + green + green + green + green + blue >> 3;
                        if (newData.transparentPixel == intensity) {
                            intensity = 255;
                        }
                        newData.data[offset] = (byte)intensity;
                    } else {
                        newData.data[offset] = -2;
                    }
                    ++offset;
                    ++x;
                }
                ++y;
            }
        }
        return newData;
    }

    private ImageHandle getImageMetadata(int zoom) {
        if (this.zoomLevelToImageHandle.get(zoom) != null) {
            return this.zoomLevelToImageHandle.get(zoom);
        }
        if (this.imageProvider != null) {
            return this.imageProvider.getImageMetadata(zoom);
        }
        ImageData resizedData = this.getImageData(zoom);
        ImageData newData = this.adaptImageDataIfDisabledOrGray(resizedData);
        this.init(newData, (Integer)zoom);
        this.init();
        return this.zoomLevelToImageHandle.get(zoom);
    }

    public static long win32_getHandle(Image image, int zoom) {
        if (image.isDisposed()) {
            return 0L;
        }
        return image.getImageMetadata((int)zoom).handle;
    }

    ImageHandle initNative(String filename, int zoom) {
        ImageHandle imageMetadata = null;
        long handle = 0L;
        int width = -1;
        int height = -1;
        this.device.checkGDIP();
        boolean gdip = true;
        if (gdip && C.PTR_SIZEOF == 8 && filename.toLowerCase().endsWith(".gif")) {
            gdip = false;
        }
        if (filename.toLowerCase().endsWith(".gif")) {
            gdip = false;
        }
        if (gdip) {
            int length = filename.length();
            char[] chars = new char[length + 1];
            filename.getChars(0, length, chars, 0);
            long bitmap = Gdip.Bitmap_new(chars, false);
            if (bitmap != 0L) {
                int error = 2;
                int status = Gdip.Image_GetLastStatus(bitmap);
                if (status == 0) {
                    if (filename.toLowerCase().endsWith(".ico")) {
                        this.type = 1;
                        long[] hicon = new long[1];
                        status = Gdip.Bitmap_GetHICON(bitmap, hicon);
                        handle = hicon[0];
                        imageMetadata = new ImageHandle(handle, zoom);
                    } else {
                        this.type = 0;
                        width = Gdip.Image_GetWidth(bitmap);
                        height = Gdip.Image_GetHeight(bitmap);
                        int pixelFormat = Gdip.Image_GetPixelFormat(bitmap);
                        switch (pixelFormat) {
                            case 135173: 
                            case 135174: {
                                handle = Image.createDIB(width, height, 16);
                                break;
                            }
                            case 8207: 
                            case 137224: {
                                handle = Image.createDIB(width, height, 24);
                                break;
                            }
                            case 139273: 
                            case 925707: 
                            case 0x101004: 
                            case 1060876: 
                            case 1851406: 
                            case 3424269: {
                                handle = Image.createDIB(width, height, 32);
                            }
                        }
                        if (handle != 0L) {
                            long hDC = this.device.internal_new_GC(null);
                            long srcHDC = OS.CreateCompatibleDC(hDC);
                            long oldSrcBitmap = OS.SelectObject(srcHDC, handle);
                            long graphics = Gdip.Graphics_new(srcHDC);
                            if (graphics != 0L) {
                                Rect rect = new Rect();
                                rect.Width = width;
                                rect.Height = height;
                                status = Gdip.Graphics_DrawImage(graphics, bitmap, rect, 0, 0, width, height, 2, 0L, 0L, 0L);
                                if (status != 0) {
                                    error = 40;
                                    OS.DeleteObject(handle);
                                    handle = 0L;
                                }
                                Gdip.Graphics_delete(graphics);
                            }
                            OS.SelectObject(srcHDC, oldSrcBitmap);
                            OS.DeleteDC(srcHDC);
                            this.device.internal_dispose_GC(hDC, null);
                            imageMetadata = new ImageHandle(handle, zoom);
                        } else {
                            long lockedBitmapData = Gdip.BitmapData_new();
                            if (lockedBitmapData != 0L) {
                                status = Gdip.Bitmap_LockBits(bitmap, 0L, 0, pixelFormat, lockedBitmapData);
                                if (status == 0) {
                                    BitmapData bitmapData = new BitmapData();
                                    Gdip.MoveMemory(bitmapData, lockedBitmapData);
                                    int stride = bitmapData.Stride;
                                    long pixels = bitmapData.Scan0;
                                    int depth = 0;
                                    int scanlinePad = 4;
                                    int transparentPixel = -1;
                                    switch (bitmapData.PixelFormat) {
                                        case 196865: {
                                            depth = 1;
                                            break;
                                        }
                                        case 197634: {
                                            depth = 4;
                                            break;
                                        }
                                        case 198659: {
                                            depth = 8;
                                            break;
                                        }
                                        case 135173: 
                                        case 135174: 
                                        case 397319: {
                                            depth = 16;
                                            break;
                                        }
                                        case 137224: {
                                            depth = 24;
                                            break;
                                        }
                                        case 139273: 
                                        case 2498570: {
                                            depth = 32;
                                        }
                                    }
                                    if (depth != 0) {
                                        PaletteData paletteData = null;
                                        switch (bitmapData.PixelFormat) {
                                            case 196865: 
                                            case 197634: 
                                            case 198659: {
                                                int paletteSize = Gdip.Image_GetPaletteSize(bitmap);
                                                long hHeap = OS.GetProcessHeap();
                                                long palette = OS.HeapAlloc(hHeap, 8, paletteSize);
                                                if (palette == 0L) {
                                                    SWT.error(2);
                                                }
                                                Gdip.Image_GetPalette(bitmap, palette, paletteSize);
                                                ColorPalette colorPalette = new ColorPalette();
                                                Gdip.MoveMemory(colorPalette, palette, ColorPalette.sizeof);
                                                int[] entries = new int[colorPalette.Count];
                                                OS.MoveMemory(entries, palette + 8L, entries.length * 4);
                                                OS.HeapFree(hHeap, 0, palette);
                                                RGB[] rgbs = new RGB[colorPalette.Count];
                                                paletteData = new PaletteData(rgbs);
                                                int i = 0;
                                                while (i < entries.length) {
                                                    if ((entries[i] >> 24 & 0xFF) == 0 && (colorPalette.Flags & 1) != 0) {
                                                        transparentPixel = i;
                                                    }
                                                    rgbs[i] = new RGB((entries[i] & 0xFF0000) >> 16, (entries[i] & 0xFF00) >> 8, (entries[i] & 0xFF) >> 0);
                                                    ++i;
                                                }
                                                break;
                                            }
                                            case 135173: 
                                            case 397319: {
                                                paletteData = new PaletteData(31744, 992, 31);
                                                break;
                                            }
                                            case 135174: {
                                                paletteData = new PaletteData(63488, 2016, 31);
                                                break;
                                            }
                                            case 137224: {
                                                paletteData = new PaletteData(255, 65280, 0xFF0000);
                                                break;
                                            }
                                            case 139273: 
                                            case 2498570: {
                                                paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                                            }
                                        }
                                        byte[] data = new byte[stride * height];
                                        byte[] alphaData = null;
                                        OS.MoveMemory(data, pixels, data.length);
                                        switch (bitmapData.PixelFormat) {
                                            case 397319: {
                                                alphaData = new byte[width * height];
                                                int i = 1;
                                                int j = 0;
                                                while (i < data.length) {
                                                    alphaData[j] = (byte)((data[i] & 0x80) != 0 ? 255 : 0);
                                                    i += 2;
                                                    ++j;
                                                }
                                                break;
                                            }
                                            case 2498570: {
                                                alphaData = new byte[width * height];
                                                int i = 3;
                                                int j = 0;
                                                while (i < data.length) {
                                                    alphaData[j] = data[i];
                                                    i += 4;
                                                    ++j;
                                                }
                                                break;
                                            }
                                        }
                                        ImageData img = new ImageData(width, height, depth, paletteData, scanlinePad, data);
                                        img.transparentPixel = transparentPixel;
                                        img.alphaData = alphaData;
                                        ImageData newData = this.adaptImageDataIfDisabledOrGray(img);
                                        this.init(newData, (Integer)zoom);
                                        imageMetadata = this.zoomLevelToImageHandle.get(zoom);
                                        handle = imageMetadata.handle;
                                    }
                                    Gdip.Bitmap_UnlockBits(bitmap, lockedBitmapData);
                                } else {
                                    error = 40;
                                }
                                Gdip.BitmapData_delete(lockedBitmapData);
                            }
                        }
                    }
                }
                Gdip.Bitmap_delete(bitmap);
                if (status == 0) {
                    if (handle == 0L) {
                        SWT.error(error);
                    }
                    if (imageMetadata == null) {
                        SWT.error(error);
                    }
                }
            }
        }
        return imageMetadata;
    }

    long[] createGdipImage() {
        return this.createGdipImage(this.getZoom());
    }

    long[] createGdipImage(Integer zoom) {
        long handle = Image.win32_getHandle(this, zoom);
        switch (this.type) {
            case 0: {
                boolean hasAlpha;
                BITMAP bm = new BITMAP();
                OS.GetObject(handle, BITMAP.sizeof, bm);
                int depth = bm.bmPlanes * bm.bmBitsPixel;
                boolean isDib = bm.bmBits != 0L;
                boolean bl = hasAlpha = isDib && depth == 32;
                if (hasAlpha || this.transparentPixel != -1) {
                    int imgWidth = bm.bmWidth;
                    int imgHeight = bm.bmHeight;
                    long hDC = this.device.internal_new_GC(null);
                    if (hDC == 0L) {
                        SWT.error(2);
                    }
                    long srcHdc = OS.CreateCompatibleDC(hDC);
                    long memHdc = OS.CreateCompatibleDC(hDC);
                    this.device.internal_dispose_GC(hDC, null);
                    if (srcHdc == 0L) {
                        SWT.error(2);
                    }
                    if (memHdc == 0L) {
                        SWT.error(2);
                    }
                    long oldSrcBitmap = OS.SelectObject(srcHdc, handle);
                    long memDib = Image.createDIB(imgWidth, imgHeight, 32);
                    if (memDib == 0L) {
                        SWT.error(2);
                    }
                    long oldMemBitmap = OS.SelectObject(memHdc, memDib);
                    BITMAP dibBM = new BITMAP();
                    OS.GetObject(memDib, BITMAP.sizeof, dibBM);
                    int sizeInBytes = dibBM.bmWidthBytes * dibBM.bmHeight;
                    OS.BitBlt(memHdc, 0, 0, imgWidth, imgHeight, srcHdc, 0, 0, 0xCC0020);
                    long hHeap = OS.GetProcessHeap();
                    long pixels = OS.HeapAlloc(hHeap, 8, sizeInBytes);
                    if (pixels == 0L) {
                        SWT.error(2);
                    }
                    byte red = 0;
                    byte green = 0;
                    byte blue = 0;
                    if (hasAlpha) {
                        OS.MoveMemory(pixels, bm.bmBits, sizeInBytes);
                    } else {
                        if (bm.bmBitsPixel <= 8) {
                            byte[] color = new byte[4];
                            OS.GetDIBColorTable(srcHdc, this.transparentPixel, 1, color);
                            blue = color[0];
                            green = color[1];
                            red = color[2];
                        } else {
                            switch (bm.bmBitsPixel) {
                                case 16: {
                                    int blueMask = 31;
                                    int blueShift = ImageData.getChannelShift(blueMask);
                                    byte[] blues = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(blueMask, blueShift)];
                                    blue = blues[(this.transparentPixel & blueMask) >> blueShift];
                                    int greenMask = 992;
                                    int greenShift = ImageData.getChannelShift(greenMask);
                                    byte[] greens = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(greenMask, greenShift)];
                                    green = greens[(this.transparentPixel & greenMask) >> greenShift];
                                    int redMask = 31744;
                                    int redShift = ImageData.getChannelShift(redMask);
                                    byte[] reds = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(redMask, redShift)];
                                    red = reds[(this.transparentPixel & redMask) >> redShift];
                                    break;
                                }
                                case 24: {
                                    blue = (byte)((this.transparentPixel & 0xFF0000) >> 16);
                                    green = (byte)((this.transparentPixel & 0xFF00) >> 8);
                                    red = (byte)(this.transparentPixel & 0xFF);
                                    break;
                                }
                                case 32: {
                                    blue = (byte)((this.transparentPixel & 0xFF000000) >>> 24);
                                    green = (byte)((this.transparentPixel & 0xFF0000) >> 16);
                                    red = (byte)((this.transparentPixel & 0xFF00) >> 8);
                                }
                            }
                        }
                        byte[] srcData = new byte[sizeInBytes];
                        OS.MoveMemory(srcData, dibBM.bmBits, sizeInBytes);
                        int y = 0;
                        int dp = 0;
                        while (y < imgHeight) {
                            int x = 0;
                            while (x < imgWidth) {
                                srcData[dp + 3] = srcData[dp] == blue && srcData[dp + 1] == green && srcData[dp + 2] == red ? 0 : -1;
                                dp += 4;
                                ++x;
                            }
                            ++y;
                        }
                        OS.MoveMemory(pixels, srcData, sizeInBytes);
                    }
                    OS.SelectObject(srcHdc, oldSrcBitmap);
                    OS.SelectObject(memHdc, oldMemBitmap);
                    OS.DeleteObject(srcHdc);
                    OS.DeleteObject(memHdc);
                    OS.DeleteObject(memDib);
                    int pixelFormat = hasAlpha ? 925707 : 2498570;
                    return new long[]{Gdip.Bitmap_new(imgWidth, imgHeight, dibBM.bmWidthBytes, pixelFormat, pixels), pixels};
                }
                long[] lArray = new long[2];
                lArray[0] = Gdip.Bitmap_new(handle, 0L);
                return lArray;
            }
            case 1: {
                ICONINFO iconInfo = new ICONINFO();
                OS.GetIconInfo(handle, iconInfo);
                long hBitmap = iconInfo.hbmColor;
                if (hBitmap == 0L) {
                    hBitmap = iconInfo.hbmMask;
                }
                BITMAP bm = new BITMAP();
                OS.GetObject(hBitmap, BITMAP.sizeof, bm);
                int imgWidth = bm.bmWidth;
                int imgHeight = hBitmap == iconInfo.hbmMask ? bm.bmHeight / 2 : bm.bmHeight;
                long img = 0L;
                long pixels = 0L;
                if (imgWidth > imgHeight || bm.bmBitsPixel == 32) {
                    long hDC = this.device.internal_new_GC(null);
                    long srcHdc = OS.CreateCompatibleDC(hDC);
                    long oldSrcBitmap = OS.SelectObject(srcHdc, hBitmap);
                    long memHdc = OS.CreateCompatibleDC(hDC);
                    long memDib = Image.createDIB(imgWidth, imgHeight, 32);
                    if (memDib == 0L) {
                        SWT.error(2);
                    }
                    long oldMemBitmap = OS.SelectObject(memHdc, memDib);
                    BITMAP dibBM = new BITMAP();
                    OS.GetObject(memDib, BITMAP.sizeof, dibBM);
                    OS.BitBlt(memHdc, 0, 0, imgWidth, imgHeight, srcHdc, 0, hBitmap == iconInfo.hbmMask ? imgHeight : 0, 0xCC0020);
                    OS.SelectObject(memHdc, oldMemBitmap);
                    OS.DeleteObject(memHdc);
                    byte[] srcData = new byte[dibBM.bmWidthBytes * dibBM.bmHeight];
                    OS.MoveMemory(srcData, dibBM.bmBits, srcData.length);
                    OS.DeleteObject(memDib);
                    OS.SelectObject(srcHdc, iconInfo.hbmMask);
                    int y = 0;
                    int dp = 3;
                    while (y < imgHeight) {
                        int x = 0;
                        while (x < imgWidth) {
                            if (srcData[dp] == 0) {
                                srcData[dp] = OS.GetPixel(srcHdc, x, y) != 0 ? 0 : -1;
                            }
                            dp += 4;
                            ++x;
                        }
                        ++y;
                    }
                    OS.SelectObject(srcHdc, oldSrcBitmap);
                    OS.DeleteObject(srcHdc);
                    this.device.internal_dispose_GC(hDC, null);
                    long hHeap = OS.GetProcessHeap();
                    pixels = OS.HeapAlloc(hHeap, 8, srcData.length);
                    if (pixels == 0L) {
                        SWT.error(2);
                    }
                    OS.MoveMemory(pixels, srcData, srcData.length);
                    img = Gdip.Bitmap_new(imgWidth, imgHeight, dibBM.bmWidthBytes, 2498570, pixels);
                } else {
                    img = Gdip.Bitmap_new(handle);
                }
                if (iconInfo.hbmColor != 0L) {
                    OS.DeleteObject(iconInfo.hbmColor);
                }
                if (iconInfo.hbmMask != 0L) {
                    OS.DeleteObject(iconInfo.hbmMask);
                }
                return new long[]{img, pixels};
            }
        }
        SWT.error(40);
        return null;
    }

    @Override
    void destroy() {
        this.device.deregisterResourceWithZoomSupport(this);
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.imageProvider != null) {
            this.imageProvider.destroy();
        }
        this.destroyHandle();
        this.memGC = null;
    }

    private void destroyHandle() {
        for (ImageHandle imageMetadata : this.zoomLevelToImageHandle.values()) {
            this.destroyHandle(imageMetadata.handle);
        }
        this.zoomLevelToImageHandle.clear();
    }

    @Override
    void destroyHandlesExcept(Set<Integer> zoomLevels) {
        this.zoomLevelToImageHandle.entrySet().removeIf(entry -> {
            Integer zoom = (Integer)entry.getKey();
            if (!zoomLevels.contains(zoom) && zoom != DPIUtil.getZoomForAutoscaleProperty(this.initialNativeZoom)) {
                this.destroyHandle(((ImageHandle)entry.getValue()).handle);
                return true;
            }
            return false;
        });
    }

    private void destroyHandle(long handle) {
        if (this.type == 1) {
            OS.DestroyIcon(handle);
        } else {
            OS.DeleteObject(handle);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        if (this.device != image.device || this.transparentPixel != image.transparentPixel || this.getZoom() != image.getZoom()) {
            return false;
        }
        if (this.imageProvider != null && image.imageProvider != null) {
            return this.styleFlag == image.styleFlag && this.imageProvider.equals(image.imageProvider);
        }
        return Image.win32_getHandle(this, this.getZoom()) == Image.win32_getHandle(image, this.getZoom());
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        long hDC = this.device.internal_new_GC(null);
        long handle = Image.win32_getHandle(this, this.getZoom());
        BITMAP bm = new BITMAP();
        OS.GetObject(handle, BITMAP.sizeof, bm);
        long hdcMem = OS.CreateCompatibleDC(hDC);
        long hOldObject = OS.SelectObject(hdcMem, handle);
        int red = 0;
        int green = 0;
        int blue = 0;
        if (bm.bmBitsPixel <= 8) {
            byte[] color = new byte[4];
            OS.GetDIBColorTable(hdcMem, this.transparentPixel, 1, color);
            blue = color[0] & 0xFF;
            green = color[1] & 0xFF;
            red = color[2] & 0xFF;
        } else {
            switch (bm.bmBitsPixel) {
                case 16: {
                    blue = (this.transparentPixel & 0x1F) << 3;
                    green = (this.transparentPixel & 0x3E0) >> 2;
                    red = (this.transparentPixel & 0x7C00) >> 7;
                    break;
                }
                case 24: {
                    blue = (this.transparentPixel & 0xFF0000) >> 16;
                    green = (this.transparentPixel & 0xFF00) >> 8;
                    red = this.transparentPixel & 0xFF;
                    break;
                }
                case 32: {
                    blue = (this.transparentPixel & 0xFF000000) >>> 24;
                    green = (this.transparentPixel & 0xFF0000) >> 16;
                    red = (this.transparentPixel & 0xFF00) >> 8;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        OS.SelectObject(hdcMem, hOldObject);
        OS.DeleteDC(hdcMem);
        this.device.internal_dispose_GC(hDC, null);
        return Color.win32_new(this.device, blue << 16 | green << 8 | red);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.getBounds(100);
    }

    Rectangle getBounds(int zoom) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.zoomLevelToImageHandle.containsKey(zoom)) {
            ImageHandle imageMetadata = this.zoomLevelToImageHandle.get(zoom);
            Rectangle rectangle = new Rectangle(0, 0, imageMetadata.width, imageMetadata.height);
            return DPIUtil.scaleBounds(rectangle, zoom, imageMetadata.zoom);
        }
        if (this.imageProvider != null) {
            return this.imageProvider.getBounds(zoom);
        }
        ImageHandle imageMetadata = this.zoomLevelToImageHandle.values().iterator().next();
        Rectangle rectangle = new Rectangle(0, 0, imageMetadata.width, imageMetadata.height);
        return DPIUtil.scaleBounds(rectangle, zoom, imageMetadata.zoom);
    }

    @Deprecated
    public Rectangle getBoundsInPixels() {
        return this.getBounds(this.getZoom());
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.getImageData(100);
    }

    public ImageData getImageData(int zoom) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.zoomLevelToImageHandle.containsKey(zoom)) {
            return this.zoomLevelToImageHandle.get(zoom).getImageData();
        }
        if (this.imageProvider != null) {
            return this.imageProvider.getImageData(zoom);
        }
        if (this.memGC != null) {
            return this.getImageDataAtCurrentZoom();
        }
        TreeSet<Integer> availableZooms = new TreeSet<Integer>(this.zoomLevelToImageHandle.keySet());
        int closestZoom = Optional.ofNullable(availableZooms.higher(zoom)).orElse(availableZooms.lower(zoom));
        return DPIUtil.scaleImageData(this.device, this.getImageMetadata(closestZoom).getImageData(), zoom, closestZoom);
    }

    @Deprecated
    public ImageData getImageDataAtCurrentZoom() {
        return this.getImageMetadata(this.getZoom()).getImageData();
    }

    public int hashCode() {
        if (this.imageProvider != null) {
            return this.imageProvider.hashCode();
        }
        return (int)Image.win32_getHandle(this, this.getZoom());
    }

    void init(int width, int height) {
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        long hDC = this.device.internal_new_GC(null);
        ImageHandle imageMetadata = new ImageHandle(OS.CreateCompatibleBitmap(hDC, width, height), this.getZoom());
        if (imageMetadata.handle == 0L) {
            int planes;
            int bits = OS.GetDeviceCaps(hDC, 12);
            int depth = bits * (planes = OS.GetDeviceCaps(hDC, 14));
            if (depth < 16) {
                depth = 16;
            }
            if (depth > 24) {
                depth = 24;
            }
            imageMetadata = new ImageHandle(Image.createDIB(width, height, depth), this.getZoom());
        }
        if (imageMetadata.handle != 0L) {
            long memDC = OS.CreateCompatibleDC(hDC);
            long hOldBitmap = OS.SelectObject(memDC, imageMetadata.handle);
            OS.PatBlt(memDC, 0, 0, width, height, 15728673);
            OS.SelectObject(memDC, hOldBitmap);
            OS.DeleteDC(memDC);
        }
        this.device.internal_dispose_GC(hDC, null);
        if (imageMetadata.handle == 0L) {
            SWT.error(2, null, this.device.getLastError());
        }
    }

    static long createDIB(int width, int height, int depth) {
        BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
        bmiHeader.biWidth = width;
        bmiHeader.biHeight = -height;
        bmiHeader.biPlanes = 1;
        bmiHeader.biBitCount = (short)depth;
        bmiHeader.biCompression = 0;
        byte[] bmi = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
        long[] pBits = new long[1];
        return OS.CreateDIBSection(0L, bmi, 0, pBits, 0L, 0);
    }

    static ImageData indexToIndex(ImageData src, int newDepth) {
        ImageData img = new ImageData(src.width, src.height, newDepth, src.palette);
        ImageData.blit(src.data, src.depth, src.bytesPerLine, src.getByteOrder(), src.width, src.height, img.data, img.depth, img.bytesPerLine, src.getByteOrder(), img.width, img.height, false, false);
        img.transparentPixel = src.transparentPixel;
        img.maskPad = src.maskPad;
        img.maskData = src.maskData;
        img.alpha = src.alpha;
        img.alphaData = src.alphaData;
        return img;
    }

    static ImageData indexToDirect(ImageData src, int newDepth, PaletteData newPalette, int newByteOrder) {
        ImageData img = new ImageData(src.width, src.height, newDepth, newPalette);
        RGB[] rgbs = src.palette.getRGBs();
        byte[] srcReds = new byte[rgbs.length];
        byte[] srcGreens = new byte[rgbs.length];
        byte[] srcBlues = new byte[rgbs.length];
        int j = 0;
        while (j < rgbs.length) {
            RGB rgb = rgbs[j];
            if (rgb != null) {
                srcReds[j] = (byte)rgb.red;
                srcGreens[j] = (byte)rgb.green;
                srcBlues[j] = (byte)rgb.blue;
            }
            ++j;
        }
        ImageData.blit(src.width, src.height, src.data, src.depth, src.bytesPerLine, src.getByteOrder(), srcReds, srcGreens, srcBlues, img.data, img.depth, img.bytesPerLine, newByteOrder, newPalette.redMask, newPalette.greenMask, newPalette.blueMask);
        if (src.transparentPixel != -1) {
            img.transparentPixel = newPalette.getPixel(src.palette.getRGB(src.transparentPixel));
        }
        img.maskPad = src.maskPad;
        img.maskData = src.maskData;
        img.alpha = src.alpha;
        img.alphaData = src.alphaData;
        return img;
    }

    static ImageData directToDirect(ImageData src, int newDepth, PaletteData newPalette, int newByteOrder) {
        ImageData img = new ImageData(src.width, src.height, newDepth, newPalette);
        ImageData.blit(src.data, src.depth, src.bytesPerLine, src.getByteOrder(), src.width, src.height, src.palette.redMask, src.palette.greenMask, src.palette.blueMask, img.data, img.depth, img.bytesPerLine, newByteOrder, img.width, img.height, img.palette.redMask, img.palette.greenMask, img.palette.blueMask, false, false);
        if (src.transparentPixel != -1) {
            img.transparentPixel = img.palette.getPixel(src.palette.getRGB(src.transparentPixel));
        }
        img.maskPad = src.maskPad;
        img.maskData = src.maskData;
        img.alpha = src.alpha;
        img.alphaData = src.alphaData;
        return img;
    }

    static long[] init(Device device, Image image, ImageData i, Integer zoom) {
        long[] pBits;
        long hDib;
        int g;
        boolean hasAlpha;
        if (i.depth == 2) {
            i = Image.indexToIndex(i, 4);
        }
        if (i.depth == 16 && !i.palette.isDirect) {
            PaletteData newPalette = new PaletteData(255, 65280, 0xFF0000);
            i = Image.indexToDirect(i, 24, newPalette, 1);
        }
        boolean bl = hasAlpha = i.alpha != -1 || i.alphaData != null;
        if (i.palette.isDirect) {
            PaletteData palette = i.palette;
            int redMask = palette.redMask;
            int greenMask = palette.greenMask;
            int blueMask = palette.blueMask;
            int newDepth = i.depth;
            int newOrder = 1;
            PaletteData newPalette = null;
            if (hasAlpha) {
                newDepth = 32;
                newPalette = new PaletteData(65280, 0xFF0000, -16777216);
            } else {
                switch (i.depth) {
                    case 8: {
                        int minDepth = ImageData.getChannelWidth(redMask, palette.redShift) + ImageData.getChannelWidth(greenMask, palette.greenShift) + ImageData.getChannelWidth(blueMask, palette.blueShift);
                        if (minDepth <= 16) {
                            newDepth = 16;
                            newOrder = 0;
                            newPalette = new PaletteData(31744, 992, 31);
                            break;
                        }
                        newDepth = 24;
                        newPalette = new PaletteData(255, 65280, 0xFF0000);
                        break;
                    }
                    case 16: {
                        newOrder = 0;
                        if (redMask == 31744 && greenMask == 992 && blueMask == 31) break;
                        newPalette = new PaletteData(31744, 992, 31);
                        break;
                    }
                    case 24: {
                        if (redMask == 255 && greenMask == 65280 && blueMask == 0xFF0000) break;
                        newPalette = new PaletteData(255, 65280, 0xFF0000);
                        break;
                    }
                    case 32: {
                        if (i.getTransparencyType() != 2) {
                            newDepth = 24;
                            newPalette = new PaletteData(255, 65280, 0xFF0000);
                            break;
                        }
                        if (redMask == 65280 && greenMask == 0xFF0000 && blueMask == -16777216) break;
                        newPalette = new PaletteData(65280, 0xFF0000, -16777216);
                        break;
                    }
                    default: {
                        SWT.error(38);
                    }
                }
            }
            if (newPalette != null) {
                i = Image.directToDirect(i, newDepth, newPalette, newOrder);
            }
        } else if (hasAlpha) {
            PaletteData newPalette = new PaletteData(65280, 0xFF0000, -16777216);
            i = Image.indexToDirect(i, 32, newPalette, 1);
        }
        if (i.alpha != -1) {
            int alpha = i.alpha & 0xFF;
            byte[] data = i.data;
            dp = 0;
            while (dp < i.data.length) {
                int r = (data[dp] & 0xFF) * alpha + 128;
                r = r + (r >> 8) >> 8;
                int g2 = (data[dp + 1] & 0xFF) * alpha + 128;
                g2 = g2 + (g2 >> 8) >> 8;
                int b = (data[dp + 2] & 0xFF) * alpha + 128;
                b = b + (b >> 8) >> 8;
                data[dp] = (byte)b;
                data[dp + 1] = (byte)g2;
                data[dp + 2] = (byte)r;
                data[dp + 3] = (byte)alpha;
                dp += 4;
            }
        } else if (i.alphaData != null) {
            byte[] data = i.data;
            int ap = 0;
            dp = 0;
            while (dp < i.data.length) {
                int a = i.alphaData[ap] & 0xFF;
                int r = (data[dp] & 0xFF) * a + 128;
                r = r + (r >> 8) >> 8;
                g = (data[dp + 1] & 0xFF) * a + 128;
                g = g + (g >> 8) >> 8;
                int b = (data[dp + 2] & 0xFF) * a + 128;
                b = b + (b >> 8) >> 8;
                data[dp] = (byte)r;
                data[dp + 1] = (byte)g;
                data[dp + 2] = (byte)b;
                data[dp + 3] = (byte)a;
                ++ap;
                dp += 4;
            }
        }
        RGB[] rgbs = i.palette.getRGBs();
        BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
        bmiHeader.biWidth = i.width;
        bmiHeader.biHeight = -i.height;
        bmiHeader.biPlanes = 1;
        bmiHeader.biBitCount = (short)i.depth;
        bmiHeader.biCompression = 0;
        bmiHeader.biClrUsed = rgbs == null ? 0 : rgbs.length;
        byte[] bmi = i.palette.isDirect ? new byte[BITMAPINFOHEADER.sizeof] : new byte[BITMAPINFOHEADER.sizeof + rgbs.length * 4];
        OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
        int offset = BITMAPINFOHEADER.sizeof;
        if (!i.palette.isDirect) {
            RGB[] minDepth = rgbs;
            int n = rgbs.length;
            g = 0;
            while (g < n) {
                RGB rgb = minDepth[g];
                bmi[offset] = (byte)rgb.blue;
                bmi[offset + 1] = (byte)rgb.green;
                bmi[offset + 2] = (byte)rgb.red;
                bmi[offset + 3] = 0;
                offset += 4;
                ++g;
            }
        }
        if ((hDib = OS.CreateDIBSection(0L, bmi, 0, pBits = new long[1], 0L, 0)) == 0L) {
            SWT.error(2);
        }
        byte[] data = i.data;
        if (i.scanlinePad != 4 && i.bytesPerLine % 4 != 0) {
            data = ImageData.convertPad(data, i.width, i.height, i.depth, i.scanlinePad, 4);
        }
        OS.MoveMemory(pBits[0], data, data.length);
        long[] result = null;
        if (i.getTransparencyType() == 2) {
            long hDC = device.internal_new_GC(null);
            long hdcSrc = OS.CreateCompatibleDC(hDC);
            OS.SelectObject(hdcSrc, hDib);
            long hBitmap = OS.CreateCompatibleBitmap(hDC, i.width, i.height);
            if (hBitmap == 0L) {
                SWT.error(2);
            }
            long hdcDest = OS.CreateCompatibleDC(hDC);
            OS.SelectObject(hdcDest, hBitmap);
            OS.BitBlt(hdcDest, 0, 0, i.width, i.height, hdcSrc, 0, 0, 0xCC0020);
            device.internal_dispose_GC(hDC, null);
            byte[] maskData = ImageData.convertPad(i.maskData, i.width, i.height, 1, i.maskPad, 2);
            long hMask = OS.CreateBitmap(i.width, i.height, 1, 1, maskData);
            if (hMask == 0L) {
                SWT.error(2);
            }
            OS.SelectObject(hdcSrc, hMask);
            OS.PatBlt(hdcSrc, 0, 0, i.width, i.height, 0x550009);
            OS.DeleteDC(hdcSrc);
            OS.DeleteDC(hdcDest);
            OS.DeleteObject(hDib);
            if (image == null) {
                result = new long[]{hBitmap, hMask};
            } else {
                ICONINFO info = new ICONINFO();
                info.fIcon = true;
                info.hbmColor = hBitmap;
                info.hbmMask = hMask;
                long hIcon = OS.CreateIconIndirect(info);
                if (hIcon == 0L) {
                    SWT.error(2);
                }
                OS.DeleteObject(hBitmap);
                OS.DeleteObject(hMask);
                image.type = 1;
                Image image2 = image;
                image2.getClass();
                image2.new ImageHandle(hIcon, zoom);
            }
        } else if (image == null) {
            result = new long[]{hDib};
        } else {
            image.type = 0;
            image.transparentPixel = i.transparentPixel;
            Image image3 = image;
            image3.getClass();
            image3.new ImageHandle(hDib, zoom);
        }
        return result;
    }

    private void setImageMetadataForHandle(ImageHandle imageMetadata, Integer zoom) {
        if (zoom == null) {
            return;
        }
        if (this.zoomLevelToImageHandle.containsKey(zoom)) {
            SWT.error(14);
        }
        this.zoomLevelToImageHandle.put(zoom, imageMetadata);
    }

    static long[] init(Device device, Image image, ImageData source, ImageData mask, Integer zoom) {
        ImageData imageData = Image.applyMask(source, mask);
        return Image.init(device, image, imageData, zoom);
    }

    /*
     * Unable to fully structure code
     */
    private static ImageData applyMask(ImageData source, ImageData mask) {
        block13: {
            block12: {
                blackIndex = 0;
                if (!source.palette.isDirect) break block12;
                imageData = new ImageData(source.width, source.height, source.depth, source.palette);
                break block13;
            }
            black = new RGB(0, 0, 0);
            rgbs = source.getRGBs();
            if (source.transparentPixel == -1) ** GOTO lbl27
            newRGBs = new RGB[rgbs.length];
            System.arraycopy(rgbs, 0, newRGBs, 0, rgbs.length);
            if (source.transparentPixel >= newRGBs.length) {
                rgbs = new RGB[source.transparentPixel + 1];
                System.arraycopy(newRGBs, 0, rgbs, 0, newRGBs.length);
                i = newRGBs.length;
                while (i <= source.transparentPixel) {
                    rgbs[i] = new RGB(0, 0, 0);
                    ++i;
                }
            } else {
                newRGBs[source.transparentPixel] = black;
                rgbs = newRGBs;
            }
            blackIndex = source.transparentPixel;
            imageData = new ImageData(source.width, source.height, source.depth, new PaletteData(rgbs));
            break block13;
            while (!rgbs[blackIndex].equals(black)) {
                ++blackIndex;
lbl27:
                // 2 sources

                if (blackIndex < rgbs.length) continue;
            }
            if (blackIndex == rgbs.length) {
                if (1 << source.depth > rgbs.length) {
                    newRGBs = new RGB[rgbs.length + 1];
                    System.arraycopy(rgbs, 0, newRGBs, 0, rgbs.length);
                    newRGBs[rgbs.length] = black;
                    rgbs = newRGBs;
                } else {
                    blackIndex = -1;
                }
            }
            imageData = new ImageData(source.width, source.height, source.depth, new PaletteData(rgbs));
        }
        if (blackIndex == -1) {
            System.arraycopy(source.data, 0, imageData.data, 0, imageData.data.length);
        } else {
            imagePixels = new int[imageData.width];
            maskPixels = new int[mask.width];
            y = 0;
            while (y < imageData.height) {
                source.getPixels(0, y, imageData.width, imagePixels, 0);
                mask.getPixels(0, y, mask.width, maskPixels, 0);
                i = 0;
                while (i < imagePixels.length) {
                    if (maskPixels[i] == 0) {
                        imagePixels[i] = blackIndex;
                    }
                    ++i;
                }
                imageData.setPixels(0, y, source.width, imagePixels, 0);
                ++y;
            }
        }
        imageData.maskPad = mask.scanlinePad;
        imageData.maskData = mask.data;
        return imageData;
    }

    void init(ImageData i, Integer zoom) {
        if (i == null) {
            SWT.error(4);
        }
        Image.init(this.device, this, i, zoom);
    }

    @Override
    public long internal_new_GC(GCData data) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        long hDC = this.device.internal_new_GC(null);
        long imageDC = OS.CreateCompatibleDC(hDC);
        this.device.internal_dispose_GC(hDC, null);
        if (imageDC == 0L) {
            SWT.error(2);
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) != 0) {
                data.layout = (data.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                data.style |= 0x2000000;
            }
            data.device = this.device;
            data.nativeZoom = this.initialNativeZoom;
            data.image = this;
            data.font = SWTFontProvider.getSystemFont(this.device, this.initialNativeZoom);
        }
        return imageDC;
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        OS.DeleteDC(hDC);
    }

    @Override
    public boolean isDisposed() {
        if (this.imageProvider != null) {
            return this.imageProvider.isDisposed();
        }
        return this.zoomLevelToImageHandle.isEmpty();
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.zoomLevelToImageHandle.values().forEach(imageHandle -> this.setBackground(color, imageHandle.handle));
    }

    private void setBackground(Color color, long handle) {
        if (this.transparentPixel == -1) {
            return;
        }
        this.transparentColor = -1;
        long hDC = this.device.internal_new_GC(null);
        BITMAP bm = new BITMAP();
        OS.GetObject(handle, BITMAP.sizeof, bm);
        long hdcMem = OS.CreateCompatibleDC(hDC);
        OS.SelectObject(hdcMem, handle);
        int maxColors = 1 << bm.bmBitsPixel;
        byte[] colors = new byte[maxColors * 4];
        int numColors = OS.GetDIBColorTable(hdcMem, 0, maxColors, colors);
        int offset = this.transparentPixel * 4;
        colors[offset] = (byte)color.getBlue();
        colors[offset + 1] = (byte)color.getGreen();
        colors[offset + 2] = (byte)color.getRed();
        OS.SetDIBColorTable(hdcMem, 0, numColors, colors);
        OS.DeleteDC(hdcMem);
        this.device.internal_dispose_GC(hDC, null);
    }

    private int getZoom() {
        return DPIUtil.getZoomForAutoscaleProperty(this.initialNativeZoom);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + String.valueOf(this.zoomLevelToImageHandle) + "}";
    }

    public static Image win32_new(Device device, int type, long handle, int nativeZoom) {
        Image image = new Image(device, nativeZoom);
        image.type = type;
        Image image2 = image;
        image2.getClass();
        image2.new ImageHandle(handle, nativeZoom);
        image.device.registerResourceWithZoomSupport(image);
        return image;
    }

    private abstract class AbstractImageProviderWrapper {
        private AbstractImageProviderWrapper() {
        }

        abstract Object getProvider();

        protected abstract Rectangle getBounds(int var1);

        abstract ImageData getImageData(int var1);

        abstract ImageHandle getImageMetadata(int var1);

        abstract AbstractImageProviderWrapper createCopy(Image var1);

        abstract boolean isDisposed();

        protected void checkProvider(Object provider, Class<?> expectedClass) {
            if (provider == null) {
                SWT.error(4);
            }
            if (!expectedClass.isAssignableFrom(provider.getClass())) {
                SWT.error(5);
            }
        }

        public int hashCode() {
            return this.getProvider().hashCode();
        }

        public boolean equals(Object otherProvider) {
            if (otherProvider instanceof AbstractImageProviderWrapper) {
                AbstractImageProviderWrapper aip = (AbstractImageProviderWrapper)otherProvider;
                if (this.getProvider().equals(aip.getProvider())) {
                    return true;
                }
            }
            return false;
        }

        protected void destroy() {
        }
    }

    private class ImageDataProviderWrapper
    extends AbstractImageProviderWrapper {
        private final ImageDataProvider provider;

        ImageDataProviderWrapper(ImageDataProvider provider) {
            this.checkProvider(provider, ImageDataProvider.class);
            this.provider = provider;
        }

        @Override
        protected Rectangle getBounds(int zoom) {
            DPIUtil.ElementAtZoom<ImageData> data = DPIUtil.validateAndGetImageDataAtZoom(this.provider, zoom);
            Rectangle rectangle = new Rectangle(0, 0, data.element().width, data.element().height);
            return DPIUtil.scaleBounds(rectangle, zoom, data.zoom());
        }

        @Override
        ImageData getImageData(int zoom) {
            DPIUtil.ElementAtZoom<ImageData> data = DPIUtil.validateAndGetImageDataAtZoom(this.provider, zoom);
            return DPIUtil.scaleImageData(Image.this.device, data.element(), zoom, data.zoom());
        }

        @Override
        ImageHandle getImageMetadata(int zoom) {
            DPIUtil.ElementAtZoom<ImageData> imageCandidate = DPIUtil.validateAndGetImageDataAtZoom(this.provider, zoom);
            ImageData resizedData = DPIUtil.scaleImageData(Image.this.device, imageCandidate.element(), zoom, imageCandidate.zoom());
            ImageData newData = Image.this.adaptImageDataIfDisabledOrGray(resizedData);
            Image.this.init(newData, (Integer)zoom);
            Image.this.init();
            return Image.this.zoomLevelToImageHandle.get(zoom);
        }

        @Override
        boolean isDisposed() {
            return Image.this.zoomLevelToImageHandle.isEmpty();
        }

        @Override
        Object getProvider() {
            return this.provider;
        }

        @Override
        ImageDataProviderWrapper createCopy(Image image) {
            Image image2 = image;
            image2.getClass();
            return image2.new ImageDataProviderWrapper(this.provider);
        }
    }

    private class ImageFileNameProviderWrapper
    extends AbstractImageProviderWrapper {
        private final ImageFileNameProvider provider;

        ImageFileNameProviderWrapper(ImageFileNameProvider provider) {
            this.checkProvider(provider, ImageFileNameProvider.class);
            this.provider = provider;
        }

        @Override
        protected Rectangle getBounds(int zoom) {
            ImageHandle imageHandle = Image.this.zoomLevelToImageHandle.values().iterator().next();
            Rectangle rectangle = new Rectangle(0, 0, imageHandle.width, imageHandle.height);
            return DPIUtil.scaleBounds(rectangle, zoom, imageHandle.zoom);
        }

        @Override
        ImageData getImageData(int zoom) {
            DPIUtil.ElementAtZoom<String> fileName = DPIUtil.validateAndGetImagePathAtZoom(this.provider, zoom);
            return DPIUtil.scaleImageData(Image.this.device, new ImageData(fileName.element()), zoom, fileName.zoom());
        }

        @Override
        ImageHandle getImageMetadata(int zoom) {
            DPIUtil.ElementAtZoom<String> imageCandidate = DPIUtil.validateAndGetImagePathAtZoom(this.provider, zoom);
            ImageData imageData = new ImageData(imageCandidate.element());
            if (imageCandidate.zoom() == zoom) {
                ImageHandle imageMetadata = Image.this.initNative(imageCandidate.element(), zoom);
                if (imageMetadata == null) {
                    Image.this.init(imageData, (Integer)zoom);
                }
                Image.this.init();
            } else {
                ImageData resizedData = DPIUtil.scaleImageData(Image.this.device, imageData, zoom, imageCandidate.zoom());
                ImageData newData = Image.this.adaptImageDataIfDisabledOrGray(resizedData);
                Image.this.init(newData, (Integer)zoom);
            }
            return Image.this.zoomLevelToImageHandle.get(zoom);
        }

        @Override
        boolean isDisposed() {
            return Image.this.zoomLevelToImageHandle.isEmpty();
        }

        @Override
        Object getProvider() {
            return this.provider;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.provider, Image.this.styleFlag, Image.this.transparentPixel, Image.this.getZoom());
        }

        @Override
        ImageFileNameProviderWrapper createCopy(Image image) {
            Image image2 = image;
            image2.getClass();
            return image2.new ImageFileNameProviderWrapper(this.provider);
        }
    }

    private class ImageGcDrawerWrapper
    extends AbstractImageProviderWrapper {
        private ImageGcDrawer drawer;
        private int width;
        private int height;
        private boolean isDestroyed;

        public ImageGcDrawerWrapper(ImageGcDrawer imageGcDrawer, int width, int height) {
            this.checkProvider(imageGcDrawer, ImageGcDrawer.class);
            this.drawer = imageGcDrawer;
            this.width = width;
            this.height = height;
        }

        @Override
        protected Rectangle getBounds(int zoom) {
            Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
            return DPIUtil.scaleBounds(rectangle, zoom, 100);
        }

        @Override
        ImageData getImageData(int zoom) {
            return this.getImageMetadata(zoom).getImageData();
        }

        @Override
        ImageHandle getImageMetadata(int zoom) {
            Image.this.initialNativeZoom = zoom;
            Image image = new Image(Image.this.device, this.width, this.height, zoom);
            GC gc = new GC(image);
            try {
                gc.data.nativeZoom = zoom;
                this.drawer.drawOn(gc, this.width, this.height);
                ImageData imageData = image.getImageMetadata(zoom).getImageData();
                this.drawer.postProcess(imageData);
                ImageData newData = Image.this.adaptImageDataIfDisabledOrGray(imageData);
                Image.this.init(newData, (Integer)zoom);
            }
            finally {
                gc.dispose();
                image.dispose();
            }
            return Image.this.zoomLevelToImageHandle.get(zoom);
        }

        @Override
        protected void destroy() {
            this.isDestroyed = true;
        }

        @Override
        boolean isDisposed() {
            return this.isDestroyed;
        }

        @Override
        Object getProvider() {
            return this.drawer;
        }

        @Override
        ImageGcDrawerWrapper createCopy(Image image) {
            Image image2 = image;
            image2.getClass();
            return image2.new ImageGcDrawerWrapper(this.drawer, this.width, this.height);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getProvider().hashCode(), this.width, this.height);
        }

        @Override
        public boolean equals(Object otherProvider) {
            if (otherProvider instanceof ImageGcDrawerWrapper) {
                ImageGcDrawerWrapper aip = (ImageGcDrawerWrapper)otherProvider;
                if (this.getProvider().equals(aip.getProvider()) && this.width == aip.width && this.height == aip.height) {
                    return true;
                }
            }
            return false;
        }
    }

    private class ImageHandle {
        private final long handle;
        private final int zoom;
        private int height;
        private int width;

        public ImageHandle(long handle, int zoom) {
            this.handle = handle;
            this.zoom = zoom;
            this.updateBoundsInPixelsFromNative();
            Image.this.setImageMetadataForHandle(this, zoom);
        }

        private void updateBoundsInPixelsFromNative() {
            switch (Image.this.type) {
                case 0: {
                    BITMAP bm = new BITMAP();
                    OS.GetObject(this.handle, BITMAP.sizeof, bm);
                    this.width = bm.bmWidth;
                    this.height = bm.bmHeight;
                    return;
                }
                case 1: {
                    ICONINFO info = new ICONINFO();
                    OS.GetIconInfo(this.handle, info);
                    long hBitmap = info.hbmColor;
                    if (hBitmap == 0L) {
                        hBitmap = info.hbmMask;
                    }
                    BITMAP bm = new BITMAP();
                    OS.GetObject(hBitmap, BITMAP.sizeof, bm);
                    if (hBitmap == info.hbmMask) {
                        bm.bmHeight /= 2;
                    }
                    if (info.hbmColor != 0L) {
                        OS.DeleteObject(info.hbmColor);
                    }
                    if (info.hbmMask != 0L) {
                        OS.DeleteObject(info.hbmMask);
                    }
                    this.width = bm.bmWidth;
                    this.height = bm.bmHeight;
                    return;
                }
            }
            SWT.error(40);
        }

        private ImageData getImageData() {
            if (Image.this.isDisposed()) {
                SWT.error(44);
            }
            switch (Image.this.type) {
                case 1: {
                    ICONINFO info = new ICONINFO();
                    OS.GetIconInfo(this.handle, info);
                    long hBitmap = info.hbmColor;
                    if (hBitmap == 0L) {
                        hBitmap = info.hbmMask;
                    }
                    BITMAP bm = new BITMAP();
                    OS.GetObject(hBitmap, BITMAP.sizeof, bm);
                    int depth = bm.bmPlanes * bm.bmBitsPixel;
                    int width = bm.bmWidth;
                    if (hBitmap == info.hbmMask) {
                        bm.bmHeight /= 2;
                    }
                    int height = bm.bmHeight;
                    int numColors = 0;
                    if (depth <= 8) {
                        numColors = 1 << depth;
                    }
                    BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
                    bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
                    bmiHeader.biWidth = width;
                    bmiHeader.biHeight = -height;
                    bmiHeader.biPlanes = 1;
                    bmiHeader.biBitCount = (short)depth;
                    bmiHeader.biCompression = 0;
                    byte[] bmi = new byte[BITMAPINFOHEADER.sizeof + numColors * 4];
                    OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
                    long hDC = Image.this.device.internal_new_GC(null);
                    long hBitmapDC = OS.CreateCompatibleDC(hDC);
                    long hOldBitmap = OS.SelectObject(hBitmapDC, hBitmap);
                    OS.GetDIBits(hBitmapDC, hBitmap, 0, height, null, bmi, 0);
                    OS.MoveMemory(bmiHeader, bmi, BITMAPINFOHEADER.sizeof);
                    int imageSize = bmiHeader.biSizeImage;
                    byte[] data = new byte[imageSize];
                    OS.GetDIBits(hBitmapDC, hBitmap, 0, height, data, bmi, 0);
                    PaletteData palette = null;
                    if (depth <= 8) {
                        RGB[] rgbs = new RGB[numColors];
                        int srcIndex = 40;
                        int i = 0;
                        while (i < numColors) {
                            rgbs[i] = new RGB(bmi[srcIndex + 2] & 0xFF, bmi[srcIndex + 1] & 0xFF, bmi[srcIndex] & 0xFF);
                            srcIndex += 4;
                            ++i;
                        }
                        palette = new PaletteData(rgbs);
                    } else if (depth == 16) {
                        palette = new PaletteData(31744, 992, 31);
                    } else if (depth == 24) {
                        palette = new PaletteData(255, 65280, 0xFF0000);
                    } else if (depth == 32) {
                        palette = new PaletteData(65280, 0xFF0000, -16777216);
                    } else {
                        SWT.error(38);
                    }
                    byte[] maskData = null;
                    byte[] alphaData = null;
                    if (info.hbmColor == 0L) {
                        maskData = new byte[imageSize];
                        OS.GetDIBits(hBitmapDC, hBitmap, height, height, maskData, bmi, 0);
                    } else {
                        bmiHeader = new BITMAPINFOHEADER();
                        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
                        bmiHeader.biWidth = width;
                        bmiHeader.biHeight = -height;
                        bmiHeader.biPlanes = 1;
                        bmiHeader.biBitCount = 1;
                        bmiHeader.biCompression = 0;
                        bmi = new byte[BITMAPINFOHEADER.sizeof + 8];
                        OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
                        int offset = BITMAPINFOHEADER.sizeof;
                        bmi[offset + 6] = -1;
                        bmi[offset + 5] = -1;
                        bmi[offset + 4] = -1;
                        bmi[offset + 7] = 0;
                        OS.SelectObject(hBitmapDC, info.hbmMask);
                        OS.GetDIBits(hBitmapDC, info.hbmMask, 0, height, null, bmi, 0);
                        OS.MoveMemory(bmiHeader, bmi, BITMAPINFOHEADER.sizeof);
                        imageSize = bmiHeader.biSizeImage;
                        maskData = new byte[imageSize];
                        OS.GetDIBits(hBitmapDC, info.hbmMask, 0, height, maskData, bmi, 0);
                        boolean hasMaskData = false;
                        int i = 0;
                        while (i < maskData.length) {
                            hasMaskData |= maskData[i] != 0;
                            int n = i++;
                            maskData[n] = ~maskData[n];
                        }
                        int bpl = imageSize / height;
                        int maskPad = 1;
                        while (maskPad < 128) {
                            int calcBpl = ((width + 7) / 8 + (maskPad - 1)) / maskPad * maskPad;
                            if (calcBpl == bpl) break;
                            ++maskPad;
                        }
                        maskData = ImageData.convertPad(maskData, width, height, 1, maskPad, 2);
                        if (!hasMaskData && depth == 32) {
                            alphaData = new byte[width * height];
                            boolean hasAlphaData = false;
                            int pixelIndex = 0;
                            while (pixelIndex < alphaData.length) {
                                alphaData[pixelIndex] = data[pixelIndex * 4 + 3];
                                hasAlphaData |= alphaData[pixelIndex] != -1;
                                ++pixelIndex;
                            }
                            if (hasAlphaData) {
                                maskData = null;
                            } else {
                                alphaData = null;
                            }
                        }
                    }
                    OS.SelectObject(hBitmapDC, hOldBitmap);
                    OS.DeleteDC(hBitmapDC);
                    Image.this.device.internal_dispose_GC(hDC, null);
                    if (info.hbmColor != 0L) {
                        OS.DeleteObject(info.hbmColor);
                    }
                    if (info.hbmMask != 0L) {
                        OS.DeleteObject(info.hbmMask);
                    }
                    ImageData imageData = new ImageData(width, height, depth, palette, 4, data);
                    imageData.alphaData = alphaData;
                    imageData.maskData = maskData;
                    imageData.maskPad = 2;
                    return imageData;
                }
                case 0: {
                    int imageSize;
                    BITMAP bm = new BITMAP();
                    OS.GetObject(this.handle, BITMAP.sizeof, bm);
                    int depth = bm.bmPlanes * bm.bmBitsPixel;
                    int width = bm.bmWidth;
                    int height = bm.bmHeight;
                    boolean isDib = bm.bmBits != 0L;
                    long hDC = Image.this.device.internal_new_GC(null);
                    DIBSECTION dib = null;
                    if (isDib) {
                        dib = new DIBSECTION();
                        OS.GetObject(this.handle, DIBSECTION.sizeof, dib);
                    }
                    int numColors = 0;
                    if (depth <= 8) {
                        numColors = isDib ? dib.biClrUsed : 1 << depth;
                    }
                    byte[] bmi = null;
                    BITMAPINFOHEADER bmiHeader = null;
                    if (!isDib) {
                        bmiHeader = new BITMAPINFOHEADER();
                        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
                        bmiHeader.biWidth = width;
                        bmiHeader.biHeight = -height;
                        bmiHeader.biPlanes = 1;
                        bmiHeader.biBitCount = (short)depth;
                        bmiHeader.biCompression = 0;
                        bmi = new byte[BITMAPINFOHEADER.sizeof + numColors * 4];
                        OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
                    }
                    long hBitmapDC = OS.CreateCompatibleDC(hDC);
                    long hOldBitmap = OS.SelectObject(hBitmapDC, this.handle);
                    if (isDib) {
                        imageSize = dib.biSizeImage;
                    } else {
                        OS.GetDIBits(hBitmapDC, this.handle, 0, height, null, bmi, 0);
                        OS.MoveMemory(bmiHeader, bmi, BITMAPINFOHEADER.sizeof);
                        imageSize = bmiHeader.biSizeImage;
                    }
                    byte[] data = new byte[imageSize];
                    if (isDib) {
                        OS.MoveMemory(data, bm.bmBits, imageSize);
                    } else {
                        OS.GetDIBits(hBitmapDC, this.handle, 0, height, data, bmi, 0);
                    }
                    PaletteData palette = null;
                    if (depth <= 8) {
                        RGB[] rgbs = new RGB[numColors];
                        if (isDib) {
                            byte[] colors = new byte[numColors * 4];
                            OS.GetDIBColorTable(hBitmapDC, 0, numColors, colors);
                            int colorIndex = 0;
                            int i = 0;
                            while (i < rgbs.length) {
                                rgbs[i] = new RGB(colors[colorIndex + 2] & 0xFF, colors[colorIndex + 1] & 0xFF, colors[colorIndex] & 0xFF);
                                colorIndex += 4;
                                ++i;
                            }
                        } else {
                            int srcIndex = BITMAPINFOHEADER.sizeof;
                            int i = 0;
                            while (i < numColors) {
                                rgbs[i] = new RGB(bmi[srcIndex + 2] & 0xFF, bmi[srcIndex + 1] & 0xFF, bmi[srcIndex] & 0xFF);
                                srcIndex += 4;
                                ++i;
                            }
                        }
                        palette = new PaletteData(rgbs);
                    } else if (depth == 16) {
                        palette = new PaletteData(31744, 992, 31);
                    } else if (depth == 24) {
                        palette = new PaletteData(255, 65280, 0xFF0000);
                    } else if (depth == 32) {
                        palette = new PaletteData(65280, 0xFF0000, -16777216);
                    } else {
                        SWT.error(38);
                    }
                    OS.SelectObject(hBitmapDC, hOldBitmap);
                    OS.DeleteDC(hBitmapDC);
                    Image.this.device.internal_dispose_GC(hDC, null);
                    ImageData imageData = new ImageData(width, height, depth, palette, 4, data);
                    imageData.transparentPixel = Image.this.transparentPixel;
                    if (depth == 32) {
                        byte[] straightData = new byte[imageSize];
                        byte[] alphaData = new byte[width * height];
                        boolean validAlpha = isDib;
                        int ap = 0;
                        int dp = 0;
                        while (validAlpha && ap < alphaData.length) {
                            int b = data[dp] & 0xFF;
                            int g = data[dp + 1] & 0xFF;
                            int r = data[dp + 2] & 0xFF;
                            int a = data[dp + 3] & 0xFF;
                            alphaData[ap] = (byte)a;
                            boolean bl = validAlpha = validAlpha && b <= a && g <= a && r <= a;
                            if (a != 0) {
                                straightData[dp] = (byte)((b * 255 + a / 2) / a);
                                straightData[dp + 1] = (byte)((g * 255 + a / 2) / a);
                                straightData[dp + 2] = (byte)((r * 255 + a / 2) / a);
                            }
                            ++ap;
                            dp += 4;
                        }
                        if (validAlpha) {
                            imageData.data = straightData;
                            imageData.alphaData = alphaData;
                        } else {
                            int dp2 = 3;
                            while (dp2 < imageSize) {
                                data[dp2] = -1;
                                dp2 += 4;
                            }
                        }
                    }
                    return imageData;
                }
            }
            SWT.error(40);
            return null;
        }
    }
}

