/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.util.TreeSet;
import org.eclipse.core.internal.preferences.OSGiPreferencesServiceImpl;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;

public class OSGiPreferencesServiceManager
implements ServiceFactory<PreferencesService>,
BundleListener {
    private static final String ORG_ECLIPSE_CORE_INTERNAL_PREFERENCES_OSGI = "org.eclipse.core.internal.preferences.osgi";
    private Preferences prefBundles;

    public OSGiPreferencesServiceManager(BundleContext context) {
        context.addBundleListener((BundleListener)this);
        this.prefBundles = ConfigurationScope.INSTANCE.getNode(ORG_ECLIPSE_CORE_INTERNAL_PREFERENCES_OSGI);
        try {
            String[] prefsBundles;
            Bundle[] allBundles = context.getBundles();
            TreeSet<String> bundleQualifiers = new TreeSet<String>();
            Bundle[] bundleArray = allBundles;
            int n = allBundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle allBundle = bundleArray[n2];
                bundleQualifiers.add(this.getQualifier(allBundle));
                ++n2;
            }
            String[] stringArray = prefsBundles = this.prefBundles.keys();
            int n3 = prefsBundles.length;
            n = 0;
            while (n < n3) {
                String prefsBundle = stringArray[n];
                if (!bundleQualifiers.contains(prefsBundle)) {
                    this.removePrefs(prefsBundle);
                }
                ++n;
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public PreferencesService getService(Bundle bundle, ServiceRegistration<PreferencesService> registration) {
        String qualifier = this.getQualifier(bundle);
        Preferences bundlesNode = this.getBundlesNode();
        bundlesNode.put(qualifier, "");
        try {
            bundlesNode.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return new OSGiPreferencesServiceImpl(ConfigurationScope.INSTANCE.getNode(this.getQualifier(bundle)));
    }

    private String getQualifier(Bundle bundle) {
        String qualifier = "org.eclipse.core.runtime.preferences.OSGiPreferences." + bundle.getBundleId();
        return qualifier;
    }

    public void ungetService(Bundle bundle, ServiceRegistration<PreferencesService> registration, PreferencesService service) {
        try {
            ConfigurationScope.INSTANCE.getNode(this.getQualifier(bundle)).flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            try {
                this.removePrefs(this.getQualifier(event.getBundle()));
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
    }

    protected void removePrefs(String qualifier) throws BackingStoreException {
        ConfigurationScope.INSTANCE.getNode(qualifier).removeNode();
        Preferences bundlesNode = this.getBundlesNode();
        bundlesNode.remove(qualifier);
        bundlesNode.flush();
    }

    private Preferences getBundlesNode() {
        try {
            if (this.prefBundles == null || !this.prefBundles.nodeExists("")) {
                this.prefBundles = ConfigurationScope.INSTANCE.getNode(ORG_ECLIPSE_CORE_INTERNAL_PREFERENCES_OSGI);
            }
            return this.prefBundles;
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
    }
}

