/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.felix.scr.impl.logger.ComponentLogger;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentServiceObjects;

public class ClassUtils {
    private static final Class<?> OBJECT_CLASS = Object.class;
    public static final Class<?> SERVICE_REFERENCE_CLASS = ServiceReference.class;
    public static final Class<?> COMPONENTS_SERVICE_OBJECTS_CLASS = ComponentServiceObjects.class;
    public static final Class<?> MAP_CLASS = Map.class;
    public static final Class<?> MAP_ENTRY_CLASS = Map.Entry.class;
    public static final Class<?> COLLECTION_CLASS = Collection.class;
    public static final Class<?> LIST_CLASS = List.class;
    public static final Class<?> OPTIONAL_CLASS = Optional.class;
    public static final Class<?> COMPONENT_CONTEXT_CLASS = ComponentContext.class;
    public static final Class<?> BUNDLE_CONTEXT_CLASS = BundleContext.class;
    public static final Class<?> INTEGER_CLASS = Integer.class;
    public static final String LOGGER_CLASS = "org.osgi.service.log.Logger";
    public static final String FORMATTER_LOGGER_CLASS = "org.osgi.service.log.FormatterLogger";
    public static final String LOGGER_FACTORY_CLASS = "org.osgi.service.log.LoggerFactory";
    public static FrameworkWiring m_fwkWiring;

    public static Class<?> getClassFromComponentClassLoader(Class<?> componentClass, String className, ComponentLogger logger) {
        if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
            logger.log(InternalLogger.Level.DEBUG, "getClassFromComponentClassLoader: Looking for interface class {0} through loader of {1}", null, className, componentClass.getName());
        }
        try {
            ClassLoader loader = componentClass.getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            Class<?> referenceClass = loader.loadClass(className);
            if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                logger.log(InternalLogger.Level.DEBUG, "getClassFromComponentClassLoader: Found class {0}", null, referenceClass.getName());
            }
            return referenceClass;
        }
        catch (ClassNotFoundException loader) {
            Bundle exportingHost;
            if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                logger.log(InternalLogger.Level.DEBUG, "getClassFromComponentClassLoader: Not found through component class, using FrameworkWiring", null);
            }
            if ((exportingHost = ClassUtils.getExporter(className, logger)) != null) {
                try {
                    if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                        logger.log(InternalLogger.Level.DEBUG, "getClassFromComponentClassLoader: Checking Bundle {0}/{1}", null, exportingHost.getSymbolicName(), exportingHost.getBundleId());
                    }
                    Class referenceClass = exportingHost.loadClass(className);
                    if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                        logger.log(InternalLogger.Level.DEBUG, "getClassFromComponentClassLoader: Found class {0}", null, referenceClass.getName());
                    }
                    return referenceClass;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                logger.log(InternalLogger.Level.DEBUG, "getClassFromComponentClassLoader: No bundles exporting package {0} found", null, className);
            }
            if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                logger.log(InternalLogger.Level.DEBUG, "getClassFromComponentClassLoader: No class found, falling back to class Object", null);
            }
            return OBJECT_CLASS;
        }
    }

    private static Bundle getExporter(String className, ComponentLogger logger) {
        FrameworkWiring currentFwkWiring = m_fwkWiring;
        if (currentFwkWiring != null) {
            String referenceClassPackage = className.substring(0, className.lastIndexOf(46));
            Collection providers = currentFwkWiring.findProviders(ClassUtils.getRequirement(referenceClassPackage));
            for (BundleCapability provider : providers) {
                BundleWiring wiring = provider.getRevision().getWiring();
                if (wiring == null) continue;
                if ((provider.getRevision().getTypes() & 1) != 0) {
                    List hostWires = wiring.getRequiredWires("osgi.wiring.host");
                    if (hostWires == null || hostWires.isEmpty()) continue;
                    return ((BundleWire)hostWires.get(0)).getProvider().getBundle();
                }
                return wiring.getBundle();
            }
        } else if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
            logger.log(InternalLogger.Level.DEBUG, "getClassFromComponentClassLoader: FrameworkWiring not available, cannot find class", null);
        }
        return null;
    }

    private static Requirement getRequirement(final String pkgName) {
        return new Requirement(){

            public Resource getResource() {
                return null;
            }

            public String getNamespace() {
                return "osgi.wiring.package";
            }

            public Map<String, String> getDirectives() {
                String filter = "(osgi.wiring.package=" + pkgName + ")";
                return Collections.singletonMap("filter", filter);
            }

            public Map<String, Object> getAttributes() {
                return Collections.emptyMap();
            }
        };
    }

    public static void setFrameworkWiring(FrameworkWiring fwkWiring) {
        m_fwkWiring = fwkWiring;
    }

    public static String getPackageName(Class<?> clazz) {
        String name = clazz.getName();
        int dot = name.lastIndexOf(46);
        return dot > 0 ? name.substring(0, dot) : "";
    }
}

