/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.activities.AbstractActivityRegistry;
import org.eclipse.ui.internal.activities.ActivityDefinition;
import org.eclipse.ui.internal.activities.ActivityPatternBindingDefinition;
import org.eclipse.ui.internal.activities.ActivityRequirementBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryActivityBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryDefinition;
import org.eclipse.ui.internal.activities.Persistence;
import org.eclipse.ui.internal.util.ConfigurationElementMemento;
import org.eclipse.ui.statushandlers.StatusManager;

final class ExtensionActivityRegistry
extends AbstractActivityRegistry {
    private static final String PREFIX = "UIActivities.";
    private List<ActivityRequirementBindingDefinition> extensionActivityRequirementBindingDefinitions;
    private List<ActivityDefinition> extensionActivityDefinitions;
    private List<ActivityPatternBindingDefinition> extensionActivityPatternBindingDefinitions;
    private List<CategoryActivityBindingDefinition> extensionCategoryActivityBindingDefinitions;
    private List<CategoryDefinition> extensionCategoryDefinitions;
    private List<String> extensionDefaultEnabledActivities;
    private IExtensionRegistry extensionRegistry;

    ExtensionActivityRegistry(IExtensionRegistry extensionRegistry) {
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        this.extensionRegistry = extensionRegistry;
        this.extensionRegistry.addRegistryChangeListener(registryChangeEvent -> {
            IExtensionDelta[] extensionDeltas = registryChangeEvent.getExtensionDeltas("org.eclipse.ui", "activities");
            if (extensionDeltas.length != 0) {
                this.load();
            }
        });
        this.load();
    }

    private String getNamespace(IConfigurationElement configurationElement) {
        IExtension extension;
        String namespace = null;
        if (configurationElement != null && (extension = configurationElement.getDeclaringExtension()) != null) {
            namespace = extension.getContributor().getName();
        }
        return namespace;
    }

    private ActivityDefinition getActivityDefinitionById(String id) {
        int size = this.extensionActivityDefinitions.size();
        int i = 0;
        while (i < size) {
            ActivityDefinition activityDef = this.extensionActivityDefinitions.get(i);
            if (activityDef.getId().equals(id)) {
                return activityDef;
            }
            ++i;
        }
        return null;
    }

    private void load() {
        ActivityDefinition activityDef;
        IConfigurationElement[] configurationElements;
        if (this.extensionActivityRequirementBindingDefinitions == null) {
            this.extensionActivityRequirementBindingDefinitions = new ArrayList<ActivityRequirementBindingDefinition>();
        } else {
            this.extensionActivityRequirementBindingDefinitions.clear();
        }
        if (this.extensionActivityDefinitions == null) {
            this.extensionActivityDefinitions = new ArrayList<ActivityDefinition>();
        } else {
            this.extensionActivityDefinitions.clear();
        }
        if (this.extensionActivityPatternBindingDefinitions == null) {
            this.extensionActivityPatternBindingDefinitions = new ArrayList<ActivityPatternBindingDefinition>();
        } else {
            this.extensionActivityPatternBindingDefinitions.clear();
        }
        if (this.extensionCategoryActivityBindingDefinitions == null) {
            this.extensionCategoryActivityBindingDefinitions = new ArrayList<CategoryActivityBindingDefinition>();
        } else {
            this.extensionCategoryActivityBindingDefinitions.clear();
        }
        if (this.extensionCategoryDefinitions == null) {
            this.extensionCategoryDefinitions = new ArrayList<CategoryDefinition>();
        } else {
            this.extensionCategoryDefinitions.clear();
        }
        if (this.extensionDefaultEnabledActivities == null) {
            this.extensionDefaultEnabledActivities = new ArrayList<String>();
        } else {
            this.extensionDefaultEnabledActivities.clear();
        }
        IConfigurationElement[] iConfigurationElementArray = configurationElements = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.ui.activities");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            switch (name = configurationElement.getName()) {
                case "activityRequirementBinding": {
                    this.readActivityRequirementBindingDefinition(configurationElement);
                    break;
                }
                case "activity": {
                    this.readActivityDefinition(configurationElement);
                    break;
                }
                case "activityPatternBinding": {
                    this.readActivityPatternBindingDefinition(configurationElement);
                    break;
                }
                case "categoryActivityBinding": {
                    this.readCategoryActivityBindingDefinition(configurationElement);
                    break;
                }
                case "category": {
                    this.readCategoryDefinition(configurationElement);
                    break;
                }
                case "defaultEnablement": {
                    this.readDefaultEnablement(configurationElement);
                    break;
                }
            }
            ++n2;
        }
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        for (ActivityDefinition activityDef2 : this.extensionActivityDefinitions) {
            String id = activityDef2.getId();
            String preferenceKey = this.createPreferenceKey(id);
            if ("".equals(store.getDefaultString(preferenceKey))) continue;
            if (store.getDefaultBoolean(preferenceKey)) {
                if (this.extensionDefaultEnabledActivities.contains(id) || activityDef2.getEnabledWhen() != null) continue;
                this.extensionDefaultEnabledActivities.add(id);
                continue;
            }
            this.extensionDefaultEnabledActivities.remove(id);
        }
        int i = 0;
        while (i < this.extensionDefaultEnabledActivities.size()) {
            String id = this.extensionDefaultEnabledActivities.get(i);
            activityDef = this.getActivityDefinitionById(id);
            if (activityDef != null && activityDef.getEnabledWhen() != null) {
                this.extensionDefaultEnabledActivities.remove(i);
                StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.ui", "Default enabled activity declarations will be ignored (id: " + id + ")"));
                continue;
            }
            ++i;
        }
        Iterator<ActivityRequirementBindingDefinition> i2 = this.extensionActivityRequirementBindingDefinitions.iterator();
        while (i2.hasNext()) {
            ActivityRequirementBindingDefinition bindingDef = i2.next();
            activityDef = this.getActivityDefinitionById(bindingDef.getRequiredActivityId());
            if (activityDef != null && activityDef.getEnabledWhen() != null) {
                i2.remove();
                StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.ui", "Expression activity cannot have requirements (id: " + activityDef.getId() + ")"));
                continue;
            }
            activityDef = this.getActivityDefinitionById(bindingDef.getActivityId());
            if (activityDef == null || activityDef.getEnabledWhen() == null) continue;
            i2.remove();
            StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.ui", "Expression activity cannot be required (id: " + activityDef.getId() + ")"));
        }
        boolean activityRegistryChanged = false;
        if (!this.extensionActivityRequirementBindingDefinitions.equals(this.activityRequirementBindingDefinitions)) {
            this.activityRequirementBindingDefinitions = Collections.unmodifiableList(new ArrayList<ActivityRequirementBindingDefinition>(this.extensionActivityRequirementBindingDefinitions));
            activityRegistryChanged = true;
        }
        if (!this.extensionActivityDefinitions.equals(this.activityDefinitions)) {
            this.activityDefinitions = Collections.unmodifiableList(new ArrayList<ActivityDefinition>(this.extensionActivityDefinitions));
            activityRegistryChanged = true;
        }
        if (!this.extensionActivityPatternBindingDefinitions.equals(this.activityPatternBindingDefinitions)) {
            this.activityPatternBindingDefinitions = Collections.unmodifiableList(new ArrayList<ActivityPatternBindingDefinition>(this.extensionActivityPatternBindingDefinitions));
            activityRegistryChanged = true;
        }
        if (!this.extensionCategoryActivityBindingDefinitions.equals(this.categoryActivityBindingDefinitions)) {
            this.categoryActivityBindingDefinitions = Collections.unmodifiableList(new ArrayList<CategoryActivityBindingDefinition>(this.extensionCategoryActivityBindingDefinitions));
            activityRegistryChanged = true;
        }
        if (!this.extensionCategoryDefinitions.equals(this.categoryDefinitions)) {
            this.categoryDefinitions = Collections.unmodifiableList(new ArrayList<CategoryDefinition>(this.extensionCategoryDefinitions));
            activityRegistryChanged = true;
        }
        if (!this.extensionDefaultEnabledActivities.equals(this.defaultEnabledActivities)) {
            this.defaultEnabledActivities = Collections.unmodifiableList(new ArrayList<String>(this.extensionDefaultEnabledActivities));
            activityRegistryChanged = true;
        }
        if (activityRegistryChanged) {
            this.fireActivityRegistryChanged();
        }
    }

    private String createPreferenceKey(String activityId) {
        return PREFIX + activityId;
    }

    private void readDefaultEnablement(IConfigurationElement configurationElement) {
        String enabledActivity = Persistence.readDefaultEnablement(new ConfigurationElementMemento(configurationElement));
        if (enabledActivity != null) {
            this.extensionDefaultEnabledActivities.add(enabledActivity);
        }
    }

    private void readActivityRequirementBindingDefinition(IConfigurationElement configurationElement) {
        ActivityRequirementBindingDefinition activityRequirementBindingDefinition = Persistence.readActivityRequirementBindingDefinition(new ConfigurationElementMemento(configurationElement), this.getNamespace(configurationElement));
        if (activityRequirementBindingDefinition != null) {
            this.extensionActivityRequirementBindingDefinitions.add(activityRequirementBindingDefinition);
        }
    }

    private void readActivityDefinition(IConfigurationElement configurationElement) {
        ActivityDefinition activityDefinition = Persistence.readActivityDefinition(new ConfigurationElementMemento(configurationElement), this.getNamespace(configurationElement));
        if (activityDefinition != null) {
            IConfigurationElement[] expElement;
            IConfigurationElement[] enabledWhen = configurationElement.getChildren("enabledWhen");
            if (enabledWhen.length == 1 && (expElement = enabledWhen[0].getChildren()).length == 1) {
                try {
                    Expression expression = ExpressionConverter.getDefault().perform(expElement[0]);
                    activityDefinition.setEnabledWhen(expression);
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, WorkbenchPlugin.PI_WORKBENCH);
                }
            }
            this.extensionActivityDefinitions.add(activityDefinition);
        }
    }

    private void readActivityPatternBindingDefinition(IConfigurationElement configurationElement) {
        ActivityPatternBindingDefinition activityPatternBindingDefinition = Persistence.readActivityPatternBindingDefinition(new ConfigurationElementMemento(configurationElement), this.getNamespace(configurationElement));
        if (activityPatternBindingDefinition != null) {
            this.extensionActivityPatternBindingDefinitions.add(activityPatternBindingDefinition);
        }
    }

    private void readCategoryActivityBindingDefinition(IConfigurationElement configurationElement) {
        CategoryActivityBindingDefinition categoryActivityBindingDefinition = Persistence.readCategoryActivityBindingDefinition(new ConfigurationElementMemento(configurationElement), this.getNamespace(configurationElement));
        if (categoryActivityBindingDefinition != null) {
            this.extensionCategoryActivityBindingDefinitions.add(categoryActivityBindingDefinition);
        }
    }

    private void readCategoryDefinition(IConfigurationElement configurationElement) {
        CategoryDefinition categoryDefinition = Persistence.readCategoryDefinition(new ConfigurationElementMemento(configurationElement), this.getNamespace(configurationElement));
        if (categoryDefinition != null) {
            this.extensionCategoryDefinitions.add(categoryDefinition);
        }
    }
}

