/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class FileSystemAccess {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IPath getCacheLocation() {
        try {
            Bundle bundle = FrameworkUtil.getBundle(FileSystemAccess.class);
            if (bundle == null) return IPath.fromOSString((String)System.getProperty("user.home"));
            BundleContext context = bundle.getBundleContext();
            if (context == null) return IPath.fromOSString((String)System.getProperty("user.home"));
            tracker.open();
            try (ServiceTracker tracker = new ServiceTracker(context, context.createFilter(Location.INSTANCE_FILTER), null);){
                Location location = (Location)tracker.getService();
                if (location == null) return IPath.fromOSString((String)System.getProperty("user.home"));
                IPath instancePath = IPath.fromOSString((String)new File(location.getURL().getFile()).toString());
                IPath iPath = instancePath.append(".metadata/.plugins").append("org.eclipse.core.filesystem");
                return iPath;
            }
        }
        catch (InvalidSyntaxException e) {
            Policy.log(1, null, e);
        }
        return IPath.fromOSString((String)System.getProperty("user.home"));
    }

    public static Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        Bundle bundle = FrameworkUtil.getBundle(FileSystemAccess.class);
        if (bundle != null) {
            return bundle.findEntries(path, filePattern, recurse);
        }
        return Collections.emptyEnumeration();
    }
}

