/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.svg;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.cwt.svg.SvgContainer;
import org.eclipse.nebula.cwt.svg.SvgFragment;

public abstract class SvgElement {
    private SvgContainer container;
    private String id;

    static List<SvgElement> getAncestry(SvgElement element) {
        ArrayList<SvgElement> l = new ArrayList<SvgElement>();
        l.add(element);
        SvgContainer parent = element.getContainer();
        while (parent != null) {
            l.add(0, parent);
            parent = parent.getContainer();
        }
        return l;
    }

    SvgElement(SvgContainer container, String id) {
        this.container = container;
        this.id = id;
        if (container != null) {
            container.add(this);
            if (!(this instanceof SvgFragment)) {
                container.getFragment().put(this);
            }
        }
    }

    final SvgContainer getContainer() {
        return this.container;
    }

    SvgElement getElement(String id) {
        return this.getFragment().getElement(id);
    }

    SvgFragment getFragment() {
        if (this.container != null) {
            return this.container.getFragment();
        }
        return null;
    }

    public final String getId() {
        return this.id;
    }

    float[] getViewport() {
        return this.container.getViewport();
    }

    void setContainer(SvgContainer container) {
        this.container = container;
    }
}

