/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.resources.IFilterMatcherDescriptor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.ide.dialogs.UIResourceFilterDescription;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.FilterCopy;
import org.eclipse.ui.internal.ide.misc.FileInfoAttributesMatcher;
import org.eclipse.ui.internal.ide.misc.StringFileInfoMatcher;

class FilterTypeUtil {
    static String ID = "id";
    static String TARGET = "target";
    static String MODE = "mode";
    static String ARGUMENTS = "arguments";
    static String INHERITABLE = "inheritable";
    static String[] columnNames = new String[]{MODE, TARGET, INHERITABLE};

    static String[] getModes() {
        return new String[]{IDEWorkbenchMessages.ResourceFilterPage_includeOnly, IDEWorkbenchMessages.ResourceFilterPage_excludeAll};
    }

    public static void setValue(FilterCopy filter, String property, Object value) {
        int type;
        if (property.equals(ID)) {
            IFilterMatcherDescriptor descriptor;
            if (value instanceof Integer) {
                int selection = (Integer)value;
                descriptor = FilterTypeUtil.getDescriptorFromIndex(selection);
            } else {
                descriptor = FilterTypeUtil.getDescriptorByName((String)value);
            }
            if (descriptor != null) {
                filter.setId(descriptor.getId());
            }
        }
        if (property.equals(MODE)) {
            int selection = (Integer)value;
            type = filter.getType() & 0xFFFFFFFC;
            if (selection == 0) {
                filter.setType(type | 1);
            } else {
                filter.setType(type | 2);
            }
        }
        if (property.equals(TARGET)) {
            int selection = (Integer)value;
            type = filter.getType() & 0xFFFFFFF3;
            if (selection == 0) {
                filter.setType(type | 4);
            }
            if (selection == 1) {
                filter.setType(type | 8);
            }
            if (selection == 2) {
                filter.setType(type | 4 | 8);
            }
        }
        if (property.equals(INHERITABLE)) {
            int type2 = filter.getType() & 0xFFFFFFEF;
            if (((Boolean)value).booleanValue()) {
                filter.setType(type2 | 0x10);
            } else {
                filter.setType(type2);
            }
        }
        if (property.equals(ARGUMENTS)) {
            filter.setArguments(value.equals("") ? null : value);
        }
    }

    static IFilterMatcherDescriptor getDescriptor(String id) {
        IFilterMatcherDescriptor[] descriptors;
        IFilterMatcherDescriptor[] iFilterMatcherDescriptorArray = descriptors = ResourcesPlugin.getWorkspace().getFilterMatcherDescriptors();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IFilterMatcherDescriptor descriptor = iFilterMatcherDescriptorArray[n2];
            if (descriptor.getId().equals(id)) {
                return descriptor;
            }
            ++n2;
        }
        return null;
    }

    static int getDescriptorIndex(String id) {
        IFilterMatcherDescriptor[] descriptors = ResourcesPlugin.getWorkspace().getFilterMatcherDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getId().equals(id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static Object getValue(UIResourceFilterDescription filter, String property) {
        if (property.equals(ID)) {
            String id = filter.getFileInfoMatcherDescription().getId();
            return FilterTypeUtil.getDescriptorIndex(id);
        }
        if (property.equals(MODE)) {
            if ((filter.getType() & 1) != 0) {
                return 0;
            }
            return 1;
        }
        if (property.equals(TARGET)) {
            boolean includeFolders;
            boolean includeFiles = (filter.getType() & 4) != 0;
            boolean bl = includeFolders = (filter.getType() & 8) != 0;
            if (includeFiles && includeFolders) {
                return 2;
            }
            if (includeFiles) {
                return 0;
            }
            if (includeFolders) {
                return 1;
            }
        }
        if (property.equals(INHERITABLE)) {
            return (filter.getType() & 0x10) != 0;
        }
        if (property.equals(ARGUMENTS)) {
            return filter.getFileInfoMatcherDescription().getArguments() != null ? filter.getFileInfoMatcherDescription().getArguments() : "";
        }
        return null;
    }

    static String[] getTargets() {
        return new String[]{IDEWorkbenchMessages.ResourceFilterPage_files, IDEWorkbenchMessages.ResourceFilterPage_folders, IDEWorkbenchMessages.ResourceFilterPage_filesAndFolders};
    }

    static String[] getFilterNames(boolean groupOnly) {
        IFilterMatcherDescriptor[] descriptors = ResourcesPlugin.getWorkspace().getFilterMatcherDescriptors();
        FilterTypeUtil.sortDescriptors(descriptors);
        LinkedList<String> names = new LinkedList<String>();
        IFilterMatcherDescriptor[] iFilterMatcherDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IFilterMatcherDescriptor descriptor = iFilterMatcherDescriptorArray[n2];
            if (!descriptor.getId().equals("org.eclipse.core.resources.regexFilterMatcher") && !descriptor.getId().equals(StringFileInfoMatcher.ID)) {
                boolean isGroup;
                boolean bl = isGroup = descriptor.getArgumentType().equals("filterMatcher") || descriptor.getArgumentType().equals("filterMatchers");
                if (isGroup == groupOnly) {
                    names.add(descriptor.getName());
                }
            }
            ++n2;
        }
        return names.toArray(new String[0]);
    }

    private static void sortDescriptors(IFilterMatcherDescriptor[] descriptors) {
        Arrays.sort(descriptors, (arg0, arg1) -> {
            if (arg0.getId().equals(FileInfoAttributesMatcher.ID)) {
                return -1;
            }
            if (arg1.getId().equals(FileInfoAttributesMatcher.ID)) {
                return 1;
            }
            return arg0.getId().compareTo(arg1.getId());
        });
    }

    static String getDefaultFilterID() {
        IFilterMatcherDescriptor[] descriptors = ResourcesPlugin.getWorkspace().getFilterMatcherDescriptors();
        FilterTypeUtil.sortDescriptors(descriptors);
        IFilterMatcherDescriptor[] iFilterMatcherDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IFilterMatcherDescriptor descriptor = iFilterMatcherDescriptorArray[n2];
            if (descriptor.getArgumentType().equals("string")) {
                return descriptor.getId();
            }
            ++n2;
        }
        return descriptors[0].getId();
    }

    static IFilterMatcherDescriptor getDescriptorFromIndex(int index) {
        IFilterMatcherDescriptor[] descriptors = ResourcesPlugin.getWorkspace().getFilterMatcherDescriptors();
        return descriptors[index];
    }

    static IFilterMatcherDescriptor getDescriptorByName(String name) {
        IFilterMatcherDescriptor[] descriptors;
        IFilterMatcherDescriptor[] iFilterMatcherDescriptorArray = descriptors = ResourcesPlugin.getWorkspace().getFilterMatcherDescriptors();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IFilterMatcherDescriptor descriptor = iFilterMatcherDescriptorArray[n2];
            if (descriptor.getName().equals(name)) {
                return descriptor;
            }
            ++n2;
        }
        return null;
    }

    FilterTypeUtil() {
    }
}

