/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.views.markers.PriorityMarkerFieldFilter;
import org.eclipse.ui.views.markers.FilterConfigurationArea;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class PriorityConfigurationArea
extends FilterConfigurationArea {
    private int priorities;
    private Button highButton;
    private Button normalButton;
    private Button lowButton;

    @Override
    public void apply(MarkerFieldFilter filter) {
        ((PriorityMarkerFieldFilter)filter).selectedPriorities = this.priorities;
    }

    @Override
    public void createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        this.highButton = new Button(parent, 32);
        this.highButton.setText(MarkerMessages.filtersDialog_priorityHigh);
        this.highButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PriorityConfigurationArea.this.updatePriorities(4, PriorityConfigurationArea.this.highButton.getSelection());
            }
        });
        this.normalButton = new Button(parent, 32);
        this.normalButton.setText(MarkerMessages.filtersDialog_priorityNormal);
        this.normalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PriorityConfigurationArea.this.updatePriorities(2, PriorityConfigurationArea.this.normalButton.getSelection());
            }
        });
        this.lowButton = new Button(parent, 32);
        this.lowButton.setText(MarkerMessages.filtersDialog_priorityLow);
        this.lowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PriorityConfigurationArea.this.updatePriorities(1, PriorityConfigurationArea.this.lowButton.getSelection());
            }
        });
    }

    void updatePriorities(int constant, boolean enabled) {
        this.priorities = enabled ? constant | this.priorities : constant ^ this.priorities;
    }

    @Override
    public void initialize(MarkerFieldFilter filter) {
        this.priorities = ((PriorityMarkerFieldFilter)filter).selectedPriorities;
        this.lowButton.setSelection((1 & this.priorities) > 0);
        this.normalButton.setSelection((2 & this.priorities) > 0);
        this.highButton.setSelection((4 & this.priorities) > 0);
    }

    @Override
    public String getTitle() {
        return MarkerMessages.filtersDialog_priorityTitle;
    }
}

