/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage.url.reference;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import org.eclipse.osgi.framework.util.FilePath;
import org.eclipse.osgi.internal.location.LocationHelper;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.storage.url.reference.ReferenceInputStream;
import org.eclipse.osgi.util.NLS;

public class ReferenceURLConnection
extends URLConnection {
    private final String installPath;
    private volatile File reference;

    protected ReferenceURLConnection(URL url, String installPath) {
        super(url);
        this.installPath = installPath;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (!this.connected) {
            String path = this.getURL().getPath();
            if (!path.startsWith("file:")) {
                throw new IOException(NLS.bind(Msg.ADAPTOR_URL_CREATE_EXCEPTION, path));
            }
            File file = new File(path = path.substring(5));
            if (!file.isAbsolute() && this.installPath != null) {
                file = ReferenceURLConnection.makeAbsolute(this.installPath, file);
            }
            file = LocationHelper.decodePath(file);
            this.checkRead(file);
            this.reference = file;
            this.connected = true;
        }
    }

    private void checkRead(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        if (!Files.isReadable(file.toPath())) {
            File[] files;
            if (file.isFile()) {
                FileInputStream is = new FileInputStream(file);
                ((InputStream)is).close();
            } else if (file.isDirectory() && (files = file.listFiles()) == null) {
                throw new FileNotFoundException(String.valueOf(file.toString()) + " (probably access denied)");
            }
        }
    }

    @Override
    public boolean getDoInput() {
        return true;
    }

    @Override
    public boolean getDoOutput() {
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new ReferenceInputStream(this.reference);
    }

    private static File makeAbsolute(String base, File relative) {
        if (relative.isAbsolute()) {
            return relative;
        }
        return new File(new FilePath(String.valueOf(base) + relative.getPath()).toString());
    }
}

