/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.sync.impl;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.sync.RemoteData;
import org.eclipse.oomph.setup.sync.SyncAction;
import org.eclipse.oomph.setup.sync.SyncActionType;
import org.eclipse.oomph.setup.sync.SyncDelta;
import org.eclipse.oomph.setup.sync.SyncDeltaType;
import org.eclipse.oomph.setup.sync.SyncFactory;
import org.eclipse.oomph.setup.sync.SyncPackage;
import org.eclipse.oomph.setup.sync.SyncPolicy;
import org.eclipse.oomph.setup.sync.impl.RemoteDataImpl;
import org.eclipse.oomph.setup.sync.impl.StringToSyncPolicyMapEntryImpl;
import org.eclipse.oomph.setup.sync.impl.SyncActionImpl;
import org.eclipse.oomph.setup.sync.impl.SyncDeltaImpl;

public class SyncFactoryImpl
extends EFactoryImpl
implements SyncFactory {
    public static SyncFactory init() {
        try {
            SyncFactory theSyncFactory = (SyncFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/oomph/setup/sync/1.0");
            if (theSyncFactory != null) {
                return theSyncFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new SyncFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createRemoteData();
            }
            case 1: {
                return (EObject)this.createStringToSyncPolicyMapEntry();
            }
            case 2: {
                return this.createSyncDelta();
            }
            case 3: {
                return this.createSyncAction();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.createSyncPolicyFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createSyncDeltaTypeFromString(eDataType, initialValue);
            }
            case 6: {
                return this.createSyncActionTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.convertSyncPolicyToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertSyncDeltaTypeToString(eDataType, instanceValue);
            }
            case 6: {
                return this.convertSyncActionTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public RemoteData createRemoteData() {
        RemoteDataImpl remoteData = new RemoteDataImpl();
        return remoteData;
    }

    public Map.Entry<String, SyncPolicy> createStringToSyncPolicyMapEntry() {
        StringToSyncPolicyMapEntryImpl stringToSyncPolicyMapEntry = new StringToSyncPolicyMapEntryImpl();
        return stringToSyncPolicyMapEntry;
    }

    @Override
    public SyncDelta createSyncDelta() {
        SyncDeltaImpl syncDelta = new SyncDeltaImpl();
        return syncDelta;
    }

    @Override
    public SyncDelta createSyncDelta(String id, SetupTask oldTask, SetupTask newTask, SyncDeltaType type) {
        SyncDeltaImpl syncDelta = new SyncDeltaImpl();
        syncDelta.setID(id);
        syncDelta.setOldTask(oldTask);
        syncDelta.setNewTask(newTask);
        syncDelta.setType(type);
        return syncDelta;
    }

    @Override
    public SyncAction createSyncAction() {
        SyncActionImpl syncAction = new SyncActionImpl();
        return syncAction;
    }

    @Override
    public SyncAction createSyncAction(SyncDelta localDelta, SyncDelta remoteDelta, SyncActionType computedType) {
        SyncActionImpl syncAction = new SyncActionImpl();
        syncAction.setLocalDelta(localDelta);
        syncAction.setRemoteDelta(remoteDelta);
        syncAction.setComputedType(computedType);
        return syncAction;
    }

    public SyncPolicy createSyncPolicyFromString(EDataType eDataType, String initialValue) {
        SyncPolicy result = SyncPolicy.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSyncPolicyToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public SyncDeltaType createSyncDeltaTypeFromString(EDataType eDataType, String initialValue) {
        SyncDeltaType result = SyncDeltaType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSyncDeltaTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public SyncActionType createSyncActionTypeFromString(EDataType eDataType, String initialValue) {
        SyncActionType result = SyncActionType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSyncActionTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public SyncPackage getSyncPackage() {
        return (SyncPackage)this.getEPackage();
    }

    @Deprecated
    public static SyncPackage getPackage() {
        return SyncPackage.eINSTANCE;
    }
}

