/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.model.internal;

import org.eclipse.e4.ui.model.internal.Position;

public final class PositionInfo {
    private final Position position;
    private final String positionReference;
    public static final PositionInfo FIRST = new PositionInfo(Position.FIRST, null);
    public static final PositionInfo LAST = new PositionInfo(Position.LAST, null);

    public PositionInfo(Position position, String positionReference) {
        if (position == null) {
            throw new NullPointerException("No position given!");
        }
        this.position = position;
        this.positionReference = positionReference;
    }

    public Position getPosition() {
        return this.position;
    }

    public String getPositionReference() {
        return this.positionReference;
    }

    public int getPositionReferenceAsInteger() {
        return Integer.parseInt(this.positionReference);
    }

    public static PositionInfo parse(String positionInfo) {
        Position position = Position.find(positionInfo);
        if (position != null) {
            switch (position) {
                case FIRST: {
                    return FIRST;
                }
                case LAST: {
                    return LAST;
                }
            }
            return new PositionInfo(position, positionInfo.substring(position.prefix.length()));
        }
        return null;
    }

    public String toString() {
        StringBuilder back = new StringBuilder(this.position.prefix);
        if (this.positionReference != null) {
            back.append(this.positionReference);
        }
        return back.toString();
    }
}

