/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.cdatetime;

import java.awt.ComponentOrientation;
import java.text.BreakIterator;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.nebula.cwt.v.IControlPainter;
import org.eclipse.nebula.cwt.v.VButton;
import org.eclipse.nebula.cwt.v.VControl;
import org.eclipse.nebula.cwt.v.VGridLayout;
import org.eclipse.nebula.cwt.v.VLabel;
import org.eclipse.nebula.cwt.v.VLayout;
import org.eclipse.nebula.cwt.v.VPanel;
import org.eclipse.nebula.cwt.v.VStackLayout;
import org.eclipse.nebula.cwt.v.VTracker;
import org.eclipse.nebula.widgets.cdatetime.AnalogTimePicker;
import org.eclipse.nebula.widgets.cdatetime.Body;
import org.eclipse.nebula.widgets.cdatetime.CDT;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.nebula.widgets.cdatetime.CDateTimeBuilder;
import org.eclipse.nebula.widgets.cdatetime.DiscreteTimePicker;
import org.eclipse.nebula.widgets.cdatetime.Footer;
import org.eclipse.nebula.widgets.cdatetime.Header;
import org.eclipse.nebula.widgets.cdatetime.Resources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

class DatePicker
extends VPanel {
    private static final int DAYS_IN_WEEK = 7;
    private static final int NUM_ROWS = 6;
    private Listener dayListener;
    private VPanel header;
    private VPanel body;
    private VPanel[] bodyPanels;
    private VPanel footer;
    private VPanel dayPanel;
    VButton monthButton;
    VButton monthPrev;
    VButton dateNow;
    VButton monthNext;
    VButton yearButton;
    VButton yearPrev;
    VButton yearNext;
    VButton timeButton;
    VLabel[] dayLabels;
    VButton[] dayButtons;
    VButton today;
    VButton clear;
    MenuItem todayMenuItem;
    MenuItem showSelMenuItem;
    MenuItem[] monthItems;
    MenuItem[] yearItems;
    boolean editYear = false;
    private boolean scrollable = true;
    VPanel monthPanel;
    VButton[] monthButtons;
    VPanel yearPanel;
    VButton[] yearButtons;
    VPanel timePanel;
    private boolean useDiscreteClock;
    private CDateTime cdt;
    private SimpleDateFormat sdf;
    private String lastPattern;
    private VPanel picker;

    public DatePicker(CDateTime parent) {
        super(parent.pickerPanel, parent.style);
        this.cdt = parent;
        this.useDiscreteClock = (parent.style & 0x8000000) != 0;
        this.init(parent.style);
    }

    private void addBodyPanel() {
        if (this.bodyPanels == null) {
            this.bodyPanels = new VPanel[1];
        } else {
            VPanel[] pa = new VPanel[this.bodyPanels.length + 1];
            System.arraycopy(this.bodyPanels, 0, pa, 0, this.bodyPanels.length);
            this.bodyPanels = pa;
            ++((VGridLayout)this.body.getLayout(VGridLayout.class)).numColumns;
        }
        this.picker = new VPanel(this.body, 0);
        this.picker.setData("PickerPart", (Object)CDT.PickerPart.BodyPanel);
        this.picker.setPainter((IControlPainter)this.cdt.getPainter());
        this.cdt.getPainter().update((VControl)this.picker);
        this.picker.setLayout((VLayout)new VStackLayout());
        this.picker.setLayoutData(new GridData(4, 4, true, true));
        if (this.cdt.pickerBackgroundColor != null) {
            this.picker.setBackground(this.cdt.pickerBackgroundColor);
        }
        if (this.cdt.pickerForegroundColor != null) {
            this.picker.setForeground(this.cdt.pickerForegroundColor);
        }
        if (this.cdt.pickerFont != null) {
            this.picker.setFont(this.cdt.pickerFont);
        }
        this.bodyPanels[this.bodyPanels.length - 1] = this.picker;
    }

    private void adjustDays(int field, int amount) {
        Calendar tmpcal = this.cdt.getCalendarInstance();
        VButton[] vButtonArray = this.dayButtons;
        int n = this.dayButtons.length;
        int n2 = 0;
        while (n2 < n) {
            VButton dayButton = vButtonArray[n2];
            tmpcal.setTime((Date)dayButton.getData((Enum)CDT.Key.Date, Date.class));
            tmpcal.add(field, amount);
            dayButton.setData((Enum)CDT.Key.Date, (Object)tmpcal.getTime());
            ++n2;
        }
    }

    private void createBody() {
        this.body = new VPanel((VPanel)this, 0);
        this.body.setData("PickerPart", (Object)CDT.PickerPart.BodyPanel);
        this.body.setPainter((IControlPainter)this.cdt.getPainter());
        this.cdt.getPainter().update((VControl)this.body);
        VGridLayout layout = new VGridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        this.body.setLayout((VLayout)layout);
        this.body.setLayoutData(new GridData(4, 4, true, true));
        this.addBodyPanel();
        for (Body b : this.cdt.builder.getBodies()) {
            if (b.newColumn) {
                VLabel sep = new VLabel(this.body, 514);
                sep.setLayoutData(new GridData(4, 4, false, false));
                ++((VGridLayout)this.body.getLayout(VGridLayout.class)).numColumns;
                this.addBodyPanel();
            }
            switch (b.type) {
                case 0: {
                    this.createDays(b);
                    break;
                }
                case 1: {
                    this.createMonths(b);
                    break;
                }
                case 3: {
                    this.createTime(b);
                    break;
                }
                case 2: {
                    this.createYears(b);
                }
            }
        }
        VPanel[] vPanelArray = this.bodyPanels;
        int n = this.bodyPanels.length;
        int n2 = 0;
        while (n2 < n) {
            VPanel bodyPanel = vPanelArray[n2];
            ((VStackLayout)bodyPanel.getLayout(VStackLayout.class)).setTopControl(null);
            ++n2;
        }
    }

    protected void createContents() {
        VGridLayout layout = new VGridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.setLayout((VLayout)layout);
        if (this.cdt.builder.hasHeader()) {
            this.createHeader();
        }
        if (this.cdt.builder.hasHeader() && (this.cdt.builder.hasBody() || this.cdt.builder.hasFooter())) {
            VLabel separator = new VLabel((VPanel)this, 258);
            separator.setLayoutData(new GridData(4, 4, false, false));
        }
        if (this.cdt.builder.hasBody()) {
            this.createBody();
        }
        if ((this.cdt.builder.hasHeader() || this.cdt.builder.hasBody()) && this.cdt.builder.hasFooter()) {
            VLabel sep = new VLabel((VPanel)this, 258);
            sep.setLayoutData(new GridData(4, 4, false, false));
        }
        if (this.cdt.builder.hasFooter()) {
            this.createFooter();
        }
    }

    private void createDays(Body b) {
        VPanel bodyPanel = this.bodyPanels[this.bodyPanels.length - 1];
        this.dayPanel = new VPanel(bodyPanel, 524288);
        this.dayPanel.setData("PickerPart", (Object)CDT.PickerPart.DayPanel);
        this.dayPanel.setPainter((IControlPainter)this.cdt.getPainter());
        this.cdt.getPainter().update((VControl)this.dayPanel);
        VGridLayout layout = new VGridLayout(7, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = b.spacing;
        layout.verticalSpacing = b.spacing;
        this.dayPanel.setLayout((VLayout)layout);
        if (this.cdt.pickerBackgroundColor != null) {
            this.dayPanel.setBackground(this.cdt.pickerBackgroundColor);
        }
        if (this.cdt.pickerForegroundColor != null) {
            this.dayPanel.setForeground(this.cdt.pickerForegroundColor);
        }
        if (this.cdt.pickerFont != null) {
            this.dayPanel.setFont(this.cdt.pickerFont);
        }
        ((VStackLayout)bodyPanel.getLayout(VStackLayout.class)).setDefault((VControl)this.dayPanel, false);
        this.addListener(37, event -> this.scrollCalendar(event.count > 0 ? 0x1000001 : 0x1000002));
        Menu bodyMenu = this.dayPanel.createMenu();
        this.todayMenuItem = new MenuItem(bodyMenu, 0);
        this.todayMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatePicker.this.setCDTSelection(new Date());
            }
        });
        this.showSelMenuItem = new MenuItem(bodyMenu, 0);
        this.showSelMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatePicker.this.cdt.showSelection();
            }
        });
        this.dayListener = event -> {
            switch (event.type) {
                case 1: {
                    if (event.stateMask != 0) break;
                    if (event.keyCode == 0x1000050 || event.character == '\r' || event.character == ' ') {
                        this.setSelectionFromFocusButton(event);
                        break;
                    }
                    if (event.keyCode != 0x1000007 && event.keyCode != 0x1000008 && event.keyCode != 0x1000006 && event.keyCode != 0x1000005) break;
                    this.scrollCalendar(event.keyCode);
                    this.setSelectionFromFocusButton(event);
                    break;
                }
                case 3: {
                    if (event.button != 3) break;
                    this.dayPanel.getMenu().setVisible(true);
                    break;
                }
                case 37: {
                    this.scrollCalendar(event.count > 0 ? 0x1000001 : 0x1000002);
                    break;
                }
                case 13: {
                    if (event.widget != null) break;
                    VButton button = (VButton)event.data;
                    int stateMask = event.stateMask;
                    this.setSelectionFromButton(button, stateMask);
                    if (this.cdt.isClosingField(5)) {
                        this.cdt.fireSelectionChanged(true);
                        break;
                    }
                    this.cdt.fireSelectionChanged();
                    break;
                }
                case 31: {
                    if (event.detail == 4) {
                        this.setSelectionFromFocusButton(event);
                        break;
                    }
                    this.traverseSelection(event.keyCode);
                    this.setSelectionFromFocusButton(event);
                }
            }
        };
        this.dayLabels = new VLabel[7];
        int day = 0;
        while (day < this.dayLabels.length) {
            this.dayLabels[day] = new VLabel(this.dayPanel, 0x1000000);
            this.dayLabels[day].setData("PickerPart", (Object)CDT.PickerPart.DayOfWeekLabel);
            this.dayLabels[day].setData((Enum)CDT.Key.Compact, (Object)b.compact);
            this.dayLabels[day].setData((Enum)CDT.Key.Index, (Object)day);
            this.dayLabels[day].setPainter((IControlPainter)this.cdt.getPainter());
            this.cdt.getPainter().update((VControl)this.dayLabels[day]);
            this.dayLabels[day].setMargins(1, 1);
            if (this.cdt.pickerForegroundColor != null) {
                this.dayLabels[day].setForeground(this.cdt.pickerForegroundColor);
            }
            this.dayLabels[day].setLayoutData(new GridData(4, 0x1000000, true, false));
            ++day;
        }
        VLabel sep = new VLabel(this.dayPanel, 258);
        sep.setLayoutData(new GridData(4, 4, false, false, 7, 1));
        this.dayButtons = new VButton[42];
        int day2 = 0;
        while (day2 < this.dayButtons.length) {
            this.dayButtons[day2] = new VButton(this.dayPanel, 2);
            this.dayButtons[day2].setData("PickerPart", (Object)CDT.PickerPart.DayButton);
            this.dayButtons[day2].setData((Enum)CDT.Key.Index, (Object)day2);
            this.dayButtons[day2].setPainter((IControlPainter)this.cdt.getPainter());
            this.cdt.getPainter().update((VControl)this.dayButtons[day2]);
            this.dayButtons[day2].setSquare(true);
            this.dayButtons[day2].setMargins(4, 4);
            this.dayButtons[day2].setLayoutData(new GridData(4, 4, true, true));
            this.dayButtons[day2].addListener(1, this.dayListener);
            this.dayButtons[day2].addListener(3, this.dayListener);
            this.dayButtons[day2].addListener(37, this.dayListener);
            this.dayButtons[day2].addListener(13, this.dayListener);
            this.dayButtons[day2].addListener(31, this.dayListener);
            this.colorButtons(this.dayButtons[day2]);
            ++day2;
        }
    }

    private void colorButtons(VButton button) {
        if (button == null) {
            return;
        }
        button.setHoverBackgroundColor(this.cdt.buttonHoverBackgroundColor);
        button.setHoverBorderColor(this.cdt.buttonHoverBorderColor);
        button.setSelectedBackgroundColor(this.cdt.buttonSelectedBackgroundColor);
        button.setSelectedBorderColor(this.cdt.buttonSelectedBorderColor);
        if (this.cdt.pickerForegroundColor != null) {
            button.setForeground(this.cdt.pickerForegroundColor);
        }
        button.setFont(this.cdt.pickerFont);
    }

    private void createFooter() {
        this.footer = new VPanel((VPanel)this, 0);
        this.footer.setData("PickerPart", (Object)CDT.PickerPart.FooterPanel);
        this.footer.setPainter((IControlPainter)this.cdt.getPainter());
        this.cdt.getPainter().update((VControl)this.footer);
        VGridLayout layout = new VGridLayout();
        layout.makeColumnsEqualWidth = this.cdt.builder.getFooterEqualColumns();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        this.footer.setLayout((VLayout)layout);
        this.footer.setLayoutData(new GridData(this.cdt.builder.getFooterAlignment(), 4, true, false));
        for (Footer f : this.cdt.builder.getFooters()) {
            ++((VGridLayout)this.footer.getLayout()).numColumns;
            switch (f.type) {
                case 0: {
                    this.clear = new VButton(this.footer, 524296);
                    this.clear.setData("PickerPart", (Object)CDT.PickerPart.ClearButton);
                    this.clear.setPainter((IControlPainter)this.cdt.getPainter());
                    this.cdt.getPainter().update((VControl)this.clear);
                    this.clear.setLayoutData(new GridData(f.alignment, 4, f.grab, false));
                    this.clear.addListener(13, event -> this.setCDTSelection(null));
                    this.colorButtons(this.clear);
                    break;
                }
                case 1: 
                case 2: {
                    this.today = new VButton(this.footer, 524296);
                    this.today.setData("PickerPart", (Object)CDT.PickerPart.TodayButton);
                    this.today.setPainter((IControlPainter)this.cdt.getPainter());
                    this.cdt.getPainter().update((VControl)this.today);
                    this.today.setLayoutData(new GridData(f.alignment, 4, f.grab, false));
                    this.today.addListener(13, event -> this.setCDTSelection(new Date()));
                    this.colorButtons(this.today);
                }
            }
        }
    }

    private void createHeader() {
        this.header = new VPanel((VPanel)this, 0);
        this.header.setData("PickerPart", (Object)CDT.PickerPart.HeaderPanel);
        this.header.setPainter((IControlPainter)this.cdt.getPainter());
        this.cdt.getPainter().update((VControl)this.header);
        VGridLayout layout = new VGridLayout();
        layout.makeColumnsEqualWidth = this.cdt.builder.getHeaderEqualColumns();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        this.header.setLayout((VLayout)layout);
        this.header.setLayoutData(new GridData(this.cdt.builder.getHeaderAlignment(), 4, true, false));
        block10: for (Header h : this.cdt.builder.getHeaders()) {
            ++((VGridLayout)this.header.getLayout()).numColumns;
            GridData data = new GridData(h.alignment, 4, h.grab, false);
            switch (h.type) {
                case 0: {
                    this.dateNow = new VButton(this.header, 524296);
                    this.dateNow.setData("PickerPart", (Object)CDT.PickerPart.DateNow);
                    this.dateNow.setPainter((IControlPainter)this.cdt.getPainter());
                    this.cdt.getPainter().update((VControl)this.dateNow);
                    this.dateNow.setMargins(4, 0);
                    this.dateNow.setPolygon(new int[]{7, 7});
                    this.dateNow.setLayoutData(data);
                    this.dateNow.addListener(13, event -> this.setCDTSelection(new Date()));
                    this.colorButtons(this.dateNow);
                    break;
                }
                case 5: {
                    this.monthButton = new VButton(this.header, 524290);
                    this.monthButton.setData("PickerPart", (Object)CDT.PickerPart.MonthLabel);
                    this.monthButton.setPainter((IControlPainter)this.cdt.getPainter());
                    this.cdt.getPainter().update((VControl)this.monthButton);
                    this.monthButton.setAlignment(h.textAlignment, 0x1000000);
                    this.monthButton.setLayoutData(data);
                    if (h.readOnly) {
                        this.monthButton.setPaintNative(false);
                        break;
                    }
                    this.colorButtons(this.monthButton);
                    if (CDT.gtk) {
                        this.monthButton.addListener(37, event -> {
                            if (37 == event.type) {
                                Calendar tmpcal = this.cdt.getCalendarInstance();
                                tmpcal.add(2, event.count > 0 ? 1 : -1);
                                this.setCDTSelection(tmpcal.getTime());
                            }
                        });
                    }
                    this.monthButton.addListener(13, event -> this.handleHeaderSelection((VButton)event.data));
                    Menu monthMenu = this.monthButton.createMenu();
                    this.monthItems = new MenuItem[12];
                    int i = 0;
                    while (i < 12) {
                        Calendar tmpcal = this.cdt.getCalendarInstance();
                        tmpcal.set(2, i);
                        this.monthItems[i] = new MenuItem(monthMenu, 0);
                        this.monthItems[i].setData("Month", (Object)new Integer(tmpcal.get(2)));
                        this.monthItems[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                MenuItem item = (MenuItem)e.widget;
                                Calendar tmpcal = DatePicker.this.cdt.getCalendarInstance();
                                tmpcal.set(2, (Integer)item.getData("Month"));
                                DatePicker.this.setCDTSelection(tmpcal.getTime());
                            }
                        });
                        ++i;
                    }
                    continue block10;
                }
                case 2: {
                    this.monthNext = new VButton(this.header, 655364);
                    this.monthNext.setData("PickerPart", (Object)CDT.PickerPart.MonthNext);
                    this.monthNext.setPainter((IControlPainter)this.cdt.getPainter());
                    this.cdt.getPainter().update((VControl)this.monthNext);
                    this.monthNext.setLayoutData(new GridData(4, 4, false, false));
                    this.monthNext.addListener(13, event -> {
                        Calendar tmpcal = this.cdt.getCalendarInstance();
                        if (this.yearNext == null && this.yearButton != null && this.yearButton.getSelection()) {
                            tmpcal.add(1, 10);
                        } else {
                            tmpcal.add(2, 1);
                        }
                        this.setCDTSelection(tmpcal.getTime());
                    });
                    this.colorButtons(this.monthNext);
                    break;
                }
                case 1: {
                    this.monthPrev = new VButton(this.header, 540676);
                    this.monthPrev.setData("PickerPart", (Object)CDT.PickerPart.MonthPrev);
                    this.monthPrev.setPainter((IControlPainter)this.cdt.getPainter());
                    this.cdt.getPainter().update((VControl)this.monthPrev);
                    this.monthPrev.setLayoutData(new GridData(4, 4, false, false));
                    this.monthPrev.addListener(13, event -> {
                        Calendar tmpcal = this.cdt.getCalendarInstance();
                        if (this.yearPrev == null && this.yearButton != null && this.yearButton.getSelection()) {
                            tmpcal.add(1, -10);
                        } else {
                            tmpcal.add(2, -1);
                        }
                        this.setCDTSelection(tmpcal.getTime());
                    });
                    this.colorButtons(this.monthPrev);
                    break;
                }
                case 7: {
                    this.timeButton = new VButton(this.header, 524290);
                    this.timeButton.setMargins(3, 5);
                    this.timeButton.setImage(Resources.getIconClock());
                    this.timeButton.setData("PickerPart", (Object)CDT.PickerPart.MonthPrev);
                    this.timeButton.setPainter((IControlPainter)this.cdt.getPainter());
                    this.cdt.getPainter().update((VControl)this.timeButton);
                    this.timeButton.setLayoutData(new GridData(4, 4, false, false));
                    this.timeButton.addListener(13, event -> this.handleHeaderSelection((VButton)event.data));
                    this.colorButtons(this.timeButton);
                    break;
                }
                case 6: {
                    this.yearButton = new VButton(this.header, 524290);
                    this.yearButton.setData("PickerPart", (Object)CDT.PickerPart.YearLabel);
                    this.yearButton.setPainter((IControlPainter)this.cdt.getPainter());
                    this.cdt.getPainter().update((VControl)this.yearButton);
                    this.yearButton.setAlignment(h.textAlignment, 0x1000000);
                    this.yearButton.setLayoutData(data);
                    if (h.readOnly) {
                        this.yearButton.setPaintNative(false);
                        break;
                    }
                    this.colorButtons(this.yearButton);
                    if (CDT.gtk) {
                        this.yearButton.addListener(37, event -> {
                            if (37 == event.type) {
                                Calendar tmpcal = this.cdt.getCalendarInstance();
                                tmpcal.add(1, event.count > 0 ? 1 : -1);
                                this.setCDTSelection(tmpcal.getTime());
                            }
                        });
                    }
                    this.yearButton.addListener(13, event -> this.handleHeaderSelection((VButton)event.data));
                    Menu yearMenu = this.yearButton.createMenu();
                    this.yearItems = new MenuItem[11];
                    int i = 0;
                    while (i < 11) {
                        this.yearItems[i] = new MenuItem(yearMenu, 0);
                        this.yearItems[i].setData("Year", (Object)new Integer(i));
                        this.yearItems[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                MenuItem item = (MenuItem)e.widget;
                                Calendar tmpcal = DatePicker.this.cdt.getCalendarInstance();
                                tmpcal.add(1, (Integer)item.getData("Year") - 5);
                                DatePicker.this.setCDTSelection(tmpcal.getTime());
                            }
                        });
                        ++i;
                    }
                    continue block10;
                }
                case 4: {
                    this.yearNext = new VButton(this.header, 655364);
                    this.yearNext.setData("PickerPart", (Object)CDT.PickerPart.YearNext);
                    this.yearNext.setPainter((IControlPainter)this.cdt.getPainter());
                    this.cdt.getPainter().update((VControl)this.yearNext);
                    this.yearNext.setLayoutData(data);
                    this.yearNext.addListener(13, event -> {
                        Calendar tmpcal = this.cdt.getCalendarInstance();
                        if (this.yearButton != null && this.yearButton.getSelection()) {
                            tmpcal.add(1, 10);
                        } else if (this.cdt.isClosingField(1)) {
                            tmpcal.add(1, 10);
                        } else {
                            tmpcal.add(1, 1);
                        }
                        this.setCDTSelection(tmpcal.getTime());
                    });
                    this.colorButtons(this.yearNext);
                    break;
                }
                case 3: {
                    this.yearPrev = new VButton(this.header, 540676);
                    this.yearPrev.setData("PickerPart", (Object)CDT.PickerPart.YearPrev);
                    this.yearPrev.setPainter((IControlPainter)this.cdt.getPainter());
                    this.cdt.getPainter().update((VControl)this.yearPrev);
                    this.yearPrev.setLayoutData(data);
                    this.yearPrev.addListener(13, event -> {
                        Calendar tmpcal = this.cdt.getCalendarInstance();
                        if (this.yearButton != null && this.yearButton.getSelection()) {
                            tmpcal.add(1, -10);
                        } else if (this.cdt.isClosingField(1)) {
                            tmpcal.add(1, -10);
                        } else {
                            tmpcal.add(1, -1);
                        }
                        this.setCDTSelection(tmpcal.getTime());
                    });
                    this.colorButtons(this.yearPrev);
                }
            }
        }
    }

    private void createMonths(Body b) {
        VPanel bodyPanel = this.bodyPanels[this.bodyPanels.length - 1];
        this.monthPanel = new VPanel(bodyPanel, 0);
        this.monthPanel.setData("PickerPart", (Object)CDT.PickerPart.DayOfWeekPanel);
        this.monthPanel.setPainter((IControlPainter)this.cdt.getPainter());
        this.cdt.getPainter().update((VControl)this.monthPanel);
        VGridLayout layout = new VGridLayout(3, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = b.spacing;
        layout.verticalSpacing = b.spacing;
        this.monthPanel.setLayout((VLayout)layout);
        if (this.cdt.pickerBackgroundColor != null) {
            this.monthPanel.setBackground(this.cdt.pickerBackgroundColor);
        }
        if (this.cdt.pickerForegroundColor != null) {
            this.monthPanel.setForeground(this.cdt.pickerForegroundColor);
        }
        if (this.cdt.pickerFont != null) {
            this.monthPanel.setFont(this.cdt.pickerFont);
        }
        ((VStackLayout)bodyPanel.getLayout(VStackLayout.class)).setDefault((VControl)this.monthPanel, false);
        this.monthButtons = new VButton[12];
        int month = 0;
        while (month < this.monthButtons.length) {
            this.monthButtons[month] = new VButton(this.monthPanel, this.cdt.field.length > 1 ? 524296 : 2);
            this.monthButtons[month].setSquare(true);
            this.monthButtons[month].setData("month", (Object)month);
            this.monthButtons[month].setData("PickerPart", (Object)CDT.PickerPart.DayOfWeekLabel);
            this.monthButtons[month].setData((Enum)CDT.Key.Index, (Object)month);
            this.monthButtons[month].setPainter((IControlPainter)this.cdt.getPainter());
            this.cdt.getPainter().update((VControl)this.monthButtons[month]);
            this.monthButtons[month].setLayoutData(new GridData(4, 4, true, true));
            this.colorButtons(this.monthButtons[month]);
            this.monthButtons[month].addListener(13, event -> {
                if (event.widget == null) {
                    VButton button = (VButton)event.data;
                    if (button.hasStyle(2)) {
                        VButton[] vButtonArray = this.monthButtons;
                        int n = this.monthButtons.length;
                        int n2 = 0;
                        while (n2 < n) {
                            VButton b1 = vButtonArray[n2];
                            if (b1 != button) {
                                b1.setSelection(false);
                            }
                            ++n2;
                        }
                    }
                    Calendar tmpcal = this.cdt.getCalendarInstance();
                    int tmpday = tmpcal.get(5);
                    Integer tmpmonth = (Integer)button.getData("Month");
                    tmpcal.set(tmpcal.get(1), tmpmonth, 1);
                    if (tmpcal.getActualMaximum(5) < tmpday) {
                        tmpday = tmpcal.getActualMaximum(5);
                    }
                    tmpcal.set(5, tmpday);
                    tmpcal.set(2, tmpmonth);
                    if (this.isValidDate(tmpcal)) {
                        this.cdt.setSelection(tmpcal.getTime());
                    }
                    if (this.cdt.isClosingField(2)) {
                        this.cdt.fireSelectionChanged(true);
                    } else {
                        this.cdt.fireSelectionChanged();
                        this.handleHeaderSelection(null);
                    }
                }
            });
            ++month;
        }
        this.updateMonths();
        if (this.monthButton != null) {
            this.monthButton.setData((Enum)CDT.Key.Panel, (Object)this.monthPanel);
        }
    }

    private void createTime(Body b) {
        VPanel bodyPanel = this.bodyPanels[this.bodyPanels.length - 1];
        this.timePanel = this.useDiscreteClock ? new DiscreteTimePicker(this.cdt) : new AnalogTimePicker(this.cdt, this);
        this.timePanel.setParent(bodyPanel);
        ((VStackLayout)bodyPanel.getLayout(VStackLayout.class)).setDefault((VControl)this.timePanel, false);
        if (this.timeButton != null) {
            this.timeButton.setData((Enum)CDT.Key.Panel, (Object)this.timePanel);
        }
    }

    private void createYears(Body b) {
        VPanel bodyPanel = this.bodyPanels[this.bodyPanels.length - 1];
        this.yearPanel = new VPanel(bodyPanel, 0);
        this.yearPanel.setData("PickerPart", (Object)CDT.PickerPart.DayOfWeekPanel);
        this.yearPanel.setPainter((IControlPainter)this.cdt.getPainter());
        this.cdt.getPainter().update((VControl)this.yearPanel);
        VGridLayout layout = new VGridLayout(3, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = b.spacing;
        layout.verticalSpacing = b.spacing;
        this.yearPanel.setLayout((VLayout)layout);
        if (this.cdt.pickerBackgroundColor != null) {
            this.yearPanel.setBackground(this.cdt.pickerBackgroundColor);
        }
        if (this.cdt.pickerForegroundColor != null) {
            this.yearPanel.setForeground(this.cdt.pickerForegroundColor);
        }
        if (this.cdt.pickerFont != null) {
            this.yearPanel.setFont(this.cdt.pickerFont);
        }
        ((VStackLayout)bodyPanel.getLayout(VStackLayout.class)).setDefault((VControl)this.yearPanel, false);
        this.yearButtons = new VButton[15];
        int year = 0;
        while (year < this.yearButtons.length) {
            this.yearButtons[year] = new VButton(this.yearPanel, this.cdt.field.length > 1 ? 524296 : 2);
            this.yearButtons[year].setSquare(true);
            this.yearButtons[year].setData("PickerPart", (Object)CDT.PickerPart.DayOfWeekLabel);
            this.yearButtons[year].setData((Enum)CDT.Key.Index, (Object)year);
            this.yearButtons[year].setPainter((IControlPainter)this.cdt.getPainter());
            this.cdt.getPainter().update((VControl)this.yearButtons[year]);
            this.colorButtons(this.yearButtons[year]);
            this.yearButtons[year].addListener(13, event -> {
                if (event.widget == null) {
                    VButton button = (VButton)event.data;
                    if (button.hasStyle(2)) {
                        VButton[] vButtonArray = this.yearButtons;
                        int n = this.yearButtons.length;
                        int n2 = 0;
                        while (n2 < n) {
                            VButton b1 = vButtonArray[n2];
                            if (b1 != button) {
                                b1.setSelection(false);
                            }
                            ++n2;
                        }
                    }
                    Calendar tmpcal = this.cdt.getCalendarInstance();
                    tmpcal.set(1, Integer.parseInt(button.getText()));
                    this.cdt.setSelection(tmpcal.getTime());
                    if (this.cdt.isClosingField(1)) {
                        this.cdt.fireSelectionChanged(true);
                    } else {
                        this.cdt.fireSelectionChanged();
                        this.handleHeaderSelection(null);
                    }
                }
            });
            ++year;
        }
        if (this.yearButton != null) {
            this.yearButton.setData((Enum)CDT.Key.Panel, (Object)this.yearPanel);
        }
    }

    public int[] getFields() {
        return new int[]{1, 2, 5};
    }

    private int getFocusDayButton() {
        VControl focusControl = VTracker.getFocusControl();
        if (focusControl != null) {
            int i = 0;
            while (i < this.dayButtons.length) {
                if (focusControl == this.dayButtons[i]) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private String getFormattedDate(String pattern, Date date) {
        if (pattern != null) {
            if (this.sdf == null) {
                this.sdf = new SimpleDateFormat(pattern, this.cdt.locale);
                this.sdf.setTimeZone(this.cdt.timezone);
            } else if (!pattern.equals(this.lastPattern)) {
                this.sdf.applyPattern(pattern);
            }
            this.lastPattern = pattern;
            return this.sdf.format(date);
        }
        return "";
    }

    private void handleHeaderSelection(VButton button) {
        if (this.monthButton != null && this.monthButton != button) {
            this.monthButton.setSelection(false);
        }
        if (this.yearButton != null && this.yearButton != button) {
            this.yearButton.setSelection(false);
        }
        if (this.timeButton != null && this.timeButton != button) {
            this.timeButton.setSelection(false);
        }
        if (button != null && button.getSelection()) {
            VPanel panel = (VPanel)button.getData((Enum)CDT.Key.Panel, VPanel.class);
            ((VStackLayout)panel.getParent().getLayout(VStackLayout.class)).setTopControl((VControl)panel, 500);
        } else {
            VPanel[] vPanelArray = this.bodyPanels;
            int n = this.bodyPanels.length;
            int n2 = 0;
            while (n2 < n) {
                VPanel panel = vPanelArray[n2];
                ((VStackLayout)panel.getLayout(VStackLayout.class)).setTopControl(null, 500);
                ++n2;
            }
        }
    }

    private void init(int style) {
        if (this.cdt.builder == null) {
            this.cdt.builder = this.cdt.field.length > 1 && (style & 0x8000) != 0 ? CDateTimeBuilder.getCompact() : CDateTimeBuilder.getStandard();
        }
    }

    private void scrollCalendar(int keycode) {
        if (this.scrollable) {
            switch (keycode) {
                case 0x1000002: {
                    this.adjustDays(5, 7);
                    break;
                }
                case 0x1000001: {
                    this.adjustDays(5, -7);
                    break;
                }
                case 0x1000008: {
                    this.adjustDays(1, 1);
                    break;
                }
                case 0x1000007: {
                    this.adjustDays(1, -1);
                    break;
                }
                case 0x1000006: {
                    this.adjustDays(2, 1);
                    break;
                }
                case 0x1000005: {
                    this.adjustDays(2, -1);
                }
            }
        }
    }

    private void setButtonFocus(int index) {
        if (index >= 0 && index < this.dayButtons.length) {
            VButton button = this.dayButtons[index];
            button.setFocus();
        }
    }

    private void setDays(Date firstDate, boolean alignMonth) {
        Calendar tmpcal = this.cdt.getCalendarInstance();
        tmpcal.setTime(firstDate);
        if (alignMonth) {
            tmpcal.set(5, 1);
            int firstDay = tmpcal.get(7) - tmpcal.getFirstDayOfWeek();
            if (firstDay < 0) {
                firstDay += 7;
            }
            tmpcal.add(5, -firstDay);
        }
        VButton[] vButtonArray = this.dayButtons;
        int n = this.dayButtons.length;
        int n2 = 0;
        while (n2 < n) {
            VButton dayButton = vButtonArray[n2];
            dayButton.setData((Enum)CDT.Key.Date, (Object)tmpcal.getTime());
            tmpcal.add(5, 1);
            ++n2;
        }
    }

    public void setEditable(boolean editable) {
        this.setStyle(8, !editable);
        if (this.dayPanel != null) {
            this.dayPanel.setActivatable(false);
        }
        if (this.timePanel != null) {
            this.timePanel.setActivatable(false);
        }
    }

    public void setFields(int[] calendarFields) {
        this.cdt.builder.setFields(calendarFields);
        this.createContents();
        this.updateLabels();
        if (this.monthButton != null) {
            this.monthButton.addListener(11, event -> {
                if (11 == event.type) {
                    this.setMonthLabelText();
                }
            });
        }
        if (this.timePanel instanceof AnalogTimePicker) {
            ((AnalogTimePicker)this.timePanel).setFields(calendarFields);
        } else if (this.timePanel instanceof DiscreteTimePicker) {
            ((DiscreteTimePicker)this.timePanel).setFields(calendarFields);
        }
    }

    public boolean setFocus() {
        return this.setFocusToSelection();
    }

    protected boolean setFocus(boolean focus) {
        if (!focus) {
            return super.setFocus(focus);
        }
        if (this.dayPanel != null) {
            return this.setFocusToSelection();
        }
        return false;
    }

    private boolean setFocusToSelection() {
        if (this.dayPanel != null) {
            if (this.cdt.hasSelection()) {
                Calendar first = this.cdt.getCalendarInstance((Date)this.dayButtons[0].getData((Enum)CDT.Key.Date));
                first.set(14, 0);
                first.set(13, 0);
                first.set(12, 0);
                first.set(11, 0);
                Calendar last = this.cdt.getCalendarInstance((Date)this.dayButtons[this.dayButtons.length - 1].getData((Enum)CDT.Key.Date));
                last.set(14, 0);
                last.set(13, 0);
                last.set(12, 0);
                last.set(11, 0);
                last.add(5, 1);
                last.add(14, -1);
                Date selection = this.cdt.getSelection();
                Calendar scal = this.cdt.getCalendarInstance(selection);
                VButton[] vButtonArray = this.dayButtons;
                int n = this.dayButtons.length;
                int n2 = 0;
                while (n2 < n) {
                    VButton dayButton = vButtonArray[n2];
                    Calendar tmpcal = this.cdt.getCalendarInstance((Date)dayButton.getData((Enum)CDT.Key.Date));
                    if (scal.get(5) == tmpcal.get(5) && scal.get(2) == tmpcal.get(2) && scal.get(1) == tmpcal.get(1)) {
                        return dayButton.setFocus();
                    }
                    ++n2;
                }
            } else {
                this.dayButtons[0].setFocus();
            }
        }
        return true;
    }

    void setMonthLabelText() {
        String str = this.getFormattedDate("MMMM", this.cdt.getCalendarTime());
        GC gc = new GC((Drawable)this.getDisplay());
        int width = this.monthButton.getClientArea().width;
        if (width > 0 && gc.stringExtent((String)str).x >= width) {
            str = this.getFormattedDate("MMM", this.cdt.getCalendarTime());
        }
        gc.dispose();
        this.monthButton.setText(str);
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    private void setSelectionFromButton(VButton button, int stateMask) {
        Date date = (Date)button.getData(CDT.Key.Date.name());
        if (this.cdt.isSingleSelection()) {
            if ((stateMask & 0x40000) != 0 && this.cdt.isSelected(date)) {
                this.cdt.setSelection(null);
            } else if (button.getEnabled()) {
                this.cdt.setSelection(date);
            }
        } else {
            this.cdt.setSelection(date);
        }
        this.setFocus(true);
    }

    private void setSelectionFromFocusButton(Event event) {
        int fb = this.getFocusDayButton();
        if (fb >= 0 && fb < this.dayButtons.length) {
            VButton button = this.dayButtons[fb];
            int stateMask = event.stateMask;
            this.setSelectionFromButton(button, stateMask);
            boolean defaultSelection = false;
            if (event.type == 1 && event.stateMask == 0) {
                if (event.keyCode == 0x1000050 || event.character == '\r') {
                    defaultSelection = true;
                }
            } else if (event.type == 31 && event.stateMask == 0 && event.keyCode == 4) {
                defaultSelection = true;
            }
            this.cdt.fireSelectionChanged(defaultSelection);
        }
    }

    void traverseSelection(int keyCode) {
        int focusDayButton = this.getFocusDayButton();
        switch (keyCode) {
            case 0x1000001: {
                if (focusDayButton > 7) {
                    this.setButtonFocus(focusDayButton - 7);
                    break;
                }
                this.scrollCalendar(0x1000001);
                this.setButtonFocus(focusDayButton);
                break;
            }
            case 0x1000002: {
                if (focusDayButton < 35) {
                    this.setButtonFocus(focusDayButton + 7);
                    break;
                }
                this.scrollCalendar(0x1000002);
                break;
            }
            case 0x1000003: {
                if (focusDayButton > 0) {
                    this.setButtonFocus(focusDayButton - 1);
                    break;
                }
                this.scrollCalendar(0x1000001);
                this.setButtonFocus(focusDayButton + 7 - 1);
                break;
            }
            case 0x1000004: {
                if (focusDayButton < 41) {
                    this.setButtonFocus(focusDayButton + 1);
                    break;
                }
                this.scrollCalendar(0x1000002);
                this.setButtonFocus(focusDayButton - 6);
            }
        }
    }

    private void updateDays() {
        if (this.dayPanel != null) {
            VButton dayButton;
            Calendar date = this.cdt.getCalendarInstance();
            Calendar active = this.cdt.getCalendarInstance();
            Calendar today = this.cdt.getCalendarInstance(System.currentTimeMillis());
            VButton[] vButtonArray = this.dayButtons;
            int n = this.dayButtons.length;
            int n2 = 0;
            while (n2 < n) {
                dayButton = vButtonArray[n2];
                if (dayButton != null) {
                    date.setTime((Date)dayButton.getData((Enum)CDT.Key.Date));
                    boolean isToday = date.get(1) == today.get(1) && date.get(6) == today.get(6);
                    boolean isValid = this.isValidDate(date);
                    boolean isActive = date.get(1) == active.get(1) && date.get(2) == active.get(2) && isValid;
                    dayButton.setText(this.getFormattedDate("d", date.getTime()));
                    dayButton.setData((Enum)CDT.Key.Today, (Object)isToday);
                    dayButton.setData((Enum)CDT.Key.Active, (Object)isActive);
                    dayButton.setEnabled(isValid);
                    this.cdt.getPainter().update((VControl)dayButton);
                }
                ++n2;
            }
            vButtonArray = this.dayButtons;
            n = this.dayButtons.length;
            n2 = 0;
            while (n2 < n) {
                dayButton = vButtonArray[n2];
                dayButton.setSelection(false);
                ++n2;
            }
            if (this.cdt.hasSelection()) {
                Calendar first = this.cdt.getCalendarInstance((Date)this.dayButtons[0].getData((Enum)CDT.Key.Date));
                first.set(14, 0);
                first.set(13, 0);
                first.set(12, 0);
                first.set(11, 0);
                Calendar last = this.cdt.getCalendarInstance((Date)this.dayButtons[this.dayButtons.length - 1].getData((Enum)CDT.Key.Date));
                last.set(14, 0);
                last.set(13, 0);
                last.set(12, 0);
                last.set(11, 0);
                last.add(5, 1);
                last.add(14, -1);
                Date selection = this.cdt.getSelection();
                Calendar scal = this.cdt.getCalendarInstance(selection);
                VButton[] vButtonArray2 = this.dayButtons;
                int n3 = this.dayButtons.length;
                int n4 = 0;
                while (n4 < n3) {
                    VButton dayButton2 = vButtonArray2[n4];
                    Calendar tmpcal = this.cdt.getCalendarInstance((Date)dayButton2.getData((Enum)CDT.Key.Date));
                    if (scal.get(5) == tmpcal.get(5) && scal.get(2) == tmpcal.get(2) && scal.get(1) == tmpcal.get(1)) {
                        dayButton2.setSelection(true);
                        break;
                    }
                    ++n4;
                }
            }
            this.dayPanel.redraw();
        }
    }

    private void updateDaysOfWeek() {
        if (this.dayPanel != null) {
            Calendar tmpcal = this.cdt.getCalendarInstance();
            tmpcal.set(7, tmpcal.getFirstDayOfWeek());
            Locale locale = this.cdt.getLocale();
            boolean ltr = ComponentOrientation.getOrientation(locale).isLeftToRight() && !locale.getLanguage().equals("zh");
            BreakIterator iterator = BreakIterator.getCharacterInstance(locale);
            VLabel[] vLabelArray = this.dayLabels;
            int n = this.dayLabels.length;
            int n2 = 0;
            while (n2 < n) {
                VLabel dayLabel = vLabelArray[n2];
                String str = this.getFormattedDate("E", tmpcal.getTime());
                if (((Boolean)dayLabel.getData((Enum)CDT.Key.Compact, Boolean.class)).booleanValue()) {
                    int end;
                    int start;
                    iterator.setText(str);
                    if (ltr) {
                        start = iterator.first();
                        end = iterator.next();
                    } else {
                        end = iterator.last();
                        start = iterator.previous();
                    }
                    dayLabel.setText(str.substring(start, end));
                } else {
                    dayLabel.setText(str);
                }
                tmpcal.add(7, 1);
                ++n2;
            }
        }
    }

    private void updateFooter() {
        if (this.footer != null) {
            Locale locale = this.cdt.getLocale();
            if (this.today != null) {
                if (this.cdt.builder.hasFooter(2)) {
                    Calendar cal = this.cdt.getCalendarInstance(System.currentTimeMillis());
                    Object[] margs = new Object[]{cal.getTime(), Resources.getString("date_ordinal_" + cal.get(5), locale)};
                    MessageFormat formatter = new MessageFormat(Resources.getString("today_verbose.text", locale), locale);
                    this.today.setText(formatter.format(margs));
                } else {
                    this.today.setText(Resources.getString("today.text", locale));
                }
            }
            if (this.clear != null) {
                this.clear.setText(Resources.getString("clear.text", locale));
            }
            this.footer.layout();
        }
    }

    private void updateHeader() {
        if (this.header != null) {
            int i;
            Calendar tmpcal;
            Calendar selected = this.cdt.getCalendarInstance();
            if (this.monthButton != null) {
                this.setMonthLabelText();
            }
            if (this.monthItems != null) {
                tmpcal = this.cdt.getCalendarInstance();
                i = 0;
                while (i < 12) {
                    tmpcal.set(2, i);
                    this.monthItems[i].setText(this.getFormattedDate("MMMM", tmpcal.getTime()));
                    this.monthItems[i].setData("Month", (Object)new Integer(tmpcal.get(2)));
                    if (selected.get(2) == tmpcal.get(2)) {
                        this.monthItems[i].setImage(Resources.getIconBullet());
                    } else {
                        this.monthItems[i].setImage(null);
                    }
                    ++i;
                }
            }
            if (this.yearButton != null) {
                this.yearButton.setText(this.getFormattedDate("yyyy", this.cdt.getCalendarTime()));
            }
            if (this.yearItems != null) {
                tmpcal = this.cdt.getCalendarInstance();
                tmpcal.add(1, -5);
                i = 0;
                while (i < 11) {
                    this.yearItems[i].setText(this.getFormattedDate("yyyy", tmpcal.getTime()));
                    if (selected.get(1) == tmpcal.get(1)) {
                        this.yearItems[i].setImage(Resources.getIconBullet());
                    } else {
                        this.yearItems[i].setImage(null);
                    }
                    tmpcal.add(1, 1);
                    ++i;
                }
            }
            this.header.layout();
        }
    }

    protected void updateLabels() {
        this.updateLocale();
        if (this.dayButtons != null) {
            this.setDays(new Date(this.cdt.getCalendarTimeInMillis()), true);
            this.updateDays();
        }
        this.updateHeader();
        this.updateMonths();
        this.updateYears();
        if (this.dayLabels != null) {
            this.updateDaysOfWeek();
        }
        this.updateFooter();
    }

    private void updateLocale() {
        Locale locale = this.cdt.getLocale();
        if (this.monthPrev != null) {
            this.monthPrev.setToolTipText(Resources.getString("nav_prev_month", locale));
        }
        if (this.monthNext != null) {
            this.monthNext.setToolTipText(Resources.getString("nav_next_month", locale));
        }
        if (this.dateNow != null) {
            this.dateNow.setToolTipText(Resources.getString("nav_current_day", locale));
        }
        if (this.yearPrev != null) {
            this.yearPrev.setToolTipText(Resources.getString("nav_prev_year", locale));
        }
        if (this.yearNext != null) {
            this.yearNext.setToolTipText(Resources.getString("nav_next_year", locale));
        }
        if (this.today != null) {
            this.today.setToolTipText(Resources.getString("nav_current_day", locale));
        }
        if (this.todayMenuItem != null) {
            this.todayMenuItem.setText(Resources.getString("nav_current_day", locale));
        }
        if (this.showSelMenuItem != null) {
            this.showSelMenuItem.setText(Resources.getString("show_selection", locale));
        }
    }

    private void updateMonths() {
        if (this.monthPanel != null) {
            Calendar tmpcal = this.cdt.getCalendarInstance();
            tmpcal.set(5, 1);
            int i = 0;
            while (i < 12) {
                tmpcal.set(2, i);
                this.monthButtons[i].setText(this.getFormattedDate("MMM", tmpcal.getTime()));
                this.monthButtons[i].setData("Month", (Object)new Integer(tmpcal.get(2)));
                ++i;
            }
        }
    }

    void updateView() {
        this.updateHeader();
        if (this.dayPanel != null) {
            this.setDays(this.cdt.getCalendarTime(), true);
            this.updateDays();
        }
        this.updateMonths();
        this.updateYears();
        if (this.timePanel instanceof AnalogTimePicker) {
            ((AnalogTimePicker)this.timePanel).updateView();
        } else if (this.timePanel instanceof DiscreteTimePicker) {
            ((DiscreteTimePicker)this.timePanel).updateView();
        }
        this.updateFooter();
    }

    private void updateYears() {
        if (this.yearPanel != null) {
            Calendar tmpcal = this.cdt.getCalendarInstance();
            tmpcal.add(1, -7);
            VButton[] vButtonArray = this.yearButtons;
            int n = this.yearButtons.length;
            int n2 = 0;
            while (n2 < n) {
                VButton yearButton2 = vButtonArray[n2];
                yearButton2.setText(this.getFormattedDate("yyyy", tmpcal.getTime()));
                tmpcal.add(1, 1);
                ++n2;
            }
        }
    }

    private void setCDTSelection(Date selection) {
        Calendar calendarSelection = null;
        if (selection != null) {
            calendarSelection = this.cdt.getCalendarInstance(selection);
        }
        if (this.isValidDate(calendarSelection)) {
            this.cdt.setSelection(selection);
            this.setFocusToSelection();
            this.cdt.fireSelectionChanged();
        } else {
            this.cdt.show(selection);
        }
    }

    private boolean isValidDate(Calendar selectedDay) {
        return DatePicker.isValidDate(selectedDay, this.cdt.getMinDate(), this.cdt.getMaxDate());
    }

    static boolean isValidDate(Calendar selectedDay, Calendar min, Calendar max) {
        if (min == null && max == null || selectedDay == null) {
            return true;
        }
        boolean validMinDate = true;
        if (min != null) {
            validMinDate = selectedDay.after(min);
        }
        boolean validMaxDate = true;
        if (max != null) {
            validMaxDate = selectedDay.before(max);
        }
        return validMinDate && validMaxDate;
    }

    public void updateColorsAndFont() {
        VButton button;
        int n;
        int n2;
        VButton[] vButtonArray;
        if (this.cdt.pickerBackgroundColor != null) {
            this.picker.setBackground(this.cdt.pickerBackgroundColor);
            if (this.dayPanel != null) {
                this.dayPanel.setBackground(this.cdt.pickerBackgroundColor);
            }
            if (this.monthPanel != null) {
                this.dayPanel.setBackground(this.cdt.pickerBackgroundColor);
            }
            if (this.yearPanel != null) {
                this.dayPanel.setBackground(this.cdt.pickerBackgroundColor);
            }
        }
        if (this.cdt.pickerForegroundColor != null) {
            this.picker.setForeground(this.cdt.pickerForegroundColor);
            if (this.dayPanel != null) {
                this.dayPanel.setForeground(this.cdt.pickerForegroundColor);
            }
            if (this.monthPanel != null) {
                this.dayPanel.setForeground(this.cdt.pickerForegroundColor);
            }
            if (this.yearPanel != null) {
                this.dayPanel.setForeground(this.cdt.pickerForegroundColor);
            }
        }
        if (this.cdt.pickerFont != null) {
            this.picker.setFont(this.cdt.pickerFont);
            if (this.dayPanel != null) {
                this.dayPanel.setFont(this.cdt.pickerFont);
            }
            if (this.monthPanel != null) {
                this.dayPanel.setFont(this.cdt.pickerFont);
            }
            if (this.yearPanel != null) {
                this.dayPanel.setFont(this.cdt.pickerFont);
            }
        }
        this.cdt.getPainter().update((VControl)this.picker);
        this.cdt.getPainter().update((VControl)this.body);
        this.cdt.getPainter().update((VControl)this.dayPanel);
        this.cdt.getPainter().update((VControl)this.footer);
        this.cdt.getPainter().update((VControl)this.header);
        this.cdt.getPainter().update((VControl)this.monthPanel);
        this.cdt.getPainter().update((VControl)this.yearPanel);
        this.colorButtons(this.clear);
        this.colorButtons(this.today);
        this.colorButtons(this.dateNow);
        this.colorButtons(this.monthButton);
        this.colorButtons(this.monthNext);
        this.colorButtons(this.monthPrev);
        this.colorButtons(this.timeButton);
        this.colorButtons(this.yearButton);
        this.colorButtons(this.yearNext);
        this.colorButtons(this.yearPrev);
        if (this.dayButtons != null) {
            vButtonArray = this.dayButtons;
            n2 = this.dayButtons.length;
            n = 0;
            while (n < n2) {
                button = vButtonArray[n];
                this.colorButtons(button);
                ++n;
            }
        }
        if (this.monthButtons != null) {
            vButtonArray = this.monthButtons;
            n2 = this.monthButtons.length;
            n = 0;
            while (n < n2) {
                button = vButtonArray[n];
                this.colorButtons(button);
                ++n;
            }
        }
        if (this.yearButtons != null) {
            vButtonArray = this.yearButtons;
            n2 = this.yearButtons.length;
            n = 0;
            while (n < n2) {
                button = vButtonArray[n];
                this.colorButtons(button);
                ++n;
            }
        }
        this.updateDays();
    }
}

