/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.common;

import java.io.IOException;
import java.io.OutputStream;

public class ConsoleOutputStream
extends OutputStream {
    public static final int BUFFER_SIZE = 2048;
    public static final byte CR = 13;
    public static final byte LF = 10;
    OutputStream out;
    OutputStream oldOut;
    private boolean isEcho = true;
    private boolean queueing = false;
    private byte prevByte;
    private final byte[] buffer;
    private int pos;

    public ConsoleOutputStream(OutputStream out) {
        this.out = out;
        this.buffer = new byte[2048];
        this.pos = 0;
    }

    @Override
    public synchronized void write(int i) throws IOException {
        if (!this.queueing) {
            if (this.isEcho) {
                if (i == 13 || i == 0) {
                    this.queueing = true;
                    this.prevByte = (byte)i;
                } else if (i == 10) {
                    this.add(13);
                    this.add(10);
                } else {
                    this.add(i);
                }
            }
        } else {
            if (this.prevByte == 0 && i == 8) {
                this.isEcho = !this.isEcho;
            } else if (this.isEcho) {
                if (this.prevByte == 13 && i == 10) {
                    this.add(13);
                    this.add(10);
                } else {
                    this.add(13);
                    this.add(10);
                    this.add(i);
                }
            }
            this.queueing = false;
            this.flush();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.pos > 0) {
            try {
                this.out.write(this.buffer, 0, this.pos);
                this.out.flush();
            }
            finally {
                this.pos = 0;
            }
        }
    }

    private void add(int i) throws IOException {
        this.buffer[this.pos] = (byte)i;
        ++this.pos;
        if (this.pos == this.buffer.length) {
            this.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public void setOutput(OutputStream newOut) {
        if (newOut != null) {
            this.oldOut = this.out;
            this.out = newOut;
        } else {
            this.out = this.oldOut;
        }
    }
}

