/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.simpleconfigurator.console;

import java.io.IOException;
import java.net.URL;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ApplyCommand {
    private final URL configURL;
    private final CommandInterpreter interpreter;
    private final BundleContext context;

    public ApplyCommand(CommandInterpreter interpreter, BundleContext context, URL configURL) {
        this.interpreter = interpreter;
        this.context = context;
        this.configURL = configURL;
    }

    public void run() {
        ServiceTracker tracker = new ServiceTracker(this.context, Configurator.class.getName(), null);
        tracker.open();
        Configurator configurator = (Configurator)tracker.getService();
        if (configurator != null) {
            try {
                if (this.configURL != null) {
                    configurator.applyConfiguration(this.configURL);
                } else {
                    configurator.applyConfiguration();
                }
                if (configurator.getUrlInUse() == null) {
                    this.interpreter.println((Object)"Config URL not set.");
                }
            }
            catch (IOException e) {
                this.interpreter.println((Object)e.getMessage());
            }
        } else {
            this.interpreter.println((Object)"No configurator registered");
        }
        tracker.close();
    }
}

