/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg.keybox.jcajce;

import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.bouncycastle.gpg.keybox.BlobVerifier;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.util.Arrays;

public class JcaBlobVerifier
implements BlobVerifier {
    private final MessageDigest sha1Digest;
    private final MessageDigest md5Digest;

    JcaBlobVerifier(JcaJceHelper jcaJceHelper) throws NoSuchProviderException, NoSuchAlgorithmException {
        MessageDigest messageDigest;
        this.sha1Digest = jcaJceHelper.createMessageDigest("SHA-1");
        try {
            messageDigest = jcaJceHelper.createMessageDigest("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            messageDigest = null;
        }
        this.md5Digest = messageDigest;
    }

    @Override
    public boolean isMatched(byte[] byArray, byte[] byArray2) {
        this.sha1Digest.update(byArray, 0, byArray.length);
        byte[] byArray3 = this.sha1Digest.digest();
        if (!Arrays.constantTimeAreEqual((byte[])byArray3, (byte[])byArray2)) {
            if (byArray2[0] == 0 && byArray2[1] == 0 && byArray2[2] == 0 && byArray2[3] == 0) {
                this.md5Digest.update(byArray, 0, byArray.length);
                Arrays.fill((byte[])byArray3, (byte)0);
                try {
                    this.md5Digest.digest(byArray3, 4, this.md5Digest.getDigestLength());
                }
                catch (DigestException digestException) {
                    throw new IllegalStateException("internal buffer to small: " + digestException.getMessage(), digestException);
                }
                return Arrays.constantTimeAreEqual((byte[])byArray3, (byte[])byArray2);
            }
            return false;
        }
        return true;
    }
}

