/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.io.IOException;
import org.sat4j.AbstractLauncher;
import org.sat4j.ILauncherMode;
import org.sat4j.core.ASolverFactory;
import org.sat4j.pb.ConstraintRelaxingPseudoOptDecorator;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.SolverFactory;
import org.sat4j.pb.core.ObjectiveReducerPBSolverDecorator;
import org.sat4j.pb.reader.OPBReader2006;
import org.sat4j.pb.tools.SearchOptimizerListener;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ILogAble;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.SearchListener;
import org.sat4j.tools.SolutionFoundListener;
import org.sat4j.tools.SolverDecorator;

public class LanceurPseudo2005
extends AbstractLauncher
implements ILogAble {
    ASolverFactory<IPBSolver> factory;
    private static final long serialVersionUID = 1L;
    protected ObjectiveFunction obfct;

    public LanceurPseudo2005() {
        this(SolverFactory.instance());
    }

    LanceurPseudo2005(ASolverFactory<IPBSolver> factory) {
        this.factory = factory;
        this.setLauncherMode(ILauncherMode.OPTIMIZATION);
    }

    public static void main(String[] args) {
        LanceurPseudo2005 lanceur = new LanceurPseudo2005();
        lanceur.addHook();
        lanceur.run(args);
        System.exit(lanceur.getExitCode().value());
    }

    protected Reader createReader(ISolver theSolver, String problemname) {
        return new OPBReader2006((IPBSolver)theSolver);
    }

    protected ISolver configureSolver(String[] args) {
        String solverName = args[0];
        boolean lower = false;
        if (solverName.startsWith("Lower")) {
            lower = true;
            solverName = solverName.substring("Lower".length());
        }
        IPBSolver theSolver = args.length > 1 ? (IPBSolver)this.factory.createSolverByName(solverName) : (IPBSolver)this.factory.defaultSolver();
        if (System.getProperty("OBJREDUCER") != null) {
            theSolver = lower ? new ConstraintRelaxingPseudoOptDecorator(new ObjectiveReducerPBSolverDecorator(theSolver)) : new PseudoOptDecorator(new ObjectiveReducerPBSolverDecorator(theSolver));
        } else if (System.getProperty("INTERNAL") != null) {
            theSolver.setSearchListener((SearchListener)new SearchOptimizerListener((SolutionFoundListener)ILauncherMode.DECISION));
            this.setLauncherMode(ILauncherMode.DECISION);
        } else {
            theSolver = lower ? new ConstraintRelaxingPseudoOptDecorator(theSolver) : new PseudoOptDecorator(theSolver);
        }
        if (args.length == 3) {
            theSolver.setTimeout(Integer.valueOf(args[1]));
        }
        this.out.println(theSolver.toString("c "));
        return theSolver;
    }

    public void usage() {
        this.out.println("java -jar sat4j-pb.jar [solvername [timeout]] instancename.opb");
        this.showAvailableSolvers(SolverFactory.instance());
    }

    protected String getInstanceName(String[] args) {
        assert (args.length == 1 || args.length == 2 || args.length == 3);
        if (args.length == 0) {
            return null;
        }
        return args[args.length - 1];
    }

    protected IProblem readProblem(String problemname) throws ParseFormatException, IOException, ContradictionException {
        IProblem problem = super.readProblem(problemname);
        ObjectiveFunction obj = null;
        if (this.feedWithDecorated) {
            SolverDecorator decorator = (SolverDecorator)problem;
            obj = ((IPBSolver)decorator.decorated()).getObjectiveFunction();
        } else {
            obj = ((IPBSolver)problem).getObjectiveFunction();
        }
        if (obj != null) {
            this.out.println("c objective function length is " + obj.getVars().size() + " literals");
        }
        return problem;
    }
}

