/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.wizard;

import java.io.File;
import org.eclipse.equinox.internal.security.ui.SecurityUIMsg;
import org.eclipse.equinox.internal.security.ui.wizard.CertificateImportWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class CertificateImportFileSelectPage
extends WizardPage
implements Listener {
    private Button browseDirectoriesButton;
    private Text filePathField;

    protected CertificateImportFileSelectPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(SecurityUIMsg.WIZARD_TITLE_FILE_SELECT);
    }

    public void createControl(Composite parent) {
        Composite certSelectComposite = new Composite(parent, 0);
        this.setControl((Control)certSelectComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        certSelectComposite.setLayout((Layout)layout);
        certSelectComposite.setLayoutData((Object)new GridData(768));
        Label certSelectLabel = new Label(certSelectComposite, 16);
        certSelectLabel.setText(SecurityUIMsg.WIZARD_SELECT_FILE);
        this.filePathField = new Text(certSelectComposite, 2048);
        this.filePathField.setLayoutData((Object)new GridData(768));
        this.browseDirectoriesButton = new Button(certSelectComposite, 8);
        this.browseDirectoriesButton.setText(SecurityUIMsg.WIZARD_BROWSE);
        this.browseDirectoriesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleLocationFileButtonPressed()));
        this.addListeners();
    }

    private void addListeners() {
        this.browseDirectoriesButton.addListener(13, (Listener)this);
        this.filePathField.addListener(2, (Listener)this);
    }

    protected void handleLocationFileButtonPressed() {
        FileDialog certFileDialog = new FileDialog(this.filePathField.getShell(), 4096);
        certFileDialog.setText(SecurityUIMsg.WIZARD_SELECT_FILE);
        certFileDialog.setFilterPath(this.filePathField.getText());
        certFileDialog.setFilterExtensions(new String[]{"*.cer", "*.p7b", "*.der"});
        String selectedCert = certFileDialog.open();
        if (selectedCert != null) {
            this.filePathField.setText(selectedCert);
        }
    }

    public boolean canFlipToNextPage() {
        return this.filePathField.getText().length() >= 1 && this.getErrorMessage() == null;
    }

    public void handleEvent(Event e) {
        if (e.widget == this.browseDirectoriesButton || e.widget == this.filePathField) {
            if (this.filePathField.getText().length() < 1) {
                this.setErrorMessage(SecurityUIMsg.WIZARD_ERROR_CERT_REQUIRED);
            } else {
                this.setErrorMessage(null);
            }
        }
        this.getWizard().getContainer().updateButtons();
    }

    public IWizardPage getNextPage() {
        File file = new File(this.filePathField.getText().trim());
        if (file.isDirectory() || !file.exists()) {
            this.setErrorMessage(NLS.bind((String)SecurityUIMsg.WIZARD_FILE_NOT_FOUND, (Object)this.filePathField.getText()));
            return null;
        }
        this.saveFileSelection();
        return super.getNextPage();
    }

    private void saveFileSelection() {
        CertificateImportWizard certImportWizard = (CertificateImportWizard)this.getWizard();
        certImportWizard.selectedImportFile = this.filePathField.getText().trim();
    }
}

