/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum UnsignedPolicy implements Enumerator
{
    PROMPT(0, "PROMPT", "PROMPT"),
    ACCEPT(1, "ACCEPT", "ACCEPT"),
    DECLINE(2, "DECLINE", "DECLINE");

    public static final int PROMPT_VALUE = 0;
    public static final int ACCEPT_VALUE = 1;
    public static final int DECLINE_VALUE = 2;
    private static final UnsignedPolicy[] VALUES_ARRAY;
    public static final List<UnsignedPolicy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UnsignedPolicy[]{PROMPT, ACCEPT, DECLINE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UnsignedPolicy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnsignedPolicy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnsignedPolicy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnsignedPolicy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnsignedPolicy get(int value) {
        switch (value) {
            case 0: {
                return PROMPT;
            }
            case 1: {
                return ACCEPT;
            }
            case 2: {
                return DECLINE;
            }
        }
        return null;
    }

    private UnsignedPolicy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

