/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.internal.navigator.TextActionHandler;
import org.eclipse.ui.internal.navigator.extensions.INavigatorSiteEditor;
import org.eclipse.ui.navigator.CommonViewer;

public class NavigatorSiteEditor
implements INavigatorSiteEditor {
    private final Tree navigatorTree;
    private final TreeEditor treeEditor;
    private Text textEditor;
    private Composite textEditorParent;
    private TextActionHandler textActionHandler;
    private String text;
    private final CommonViewer commonViewer;

    public NavigatorSiteEditor(CommonViewer aCommonViewer, Tree navigatorTree) {
        this.commonViewer = aCommonViewer;
        this.navigatorTree = navigatorTree;
        this.treeEditor = new TreeEditor(navigatorTree);
    }

    Composite createParent() {
        Composite result = new Composite((Composite)this.navigatorTree, 0);
        TreeItem[] selectedItems = this.navigatorTree.getSelection();
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.setEditor((Control)result, selectedItems[0]);
        return result;
    }

    void createTextEditor(final Runnable runnable) {
        this.textEditorParent = this.createParent();
        this.textEditorParent.setVisible(false);
        this.textEditorParent.addListener(9, e -> {
            Point textSize = this.textEditor.getSize();
            Point parentSize = this.textEditorParent.getSize();
            e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
        });
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addListener(24, e -> {
            Point textSize = this.textEditor.computeSize(-1, -1);
            textSize.x += textSize.y;
            Point parentSize = this.textEditorParent.getSize();
            this.textEditor.setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
            this.textEditorParent.redraw();
        });
        this.textEditor.addListener(31, event -> {
            switch (event.detail) {
                case 2: {
                    this.disposeTextWidget();
                    event.doit = true;
                    event.detail = 0;
                    break;
                }
                case 4: {
                    this.saveChangesAndDispose(runnable);
                    event.doit = true;
                    event.detail = 0;
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                NavigatorSiteEditor.this.saveChangesAndDispose(runnable);
            }
        });
        if (this.textActionHandler != null) {
            this.textActionHandler.addText(this.textEditor);
        }
    }

    void disposeTextWidget() {
        if (this.textActionHandler != null) {
            this.textActionHandler.removeText(this.textEditor);
        }
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            this.treeEditor.setEditor(null, null);
        }
    }

    @Override
    public void edit(Runnable runnable) {
        ITreeSelection selection = this.commonViewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        this.text = this.getLabel(selection.getFirstElement());
        if (this.text == null) {
            return;
        }
        if (this.textEditorParent == null) {
            this.createTextEditor(runnable);
        }
        this.textEditor.setText(this.text);
        this.textEditorParent.setVisible(true);
        Point textSize = this.textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.textEditorParent.getSize();
        this.textEditor.setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
        this.textEditorParent.redraw();
        this.textEditor.selectAll();
        this.textEditor.setFocus();
    }

    String getLabel(Object element) {
        return ((ILabelProvider)this.commonViewer.getLabelProvider()).getText(element);
    }

    @Override
    public String getText() {
        return this.text;
    }

    void saveChangesAndDispose(Runnable runnable) {
        String newText = this.textEditor.getText();
        Runnable editRunnable = () -> {
            this.disposeTextWidget();
            if (newText.length() > 0 && !newText.equals(this.text)) {
                this.text = newText;
                runnable.run();
            }
            this.text = null;
        };
        this.navigatorTree.getShell().getDisplay().asyncExec(editRunnable);
    }

    @Override
    public void setTextActionHandler(TextActionHandler actionHandler) {
        this.textActionHandler = actionHandler;
    }
}

