/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.internal.DefaultSaveable;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class SaveablesList
implements ISaveablesLifecycleListener {
    private final ListenerList<ISaveablesLifecycleListener> listeners = new ListenerList();
    private final Map<Object, Set<Saveable>> modelMap = new LinkedHashMap<Object, Set<Saveable>>();
    private final Map<Saveable, Integer> modelRefCounts = new LinkedHashMap<Saveable, Integer>();
    private final Map<Saveable, List<Saveable>> equalKeys = new IdentityHashMap<Saveable, List<Saveable>>();
    private final Set<ISaveablesSource> nonPartSources = new HashSet<ISaveablesSource>();

    public Saveable[] getOpenModels() {
        HashSet allDistinctModels = new HashSet();
        Iterator<Set<Saveable>> saveables = this.modelMap.values().iterator();
        while (saveables.hasNext()) {
            allDistinctModels.addAll(saveables.next());
        }
        return allDistinctModels.toArray(new Saveable[allDistinctModels.size()]);
    }

    private boolean addModel(Object source, Saveable model) {
        if (model == null) {
            this.logWarning("Ignored attempt to add invalid saveable", source, model);
            return false;
        }
        boolean result = false;
        Set<Saveable> modelsForSource = this.modelMap.get(source);
        if (modelsForSource == null) {
            modelsForSource = new HashSet<Saveable>();
            this.modelMap.put(source, modelsForSource);
        }
        if (modelsForSource.add(model)) {
            result = this.incrementRefCount(this.modelRefCounts, model);
        } else {
            this.logWarning("Ignored attempt to add saveable that was already registered", source, model);
        }
        return result;
    }

    private boolean incrementRefCount(Map<Saveable, Integer> referenceMap, Saveable key) {
        boolean result = false;
        Integer refCount = referenceMap.get(key);
        if (refCount == null) {
            result = true;
            refCount = 0;
        }
        if (referenceMap == this.modelRefCounts) {
            if (result) {
                this.rememberRefKey(key);
            } else {
                this.incrementRefKeys(key);
            }
        }
        referenceMap.put(key, refCount + 1);
        return result;
    }

    private void rememberRefKey(Saveable key) {
        ArrayList<Saveable> equals = new ArrayList<Saveable>();
        equals.add(key);
        this.equalKeys.put(key, equals);
    }

    private void incrementRefKeys(Saveable key) {
        Saveable keyUsedInCountMap = this.findExistingRefKey(key);
        if (keyUsedInCountMap == null) {
            this.rememberRefKey(key);
            return;
        }
        List<Saveable> equals = this.equalKeys.get(keyUsedInCountMap);
        equals.add(key);
        this.equalKeys.put(key, equals);
    }

    private boolean decrementRefCount(Saveable key) {
        int refCountValue;
        boolean result = false;
        Integer refCount = this.modelRefCounts.get(key);
        Saveable keyToDecrement = key;
        if (refCount == null && keyToDecrement != (key = this.fixKeyIfKnown(key))) {
            refCount = this.modelRefCounts.get(key);
        }
        if (refCount == null) {
            Assert.isTrue((boolean)false, (String)(String.valueOf(keyToDecrement) + ": " + keyToDecrement.getName()));
        }
        if ((refCountValue = refCount.intValue()) == 1) {
            this.modelRefCounts.remove(key);
            result = true;
            this.forgetRefKeys(key);
        } else {
            Saveable keyUsedInCountMap;
            Collection equals = this.equalKeys.get(keyToDecrement);
            long instanceCount = this.count(keyToDecrement, equals);
            if (instanceCount == 1L) {
                this.forgetRefKeys(keyToDecrement);
                keyUsedInCountMap = (Saveable)equals.iterator().next();
            } else {
                this.decrementRefKeys(keyToDecrement);
                keyUsedInCountMap = key;
            }
            this.modelRefCounts.remove(keyToDecrement);
            this.modelRefCounts.put(keyUsedInCountMap, refCountValue - 1);
        }
        return result;
    }

    private long count(Saveable keyToDecrement, Collection<Saveable> equals) {
        return equals.stream().filter(x -> x == keyToDecrement).count();
    }

    private Saveable fixKeyIfKnown(Saveable key) {
        Collection keys = this.equalKeys.get(key);
        if (keys == null) {
            return key;
        }
        Saveable goodKey = null;
        for (Saveable saveable : keys) {
            Integer refCount = this.modelRefCounts.get(saveable);
            if (refCount == null) continue;
            goodKey = saveable;
            break;
        }
        if (goodKey == null) {
            return key;
        }
        return goodKey;
    }

    private void forgetRefKeys(Saveable key) {
        Collection keys = this.equalKeys.get(key);
        if (keys != null) {
            this.equalKeys.remove(key);
            keys.removeIf(x -> x == key);
        }
    }

    private void decrementRefKeys(Saveable key) {
        List<Saveable> keys = this.equalKeys.get(key);
        if (keys != null) {
            int i = 0;
            while (i < keys.size()) {
                if (keys.get(i) == key) {
                    keys.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    private Saveable findExistingRefKey(Saveable key) {
        Saveable existingKey = null;
        Set<Saveable> keys = this.modelRefCounts.keySet();
        for (Saveable s : keys) {
            if (!s.equals(key)) continue;
            existingKey = s;
            break;
        }
        return existingKey;
    }

    private boolean removeModel(Object source, Saveable model) {
        boolean result = false;
        Set<Saveable> modelsForSource = this.modelMap.get(source);
        if (modelsForSource == null) {
            this.logWarning("Ignored attempt to remove a saveable when no saveables were known", source, model);
        } else if (modelsForSource.remove(model)) {
            result = this.decrementRefCount(model);
            if (modelsForSource.isEmpty()) {
                this.modelMap.remove(source);
            }
        } else {
            this.logWarning("Ignored attempt to remove a saveable that was not registered", source, model);
        }
        return result;
    }

    private void logWarning(String message, Object source, Saveable model) {
        IllegalStateException e = new IllegalStateException("unknown saveable: " + String.valueOf(model) + " from part: " + String.valueOf(source));
        WorkbenchPlugin.log((IStatus)Status.warning((String)message, (Throwable)e));
    }

    @Override
    public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
        if (!(event.getSource() instanceof IWorkbenchPart)) {
            this.updateNonPartSource((ISaveablesSource)event.getSource());
            return;
        }
        Saveable[] modelArray = event.getSaveables();
        switch (event.getEventType()) {
            case 1: {
                this.addModels(event.getSource(), modelArray);
                break;
            }
            case 2: {
                Saveable[] models = event.getSaveables();
                HashMap<Saveable, Integer> modelsDecrementing = new HashMap<Saveable, Integer>();
                HashSet<Saveable> modelsClosing = new HashSet<Saveable>();
                Saveable[] saveableArray = models;
                int n = models.length;
                int n2 = 0;
                while (n2 < n) {
                    Saveable model = saveableArray[n2];
                    this.incrementRefCount(modelsDecrementing, model);
                    ++n2;
                }
                this.fillModelsClosing(modelsClosing, modelsDecrementing);
                boolean canceled = this.promptForSavingIfNecessary(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), modelsClosing, modelsDecrementing, !event.isForce());
                if (!canceled) break;
                event.setVeto(true);
                break;
            }
            case 3: {
                this.removeModels(event.getSource(), modelArray);
                break;
            }
            case 4: {
                this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, event.getEventType(), event.getSaveables(), false));
            }
        }
    }

    private void updateNonPartSource(ISaveablesSource source) {
        Saveable[] saveables = source.getSaveables();
        if (saveables.length == 0) {
            this.nonPartSources.remove(source);
        } else {
            this.nonPartSources.add(source);
        }
    }

    private void removeModels(Object source, Saveable[] modelArray) {
        ArrayList<Saveable> removed = new ArrayList<Saveable>();
        Saveable[] saveableArray = modelArray;
        int n = modelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Saveable model = saveableArray[n2];
            if (this.removeModel(source, model)) {
                removed.add(model);
            }
            ++n2;
        }
        if (removed.size() > 0) {
            this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, 1, removed.toArray(new Saveable[removed.size()]), false));
        }
    }

    private void addModels(Object source, Saveable[] modelArray) {
        ArrayList<Saveable> added = new ArrayList<Saveable>();
        Saveable[] saveableArray = modelArray;
        int n = modelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Saveable model = saveableArray[n2];
            if (this.addModel(source, model)) {
                added.add(model);
            }
            ++n2;
        }
        if (added.size() > 0) {
            this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, 1, added.toArray(new Saveable[added.size()]), false));
        }
    }

    private void fireModelLifecycleEvent(SaveablesLifecycleEvent event) {
        for (ISaveablesLifecycleListener listener : this.listeners) {
            listener.handleLifecycleEvent(event);
        }
    }

    public void addModelLifecycleListener(ISaveablesLifecycleListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeModelLifecycleListener(ISaveablesLifecycleListener listener) {
        this.listeners.remove((Object)listener);
    }

    public Object preCloseParts(List<IWorkbenchPart> partsToClose, boolean addNonPartSources, boolean save, IWorkbenchWindow window, Map<Saveable, ISaveHandler.Save> saveOptions) {
        if (saveOptions == null || saveOptions.isEmpty()) {
            this.preCloseParts(partsToClose, save, window);
        }
        Collection<ISaveHandler.Save> saveValues = saveOptions.values();
        for (ISaveHandler.Save decision : saveValues) {
            if (decision != ISaveHandler.Save.CANCEL) continue;
            return false;
        }
        return this.preCloseParts(partsToClose, addNonPartSources, save, window, window, saveOptions);
    }

    public Object preCloseParts(List<IWorkbenchPart> partsToClose, boolean save, IWorkbenchWindow window) {
        return this.preCloseParts(partsToClose, save, window, window);
    }

    public Object preCloseParts(List<IWorkbenchPart> partsToClose, boolean save, IShellProvider shellProvider, IWorkbenchWindow window) {
        return this.preCloseParts(partsToClose, false, save, shellProvider, window);
    }

    public Object preCloseParts(List<IWorkbenchPart> partsToClose, boolean addNonPartSources, boolean save, IShellProvider shellProvider, IWorkbenchWindow window) {
        return this.preCloseParts(partsToClose, addNonPartSources, save, shellProvider, window, null);
    }

    private Object preCloseParts(List<IWorkbenchPart> partsToClose, boolean addNonPartSources, boolean save, IShellProvider shellProvider, IWorkbenchWindow window, Map<Saveable, ISaveHandler.Save> saveOptions) {
        boolean canceled;
        int n;
        PostCloseInfo postCloseInfo = new PostCloseInfo();
        for (IWorkbenchPart part : partsToClose) {
            postCloseInfo.partsClosing.add(part);
            ISaveablePart saveable = SaveableHelper.getSaveable(part);
            if (saveable != null && save && !saveable.isSaveOnCloseNeeded()) continue;
            Saveable[] saveables = this.getSaveables(part);
            if (save && saveable instanceof ISaveablePart2) {
                ISaveablePart2 saveablePart2 = (ISaveablePart2)saveable;
                boolean confirm = true;
                int response = -2;
                if (saveOptions != null) {
                    Saveable[] saveableArray = saveables;
                    int n2 = saveables.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Saveable saveableKey = saveableArray[n3];
                        ISaveHandler.Save saveVal = saveOptions.get(saveableKey);
                        if (saveVal == ISaveHandler.Save.NO) {
                            confirm = true;
                            break;
                        }
                        if (saveVal == ISaveHandler.Save.CANCEL) {
                            response = 2;
                            break;
                        }
                        confirm = false;
                        ++n3;
                    }
                }
                if (response == -2) {
                    response = SaveableHelper.savePart(saveablePart2, window, confirm);
                }
                if (response == 2) {
                    return null;
                }
                if (response != 3) continue;
            }
            Saveable[] saveableArray = saveables;
            int n4 = saveables.length;
            n = 0;
            while (n < n4) {
                Saveable saveableModel = saveableArray[n];
                this.incrementRefCount(postCloseInfo.modelsDecrementing, saveableModel);
                ++n;
            }
        }
        this.fillModelsClosing(postCloseInfo.modelsClosing, postCloseInfo.modelsDecrementing);
        if (addNonPartSources) {
            ISaveablesSource[] iSaveablesSourceArray = this.getNonPartSources();
            int n5 = iSaveablesSourceArray.length;
            int n6 = 0;
            while (n6 < n5) {
                Saveable[] saveables;
                ISaveablesSource nonPartSource = iSaveablesSourceArray[n6];
                Saveable[] saveableArray = saveables = nonPartSource.getSaveables();
                int n7 = saveables.length;
                n = 0;
                while (n < n7) {
                    Saveable saveable = saveableArray[n];
                    if (saveable.isDirty()) {
                        postCloseInfo.modelsClosing.add(saveable);
                    }
                    ++n;
                }
                ++n6;
            }
        }
        if (save && (canceled = this.promptForSavingIfNecessary(shellProvider, window, postCloseInfo.modelsClosing, postCloseInfo.modelsDecrementing, true, saveOptions))) {
            return null;
        }
        return postCloseInfo;
    }

    public Map<IWorkbenchPart, List<Saveable>> getSaveables(List<IWorkbenchPart> parts) {
        HashMap<IWorkbenchPart, List<Saveable>> saveablesMap = null;
        if (parts != null && parts.size() > 0) {
            saveablesMap = new HashMap<IWorkbenchPart, List<Saveable>>();
            for (IWorkbenchPart part : parts) {
                Saveable[] saveables = this.getSaveables(part);
                if (saveables == null || saveables.length <= 0) continue;
                saveablesMap.put(part, Arrays.asList(saveables));
            }
        }
        return saveablesMap;
    }

    private boolean promptForSavingIfNecessary(IWorkbenchWindow window, Set<Saveable> modelsClosing, Map<Saveable, Integer> modelsDecrementing, boolean canCancel) {
        return this.promptForSavingIfNecessary(window, window, modelsClosing, modelsDecrementing, canCancel, null);
    }

    private boolean promptForSavingIfNecessary(IShellProvider shellProvider, IWorkbenchWindow window, Set<Saveable> modelsClosing, Map<Saveable, Integer> modelsDecrementing, boolean canCancel, Map<Saveable, ISaveHandler.Save> saveOptionMap) {
        boolean shouldCancel;
        ArrayList<Saveable> modelsToOptionallySave = new ArrayList<Saveable>();
        for (Saveable modelDecrementing : modelsDecrementing.keySet()) {
            if (!modelDecrementing.isDirty() || modelsClosing.contains(modelDecrementing)) continue;
            modelsToOptionallySave.add(modelDecrementing);
        }
        boolean bl = shouldCancel = modelsToOptionallySave.isEmpty() ? false : this.promptForSaving(modelsToOptionallySave, shellProvider, window, canCancel, true, saveOptionMap);
        if (shouldCancel) {
            return true;
        }
        ArrayList<Saveable> modelsToSave = new ArrayList<Saveable>();
        for (Saveable modelClosing : modelsClosing) {
            if (!modelClosing.isDirty()) continue;
            modelsToSave.add(modelClosing);
        }
        return modelsToSave.isEmpty() ? false : this.promptForSaving(modelsToSave, shellProvider, window, canCancel, false, saveOptionMap);
    }

    private void fillModelsClosing(Set<Saveable> modelsClosing, Map<Saveable, Integer> modelsDecrementing) {
        for (Map.Entry<Saveable, Integer> entry : modelsDecrementing.entrySet()) {
            Saveable model = entry.getKey();
            if (!entry.getValue().equals(this.modelRefCounts.get(model))) continue;
            modelsClosing.add(model);
        }
    }

    private boolean promptForSaving(List<Saveable> modelsToSave, IShellProvider shellProvider, IRunnableContext runnableContext, boolean canCancel, boolean stillOpenElsewhere, Map<Saveable, ISaveHandler.Save> saveOptionMap) {
        ArrayList<Saveable> tobeSaved = new ArrayList<Saveable>();
        if (saveOptionMap == null || saveOptionMap.isEmpty()) {
            return this.promptForSaving(modelsToSave, shellProvider, runnableContext, canCancel, stillOpenElsewhere);
        }
        if (modelsToSave.size() > 0) {
            for (Saveable saveable : modelsToSave) {
                ISaveHandler.Save option = saveOptionMap.get(saveable);
                if (option == null || option != ISaveHandler.Save.YES) continue;
                tobeSaved.add(saveable);
            }
        }
        return this.saveModels(tobeSaved, shellProvider, runnableContext);
    }

    public boolean promptForSaving(List<Saveable> modelsToSave, IShellProvider shellProvider, IRunnableContext runnableContext, final boolean canCancel, boolean stillOpenElsewhere) {
        block23: {
            IPreferenceStore apiPreferenceStore;
            block24: {
                Object dialog;
                boolean dontPrompt;
                if (modelsToSave.size() <= 0) break block23;
                boolean canceled = SaveableHelper.waitForBackgroundSaveJobs(modelsToSave);
                if (canceled) {
                    return true;
                }
                apiPreferenceStore = PrefUtil.getAPIPreferenceStore();
                boolean bl = dontPrompt = stillOpenElsewhere && !apiPreferenceStore.getBoolean("PROMPT_WHEN_SAVEABLE_STILL_OPEN");
                if (dontPrompt) {
                    modelsToSave.clear();
                    return false;
                }
                if (modelsToSave.size() != 1) break block24;
                Saveable model = modelsToSave.get(0);
                int choice = 1;
                if (stillOpenElsewhere) {
                    LinkedHashMap<String, Integer> buttonLabelToIdMap = new LinkedHashMap<String, Integer>();
                    buttonLabelToIdMap.put(WorkbenchMessages.SaveableHelper_Save, 0);
                    buttonLabelToIdMap.put(WorkbenchMessages.SaveableHelper_Dont_Save, 3);
                    if (canCancel) {
                        buttonLabelToIdMap.put(WorkbenchMessages.SaveableHelper_Cancel, 1);
                    }
                    String message = NLS.bind((String)WorkbenchMessages.EditorManager_saveChangesOptionallyQuestion, (Object)model.getName());
                    MessageDialogWithToggle dialogWithToggle = new MessageDialogWithToggle(shellProvider.getShell(), WorkbenchMessages.Save_Resource, null, message, 0, buttonLabelToIdMap, 0, WorkbenchMessages.EditorManager_closeWithoutPromptingOption, false){

                        protected int getShellStyle() {
                            return (canCancel ? 64 : 0) | 0x20 | 0x800 | 0x10000 | 0x10000000 | 1.getDefaultOrientation();
                        }
                    };
                    dialog = dialogWithToggle;
                } else {
                    String[] buttons = canCancel ? new String[]{WorkbenchMessages.SaveableHelper_Save, WorkbenchMessages.SaveableHelper_Dont_Save, WorkbenchMessages.SaveableHelper_Cancel} : new String[]{WorkbenchMessages.SaveableHelper_Save, WorkbenchMessages.SaveableHelper_Dont_Save};
                    String message = NLS.bind((String)WorkbenchMessages.EditorManager_saveChangesQuestion, (Object)model.getName());
                    dialog = new MessageDialog(shellProvider.getShell(), WorkbenchMessages.Save_Resource, null, message, 0, 0, buttons){

                        protected int getShellStyle() {
                            return (canCancel ? 64 : 0) | 0x20 | 0x800 | 0x10000 | 0x10000000 | 2.getDefaultOrientation();
                        }
                    };
                }
                choice = SaveableHelper.testGetAutomatedResponse();
                if (SaveableHelper.testGetAutomatedResponse() == -1) {
                    choice = dialog.open();
                    if (stillOpenElsewhere) {
                        switch (choice) {
                            case 2: {
                                choice = 0;
                                break;
                            }
                            case 3: {
                                choice = 1;
                                break;
                            }
                            case 1: {
                                choice = 2;
                                break;
                            }
                        }
                        MessageDialogWithToggle dialogWithToggle = (MessageDialogWithToggle)dialog;
                        if (choice != 2 && dialogWithToggle.getToggleState()) {
                            apiPreferenceStore.setValue("PROMPT_WHEN_SAVEABLE_STILL_OPEN", false);
                        }
                    }
                }
                switch (choice) {
                    case 0: {
                        break block23;
                    }
                    case 1: {
                        modelsToSave.clear();
                        break block23;
                    }
                    default: {
                        return true;
                    }
                }
            }
            if (!modelsToSave.isEmpty()) {
                ListSelectionDialog dlg = ListSelectionDialog.of(modelsToSave).labelProvider((ILabelProvider)new WorkbenchPartLabelProvider()).preselect(modelsToSave.toArray()).title(WorkbenchMessages.EditorManager_saveResourcesTitle).message(stillOpenElsewhere ? WorkbenchMessages.EditorManager_saveResourcesOptionallyMessage : WorkbenchMessages.EditorManager_saveResourcesMessage).okButtonText(WorkbenchMessages.SaveableHelper_Save_n_of_m).okButtonTextWhenNoSelection(WorkbenchMessages.SaveableHelper_Save_0_of_m).canCancel(canCancel).asSheet(true).checkboxText(stillOpenElsewhere ? WorkbenchMessages.EditorManager_closeWithoutPromptingOption : null).create(shellProvider.getShell());
                if (SaveableHelper.testGetAutomatedResponse() == -1) {
                    Object[] objects;
                    int result = dlg.open();
                    if (result == 1) {
                        return true;
                    }
                    if (dlg.getCheckboxValue()) {
                        apiPreferenceStore.setValue("PROMPT_WHEN_SAVEABLE_STILL_OPEN", false);
                    }
                    modelsToSave = new ArrayList<Saveable>();
                    Object[] objectArray = objects = dlg.getResult();
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (object instanceof Saveable) {
                            modelsToSave.add((Saveable)object);
                        }
                        ++n2;
                    }
                }
            }
        }
        return this.saveModels(modelsToSave, shellProvider, runnableContext);
    }

    public boolean saveModels(List<Saveable> finalModels, IShellProvider shellProvider, IRunnableContext runnableContext) {
        return this.saveModels(finalModels, shellProvider, runnableContext, true);
    }

    public boolean saveModels(List<Saveable> finalModels, IShellProvider shellProvider, IRunnableContext runnableContext, boolean blockUntilSaved) {
        IRunnableWithProgress progressOp = monitor -> {
            EventLoopProgressMonitor monitorWrap = new EventLoopProgressMonitor(monitor);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitorWrap, (String)WorkbenchMessages.Saving_Modifications, (int)finalModels.size());
            for (Saveable model : finalModels) {
                if (!model.isDirty()) {
                    subMonitor.worked(1);
                    continue;
                }
                SaveableHelper.doSaveModel(model, (IProgressMonitor)subMonitor.split(1), shellProvider, blockUntilSaved);
                if (subMonitor.isCanceled()) break;
            }
            monitorWrap.done();
        };
        return !SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.Save_All, progressOp, runnableContext);
    }

    public void postClose(Object postCloseInfoObject) {
        PostCloseInfo postCloseInfo = (PostCloseInfo)postCloseInfoObject;
        ArrayList<Saveable> removed = new ArrayList<Saveable>();
        for (IWorkbenchPart part : postCloseInfo.partsClosing) {
            Set<Saveable> saveables = this.modelMap.get(part);
            if (saveables == null) continue;
            saveables = new HashSet<Saveable>(saveables);
            for (Saveable saveable : saveables) {
                if (!this.removeModel(part, saveable)) continue;
                removed.add(saveable);
            }
        }
        if (removed.size() > 0) {
            this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, 3, removed.toArray(new Saveable[removed.size()]), false));
        }
    }

    private Saveable[] getSaveables(IWorkbenchPart part) {
        if (part instanceof ISaveablesSource) {
            ISaveablesSource source = (ISaveablesSource)((Object)part);
            return source.getSaveables();
        }
        if (SaveableHelper.isSaveable(part)) {
            return new Saveable[]{new DefaultSaveable(part)};
        }
        return new Saveable[0];
    }

    public void postOpen(IWorkbenchPart part) {
        this.addModels(part, this.getSaveables(part));
    }

    public void dirtyChanged(IWorkbenchPart part) {
        Saveable[] saveables = this.getSaveables(part);
        if (saveables.length > 0) {
            this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, 4, saveables, false));
        }
    }

    public Object[] testGetSourcesForModel(Saveable model) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<Object, Set<Saveable>> entry : this.modelMap.entrySet()) {
            Set<Saveable> values = entry.getValue();
            if (!values.contains(model)) continue;
            result.add(entry.getKey());
        }
        return result.toArray();
    }

    public ISaveablesSource[] getNonPartSources() {
        return this.nonPartSources.toArray(new ISaveablesSource[this.nonPartSources.size()]);
    }

    public IWorkbenchPart[] getPartsForSaveable(Saveable model) {
        ArrayList<IWorkbenchPart> result = new ArrayList<IWorkbenchPart>();
        for (Map.Entry<Object, Set<Saveable>> entry : this.modelMap.entrySet()) {
            Set<Saveable> values = entry.getValue();
            if (!values.contains(model) || !(entry.getKey() instanceof IWorkbenchPart)) continue;
            result.add((IWorkbenchPart)entry.getKey());
        }
        return result.toArray(new IWorkbenchPart[result.size()]);
    }

    protected Map<Saveable, Integer> getModelRefCounts() {
        return this.modelRefCounts;
    }

    protected Map<Object, Set<Saveable>> getModelMap() {
        return this.modelMap;
    }

    protected Map<Saveable, List<Saveable>> getEqualKeys() {
        return this.equalKeys;
    }

    private static class PostCloseInfo {
        private final List<IWorkbenchPart> partsClosing = new ArrayList<IWorkbenchPart>();
        private final Map<Saveable, Integer> modelsDecrementing = new HashMap<Saveable, Integer>();
        private final Set<Saveable> modelsClosing = new HashSet<Saveable>();

        private PostCloseInfo() {
        }
    }
}

