/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ColorSelector
extends EventManager {
    public static final String PROP_COLORCHANGE = "colorValue";
    private final Button fButton;
    private RGB fColorValue;
    private final Point fExtent;
    private Image fImage;

    public ColorSelector(Composite parent) {
        this.fButton = new Button(parent, 8);
        this.fExtent = this.computeImageSize((Control)parent);
        this.updateColorImage();
        this.fButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.open()));
        this.fButton.addDisposeListener(event -> {
            if (this.fImage != null) {
                this.fImage.dispose();
                this.fImage = null;
            }
        });
        this.fButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = JFaceResources.getString("ColorSelector.Name");
            }
        });
    }

    public void addListener(IPropertyChangeListener listener) {
        this.addListenerObject(listener);
    }

    private Point computeImageSize(Control window) {
        GC gc = new GC((Drawable)window);
        Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont");
        gc.setFont(f);
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        return new Point(height * 3 - 6, height);
    }

    public Button getButton() {
        return this.fButton;
    }

    public RGB getColorValue() {
        return this.fColorValue;
    }

    public void removeListener(IPropertyChangeListener listener) {
        this.removeListenerObject(listener);
    }

    public void setColorValue(RGB rgb) {
        this.fColorValue = rgb;
        this.updateColorImage();
    }

    public void setEnabled(boolean state) {
        this.getButton().setEnabled(state);
    }

    protected void updateColorImage() {
        if (this.fImage != null) {
            this.fImage.dispose();
        }
        Display display = this.fButton.getDisplay();
        this.fImage = new Image((Device)display, this::getImageData);
        this.fButton.setImage(this.fImage);
    }

    private ImageData getImageData(int zoom) {
        Display display = this.fButton.getDisplay();
        Image image = new Image((Device)display, this.fExtent.x, this.fExtent.y);
        GC gc = new GC((Drawable)image);
        RGB color = this.getColorValue();
        gc.setForeground(display.getSystemColor(23));
        if (color != null) {
            gc.setBackground(new Color((Device)display, color));
            gc.fillRectangle(image.getBounds());
        }
        gc.setLineWidth(2);
        gc.drawRectangle(image.getBounds());
        gc.dispose();
        ImageData data = image.getImageData(zoom);
        image.dispose();
        return data;
    }

    public void open() {
        ColorDialog colorDialog = new ColorDialog(this.fButton.getShell());
        colorDialog.setRGB(this.fColorValue);
        RGB newColor = colorDialog.open();
        if (newColor != null) {
            RGB oldValue = this.fColorValue;
            this.fColorValue = newColor;
            Object[] finalListeners = this.getListeners();
            if (finalListeners.length > 0) {
                PropertyChangeEvent pEvent = new PropertyChangeEvent((Object)this, PROP_COLORCHANGE, oldValue, newColor);
                Object[] objectArray = finalListeners;
                int n = finalListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object finalListener = objectArray[n2];
                    IPropertyChangeListener listener = (IPropertyChangeListener)finalListener;
                    listener.propertyChange(pEvent);
                    ++n2;
                }
            }
            this.updateColorImage();
        }
    }
}

