/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.preferences;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.preferences.PreferenceTransferElement;
import org.eclipse.ui.internal.wizards.preferences.PreferencesMessages;
import org.eclipse.ui.internal.wizards.preferences.WizardPreferencesPage;

public class WizardPreferencesExportPage1
extends WizardPreferencesPage {
    private static final String PREFERENCESEXPORTPAGE1 = "preferencesExportPage1";

    protected WizardPreferencesExportPage1(String name) {
        super(name);
        this.setTitle(PreferencesMessages.WizardPreferencesExportPage1_exportTitle);
        this.setDescription(PreferencesMessages.WizardPreferencesExportPage1_exportDescription);
    }

    public WizardPreferencesExportPage1() {
        this(PREFERENCESEXPORTPAGE1);
    }

    @Override
    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.setHelp(composite, "org.eclipse.ui.preferences_export_wizard_page");
    }

    protected String getOutputSuffix() {
        return ".epf";
    }

    @Override
    protected String getDestinationValue() {
        String idealSuffix = this.getOutputSuffix();
        Object destinationText = super.getDestinationValue();
        if (((String)destinationText).length() != 0 && !((String)destinationText).endsWith(File.separator)) {
            int dotIndex = ((String)destinationText).lastIndexOf(46);
            if (dotIndex != -1) {
                int pathSepIndex = ((String)destinationText).lastIndexOf(File.separator);
                if (pathSepIndex != -1 && dotIndex < pathSepIndex) {
                    destinationText = (String)destinationText + idealSuffix;
                }
            } else {
                destinationText = (String)destinationText + idealSuffix;
            }
        }
        return destinationText;
    }

    @Override
    protected String getAllButtonText() {
        return PreferencesMessages.WizardPreferencesExportPage1_all;
    }

    @Override
    protected String getChooseButtonText() {
        return PreferencesMessages.WizardPreferencesExportPage1_choose;
    }

    @Override
    protected void createTransferArea(Composite composite) {
        this.createTransfersList(composite);
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
    }

    @Override
    protected String getDestinationLabel() {
        return PreferencesMessages.WizardPreferencesExportPage1_file;
    }

    @Override
    protected PreferenceTransferElement[] getTransfers() {
        PreferenceTransferElement[] elements = super.getTransfers();
        PreferenceTransferElement[] returnElements = new PreferenceTransferElement[elements.length];
        IPreferenceFilter[] filters = new IPreferenceFilter[1];
        IPreferencesService service = Platform.getPreferencesService();
        int count = 0;
        try {
            PreferenceTransferElement[] preferenceTransferElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                PreferenceTransferElement element = preferenceTransferElementArray[n2];
                filters[0] = element.getFilter();
                IPreferenceFilter[] matches = service.matches((IEclipsePreferences)service.getRootNode().node("instance"), filters);
                if (matches.length > 0) {
                    returnElements[count++] = element;
                }
                ++n2;
            }
            elements = new PreferenceTransferElement[count];
            System.arraycopy(returnElements, 0, elements, 0, count);
        }
        catch (CoreException e) {
            WorkbenchPlugin.log(e.getMessage(), e);
            return new PreferenceTransferElement[0];
        }
        return elements;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean transfer(IPreferenceFilter[] transfers) {
        File exportFile = new File(this.getDestinationValue());
        if (!this.ensureTargetIsValid(exportFile)) {
            return false;
        }
        if (transfers.length <= 0) return true;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream fos = new FileOutputStream(exportFile);){
                IPreferencesService service = Platform.getPreferencesService();
                try {
                    service.exportPreferences(service.getRootNode(), transfers, (OutputStream)fos);
                    return true;
                }
                catch (CoreException e) {
                    this.reportException((Exception)((Object)e));
                    if (fos == null) return false;
                    fos.close();
                    return false;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            this.reportException(e);
            return false;
        }
    }

    @Override
    protected String getFileDialogTitle() {
        return PreferencesMessages.WizardPreferencesExportPage1_title;
    }

    @Override
    protected int getFileDialogStyle() {
        return 0x10002000;
    }

    @Override
    protected String getInvalidDestinationMessage() {
        return PreferencesMessages.WizardPreferencesExportPage1_noPrefFile;
    }

    @Override
    protected boolean shouldSaveTransferAll() {
        return true;
    }

    private void reportException(Exception e) {
        Shell shell = this.getControl().getShell();
        WorkbenchPlugin.log(e.getMessage(), e);
        MessageDialog.open((int)1, (Shell)shell, (String)"", (String)e.getLocalizedMessage(), (int)0x10000000);
    }
}

