/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.hc.remote.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.io.KeyKeeper;
import org.eclipse.passage.lic.api.io.KeyKeeperRegistry;
import org.eclipse.passage.lic.api.io.StreamCodec;
import org.eclipse.passage.lic.api.io.StreamCodecRegistry;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.api.registry.ServiceId;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.conditions.mining.DecodedContent;
import org.eclipse.passage.lic.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceCannotOperate;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceFailedOnInfrastructureDenial;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceFailedOnMorsel;
import org.eclipse.passage.lic.base.io.LicensingFolder;
import org.eclipse.passage.lic.base.io.UserHomePath;
import org.eclipse.passage.lic.hc.remote.impl.AccessFiles;
import org.eclipse.passage.lic.internal.emf.EObjectFromBytes;
import org.eclipse.passage.lic.internal.hc.i18n.AccessMessages;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicenseAccess;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;

public final class AccessPacks
implements Supplier<ServiceInvocationResult<Collection<FloatingLicenseAccess>>> {
    private final LicensedProduct product;
    private final KeyKeeperRegistry keys;
    private final StreamCodecRegistry codecs;
    private final Supplier<Path> source;

    public AccessPacks(LicensedProduct product, KeyKeeperRegistry keys, StreamCodecRegistry codecs, Supplier<Path> source) {
        this.product = product;
        this.keys = keys;
        this.codecs = codecs;
        this.source = source;
    }

    public AccessPacks(LicensedProduct product, KeyKeeperRegistry keys, StreamCodecRegistry codecs) {
        this(product, keys, codecs, (Supplier<Path>)new LicensingFolder((Supplier)new UserHomePath()));
    }

    @Override
    public ServiceInvocationResult<Collection<FloatingLicenseAccess>> get() {
        Collection<Path> files;
        KeyKeeper key;
        StreamCodec codec;
        try {
            codec = this.codec();
            key = this.key();
        }
        catch (LicensingException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new ServiceCannotOperate(), AccessMessages.AccessPacks_insufficient_configuration, (Exception)((Object)e)));
        }
        ArrayList<FloatingLicenseAccess> result = new ArrayList<FloatingLicenseAccess>();
        try {
            files = new AccessFiles(this.product, this.source).get();
        }
        catch (LicensingException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new ServiceFailedOnInfrastructureDenial(), AccessMessages.AccessPacks_files_gaining_failed, (Exception)((Object)e)));
        }
        List<Trouble> failures = this.accessPacks(key, codec, result, files);
        return new BaseServiceInvocationResult((Diagnostic)new BaseDiagnostic(Collections.emptyList(), failures), result);
    }

    private List<Trouble> accessPacks(KeyKeeper key, StreamCodec codec, List<FloatingLicenseAccess> result, Collection<Path> files) {
        ArrayList<Trouble> failures = new ArrayList<Trouble>();
        for (Path file : files) {
            try {
                result.add(this.from(this.decoded(file, key, codec)));
            }
            catch (LicensingException e) {
                failures.add(new Trouble((TroubleCode)new ServiceFailedOnMorsel(), String.format(AccessMessages.AccessPacks_failed_on_file, file.toAbsolutePath()), (Exception)((Object)e)));
            }
        }
        return failures;
    }

    private byte[] decoded(Path file, KeyKeeper key, StreamCodec codec) throws LicensingException {
        return new DecodedContent(file, key, codec).get();
    }

    private FloatingLicenseAccess from(byte[] content) throws LicensingException {
        return (FloatingLicenseAccess)new EObjectFromBytes(content, LicensesPackage.eINSTANCE.getFloatingLicenseAccess()).get(Collections.singletonMap("http://www.eclipse.org/passage/lic/licenses/3.0.0", LicensesPackage.eINSTANCE));
    }

    private KeyKeeper key() throws LicensingException {
        if (!((Registry)this.keys.get()).hasService((ServiceId)this.product)) {
            throw new LicensingException(String.format(AccessMessages.AccessPacks_no_key_keeper, this.product));
        }
        return (KeyKeeper)((Registry)this.keys.get()).service((ServiceId)this.product);
    }

    private StreamCodec codec() throws LicensingException {
        if (!((Registry)this.codecs.get()).hasService((ServiceId)this.product)) {
            throw new LicensingException(String.format(AccessMessages.AccessPacks_no_stream_codec, this.product));
        }
        return (StreamCodec)((Registry)this.codecs.get()).service((ServiceId)this.product);
    }
}

