/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;

public class DiscardChangesOperation
implements IEGitOperation {
    private final Map<Repository, Collection<String>> pathsByRepository;
    private final ISchedulingRule schedulingRule;
    private String revision;
    private Stage stage;

    public DiscardChangesOperation(IResource[] files) {
        this(files, null);
    }

    public DiscardChangesOperation(IResource[] files, String revision) {
        this(ResourceUtil.splitResourcesByRepository(files));
        this.revision = revision;
    }

    public DiscardChangesOperation(Collection<IPath> paths) {
        this(ResourceUtil.splitPathsByRepository(paths));
    }

    public DiscardChangesOperation(Repository repository, Collection<String> paths) {
        this(Collections.singletonMap(repository, paths));
    }

    private DiscardChangesOperation(Map<Repository, Collection<String>> pathsByRepository) {
        this.pathsByRepository = pathsByRepository;
        this.schedulingRule = RuleUtil.getRuleForRepositories(pathsByRepository.keySet());
    }

    public Map<Repository, Collection<String>> getPathsPerRepository() {
        HashMap<Repository, Collection<String>> result = new HashMap<Repository, Collection<String>>();
        for (Map.Entry<Repository, Collection<String>> entry : this.pathsByRepository.entrySet()) {
            result.put(entry.getKey(), Collections.unmodifiableCollection(entry.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    public void setStage(Stage stage) {
        if (this.revision != null && stage != null) {
            throw new IllegalStateException("Either stage or revision can be set, but not both");
        }
        this.stage = stage;
    }

    public void setRevision(String revision) {
        if (this.stage != null && revision != null) {
            throw new IllegalStateException("Either stage or revision can be set, but not both");
        }
        this.revision = revision;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                DiscardChangesOperation.this.discardChanges(actMonitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, m);
    }

    private void discardChanges(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)CoreText.DiscardChangesOperation_discardingChanges, (int)(this.pathsByRepository.size() * 2));
        boolean errorOccurred = false;
        for (Map.Entry<Repository, Collection<String>> entry : this.pathsByRepository.entrySet()) {
            Repository repository = entry.getKey();
            Collection<String> paths = entry.getValue();
            try {
                this.discardChanges(repository, paths, (IProgressMonitor)progress.newChild(1));
            }
            catch (GitAPIException e) {
                errorOccurred = true;
                Activator.logError(CoreText.DiscardChangesOperation_discardFailed, e);
            }
            try {
                ProjectUtil.refreshRepositoryResources(repository, paths, (IProgressMonitor)progress.newChild(1));
            }
            catch (CoreException e) {
                errorOccurred = true;
                Activator.logError(CoreText.DiscardChangesOperation_refreshFailed, e);
            }
        }
        if (errorOccurred) {
            IStatus status = Activator.error(CoreText.DiscardChangesOperation_discardFailedSeeLog, null);
            throw new CoreException(status);
        }
    }

    private void discardChanges(Repository repository, Collection<String> paths, IProgressMonitor progress) throws GitAPIException {
        ResourceUtil.saveLocalHistory(repository);
        Throwable throwable = null;
        Object var5_6 = null;
        try (Git git = new Git(repository);){
            CheckoutCommand checkoutCommand = git.checkout().setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer(progress));
            if (this.revision != null) {
                checkoutCommand.setStartPoint(this.revision);
            }
            if (this.stage != null) {
                checkoutCommand.setStage(this.stage.checkoutStage);
            }
            if (paths.isEmpty() || paths.contains("")) {
                checkoutCommand.setAllPaths(true);
            } else {
                for (String path : paths) {
                    checkoutCommand.addPath(path);
                }
            }
            checkoutCommand.call();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static enum Stage {
        BASE(CheckoutCommand.Stage.BASE),
        OURS(CheckoutCommand.Stage.OURS),
        THEIRS(CheckoutCommand.Stage.THEIRS);

        private CheckoutCommand.Stage checkoutStage;

        private Stage(CheckoutCommand.Stage checkoutStage) {
            this.checkoutStage = checkoutStage;
        }
    }
}

