/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MouseEventKind implements Enumerator
{
    DOWN(0, "DOWN", "down"),
    UP(1, "UP", "up"),
    MOVE(2, "MOVE", "move"),
    ENTER(3, "ENTER", "enter"),
    EXIT(4, "EXIT", "exit"),
    DOUBLE_CLICK(5, "DOUBLE_CLICK", "double-click"),
    HOVER(6, "HOVER", "hover");

    public static final int DOWN_VALUE = 0;
    public static final int UP_VALUE = 1;
    public static final int MOVE_VALUE = 2;
    public static final int ENTER_VALUE = 3;
    public static final int EXIT_VALUE = 4;
    public static final int DOUBLE_CLICK_VALUE = 5;
    public static final int HOVER_VALUE = 6;
    private static final MouseEventKind[] VALUES_ARRAY;
    public static final List<MouseEventKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MouseEventKind[]{DOWN, UP, MOVE, ENTER, EXIT, DOUBLE_CLICK, HOVER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MouseEventKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MouseEventKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MouseEventKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MouseEventKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MouseEventKind get(int value) {
        switch (value) {
            case 0: {
                return DOWN;
            }
            case 1: {
                return UP;
            }
            case 2: {
                return MOVE;
            }
            case 3: {
                return ENTER;
            }
            case 4: {
                return EXIT;
            }
            case 5: {
                return DOUBLE_CLICK;
            }
            case 6: {
                return HOVER;
            }
        }
        return null;
    }

    private MouseEventKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

