/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.expressions;

import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.ui.internal.expressions.AbstractPropertyTester;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class BundlePropertyTester
extends AbstractPropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if ("isBundleInstalled".equals(property)) {
            return this.computeResult(expectedValue, this.versionCheck(args));
        }
        return false;
    }

    private boolean versionCheck(Object[] args) {
        if (args != null && args.length > 0 && args[0] instanceof String) {
            Bundle bundle = Platform.getBundle((String)((String)args[0]));
            if (bundle == null) {
                return false;
            }
            Version min = args.length > 1 ? this.toVersion(args[1]) : null;
            Version max = args.length > 2 ? this.toVersion(args[2]) : null;
            boolean inRange = true;
            if (min != null) {
                boolean bl = inRange = bundle.getVersion().compareTo(min) >= 0;
            }
            if (inRange && max != null) {
                inRange = bundle.getVersion().compareTo(max) < 0;
            }
            return inRange;
        }
        return false;
    }

    private Version toVersion(Object arg) {
        try {
            return Version.valueOf((String)arg.toString());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

