/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.OpenSearchDialogAction;
import org.eclipse.search.internal.ui.ScopePart;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPageDescriptor;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPreferencePage;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.internal.ui.util.ExtendedDialogWindow;
import org.eclipse.search.ui.IReplacePage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SearchDialog
extends ExtendedDialogWindow
implements ISearchPageContainer,
IPageChangeProvider {
    private static final String DIALOG_NAME = "SearchDialog";
    private static final String STORE_PREVIOUS_PAGE = "PREVIOUS_PAGE";
    private static final int SEARCH_ID = 1025;
    private static final int REPLACE_ID = 1026;
    private static final int CUSTOMIZE_ID = 1027;
    private ISearchPage fCurrentPage;
    private String fInitialPageId;
    private int fCurrentIndex;
    private List<SearchPageDescriptor> fDescriptors;
    private Point fMinSize;
    private ScopePart[] fScopeParts;
    private boolean fLastEnableState;
    private Button fCustomizeButton;
    private Button fReplaceButton;
    private ListenerList<IPageChangedListener> fPageChangeListeners;
    private final IWorkbenchWindow fWorkbenchWindow;
    private final ISelection fCurrentSelection;
    private final String[] fCurrentEnclosingProject;
    private final IDialogSettings fDialogSettings = DialogSettings.getOrCreateSection((IDialogSettings)PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(SearchDialog.class)).getDialogSettings(), (String)"SearchDialog");

    public SearchDialog(IWorkbenchWindow window, String pageId) {
        super(window.getShell());
        this.fWorkbenchWindow = window;
        this.fCurrentSelection = window.getSelectionService().getSelection();
        this.fCurrentEnclosingProject = SearchDialog.evaluateEnclosingProject(this.fCurrentSelection, this.getActiveEditor());
        this.fDescriptors = this.filterByActivities(SearchPlugin.getDefault().getEnabledSearchPageDescriptors(pageId));
        this.fInitialPageId = pageId;
        if (this.fInitialPageId == null && SearchPreferencePage.rememberLastUsedPage()) {
            this.fInitialPageId = this.fDialogSettings.get(STORE_PREVIOUS_PAGE);
        }
        this.fPageChangeListeners = null;
        this.setUseEmbeddedProgressMonitorPart(false);
    }

    public static String evaluateEnclosingProject(IAdaptable adaptable) {
        IResource resource;
        IProject project = (IProject)adaptable.getAdapter(IProject.class);
        if (project == null && (resource = (IResource)adaptable.getAdapter(IResource.class)) != null) {
            project = resource.getProject();
        }
        if (project != null && project.isAccessible()) {
            return project.getName();
        }
        return null;
    }

    public static String[] evaluateEnclosingProject(ISelection selection, IEditorPart activeEditor) {
        if (activeEditor != null) {
            String name = SearchDialog.evaluateEnclosingProject((IAdaptable)activeEditor.getEditorInput());
            if (name != null) {
                return new String[]{name};
            }
        } else if (selection instanceof IStructuredSelection) {
            HashSet<String> res = new HashSet<String>();
            for (Object curr : (IStructuredSelection)selection) {
                String name;
                if (curr instanceof IWorkingSet) {
                    IAdaptable[] elements;
                    int n;
                    int n2;
                    IAdaptable[] iAdaptableArray;
                    IWorkingSet workingSet = (IWorkingSet)curr;
                    if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
                        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        iAdaptableArray = projects;
                        n2 = projects.length;
                        n = 0;
                        while (n < n2) {
                            IAdaptable proj = iAdaptableArray[n];
                            if (proj.isOpen()) {
                                res.add(proj.getName());
                            }
                            ++n;
                        }
                        continue;
                    }
                    iAdaptableArray = elements = workingSet.getElements();
                    n2 = elements.length;
                    n = 0;
                    while (n < n2) {
                        IAdaptable element = iAdaptableArray[n];
                        String name2 = SearchDialog.evaluateEnclosingProject(element);
                        if (name2 != null) {
                            res.add(name2);
                        }
                        ++n;
                    }
                    continue;
                }
                if (!(curr instanceof IAdaptable) || (name = SearchDialog.evaluateEnclosingProject((IAdaptable)curr)) == null) continue;
                res.add(name);
            }
            if (!res.isEmpty()) {
                return res.toArray(new String[res.size()]);
            }
        }
        return new String[0];
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return SearchPlugin.getDefault().getDialogSettingsSection("DialogBounds_SearchDialog");
    }

    protected Point getInitialSize() {
        Point requiredSize = this.getShell().computeSize(-1, -1, true);
        Point lastSize = super.getInitialSize();
        if (requiredSize.x > lastSize.x || requiredSize.y > lastSize.y) {
            return requiredSize;
        }
        return lastSize;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SearchMessages.SearchDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.search.search_dialog_context");
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.fWorkbenchWindow;
    }

    @Override
    public ISelection getSelection() {
        return this.fCurrentSelection;
    }

    public IEditorPart getActiveEditor() {
        IWorkbenchPage activePage = this.fWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IWorkbenchPart activePart = activePage.getActivePart();
        if (activePart == null) {
            return null;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor == activePart) {
            return activeEditor;
        }
        return null;
    }

    public void create() {
        super.create();
        if (this.fCurrentPage != null) {
            this.fCurrentPage.setVisible(true);
        }
    }

    private void handleCustomizePressed() {
        List<SearchPageDescriptor> input = SearchPlugin.getDefault().getSearchPageDescriptors();
        input = this.filterByActivities(input);
        final ArrayList<Image> createdImages = new ArrayList<Image>(input.size());
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof SearchPageDescriptor) {
                    return LegacyActionTools.removeMnemonics((String)((SearchPageDescriptor)element).getLabel());
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof SearchPageDescriptor) {
                    ImageDescriptor imageDesc = ((SearchPageDescriptor)element).getImage();
                    if (imageDesc == null) {
                        return null;
                    }
                    Image image = imageDesc.createImage();
                    if (image != null) {
                        createdImages.add(image);
                    }
                    return image;
                }
                return null;
            }
        };
        String message = SearchMessages.SearchPageSelectionDialog_message;
        ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), input, (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)labelProvider, message){

            public void create() {
                super.create();
                final CheckboxTableViewer viewer = this.getViewer();
                final Button okButton = this.getOkButton();
                viewer.addCheckStateListener(event -> okButton.setEnabled(viewer.getCheckedElements().length > 0));
                SelectionAdapter listener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        okButton.setEnabled(viewer.getCheckedElements().length > 0);
                    }
                };
                this.getButton(18).addSelectionListener((SelectionListener)listener);
                this.getButton(19).addSelectionListener((SelectionListener)listener);
            }
        };
        dialog.setTitle(SearchMessages.SearchPageSelectionDialog_title);
        dialog.setInitialSelections(SearchPlugin.getDefault().getEnabledSearchPageDescriptors(this.fInitialPageId).toArray());
        if (dialog.open() == 0) {
            SearchPageDescriptor.setEnabled(dialog.getResult());
            Display display = this.getShell().getDisplay();
            this.close();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(() -> new OpenSearchDialogAction().run());
            }
        }
        this.destroyImages(createdImages);
    }

    private List<SearchPageDescriptor> filterByActivities(List<SearchPageDescriptor> input) {
        ArrayList<SearchPageDescriptor> filteredList = new ArrayList<SearchPageDescriptor>(input.size());
        for (SearchPageDescriptor descriptor : input) {
            if (WorkbenchActivityHelper.filterItem((Object)descriptor)) continue;
            filteredList.add(descriptor);
        }
        return filteredList;
    }

    private void destroyImages(List<Image> images) {
        for (Image image : images) {
            if (image == null || image.isDisposed()) continue;
            image.dispose();
        }
    }

    @Override
    protected Control createPageArea(Composite parent) {
        int numPages = this.fDescriptors.size();
        this.fScopeParts = new ScopePart[numPages];
        if (numPages == 0) {
            Label label = new Label(parent, 0x1000040);
            label.setText(SearchMessages.SearchDialog_noSearchExtension);
            return label;
        }
        this.fCurrentIndex = this.getPreferredPageIndex();
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        CTabFolder folder = new CTabFolder(composite, 2048);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(4, 4, true, true));
        folder.setFont(composite.getFont());
        int i = 0;
        while (i < numPages) {
            SearchPageDescriptor descriptor = this.getDescriptorAt(i);
            if (!WorkbenchActivityHelper.filterItem((Object)descriptor)) {
                CTabItem item = new CTabItem(folder, 0);
                item.setData("descriptor", (Object)descriptor);
                item.setText(descriptor.getLabel());
                item.addDisposeListener(e -> {
                    item.setData("descriptor", null);
                    if (item.getImage() != null) {
                        item.getImage().dispose();
                    }
                });
                ImageDescriptor imageDesc = descriptor.getImage();
                if (imageDesc != null) {
                    item.setImage(imageDesc.createImage());
                }
                if (i == this.fCurrentIndex) {
                    Control pageControl = this.createPageControl((Composite)folder, descriptor);
                    pageControl.setLayoutData((Object)new GridData(4, 4, true, true));
                    item.setControl(pageControl);
                    this.fCurrentPage = descriptor.getPage();
                    this.fDialogSettings.put(STORE_PREVIOUS_PAGE, descriptor.getId());
                }
            }
            ++i;
        }
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SearchDialog.this.turnToPage(event);
            }
        });
        folder.setSelection(this.fCurrentIndex);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        if (this.isHelpAvailable()) {
            this.createHelpControl(composite);
        }
        this.fCustomizeButton = this.createButton(composite, 1027, SearchMessages.SearchDialog_customize, true);
        Label filler = new Label(composite, 0);
        filler.setLayoutData((Object)new GridData(768));
        ++layout.numColumns;
        this.fReplaceButton = this.createActionButton(composite, 1026, SearchMessages.SearchDialog_replaceAction, true);
        this.fReplaceButton.setVisible(this.fCurrentPage instanceof IReplacePage);
        Button searchButton = this.createActionButton(composite, 1025, SearchMessages.SearchDialog_searchAction, true);
        searchButton.setEnabled(!this.fDescriptors.isEmpty());
        super.createButtonsForButtonBar(composite);
        return composite;
    }

    @Override
    protected boolean performAction(int actionID) {
        switch (actionID) {
            case 1027: {
                this.handleCustomizePressed();
                return false;
            }
            case 1: {
                return true;
            }
            case 1025: {
                if (this.fCurrentPage != null) {
                    return this.fCurrentPage.performAction();
                }
                return true;
            }
            case 1026: {
                boolean isAutoBuilding = SearchPlugin.setAutoBuilding(false);
                try {
                    this.fCustomizeButton.setEnabled(false);
                    boolean bl = ((IReplacePage)((Object)this.fCurrentPage)).performReplace();
                    return bl;
                }
                finally {
                    this.fCustomizeButton.setEnabled(true);
                    SearchPlugin.setAutoBuilding(isAutoBuilding);
                }
            }
        }
        return false;
    }

    private SearchPageDescriptor getDescriptorAt(int index) {
        return this.fDescriptors.get(index);
    }

    private Point getMinSize() {
        if (this.fMinSize != null) {
            return this.fMinSize;
        }
        int x = 0;
        int y = 0;
        int length = this.fDescriptors.size();
        int i = 0;
        while (i < length) {
            Point size = this.getDescriptorAt(i).getPreferredSize();
            if (size.x != -1) {
                x = Math.max(x, size.x);
            }
            if (size.y != -1) {
                y = Math.max(y, size.y);
            }
            ++i;
        }
        this.fMinSize = new Point(x, y);
        return this.fMinSize;
    }

    private void turnToPage(SelectionEvent event) {
        CTabItem item = (CTabItem)event.item;
        CTabFolder folder = item.getParent();
        SearchPageDescriptor descriptor = (SearchPageDescriptor)item.getData("descriptor");
        if (item.getControl() == null) {
            item.setControl(this.createPageControl((Composite)folder, descriptor));
        }
        Control oldControl = folder.getItem(this.fCurrentIndex).getControl();
        Point oldSize = oldControl.getSize();
        Control newControl = item.getControl();
        Point newSize = newControl.computeSize(-1, -1, true);
        this.resizeDialogIfNeeded(oldSize, newSize);
        ISearchPage oldPage = this.fCurrentPage;
        if (oldPage != null) {
            oldPage.setVisible(false);
        }
        this.fCurrentPage = descriptor.getPage();
        this.fDialogSettings.put(STORE_PREVIOUS_PAGE, descriptor.getId());
        this.fCurrentIndex = folder.getSelectionIndex();
        this.setPerformActionEnabled(this.fCurrentPage != null);
        if (this.fCurrentPage != null) {
            this.fCurrentPage.setVisible(true);
            Control pageControl = this.fCurrentPage.getControl();
            if (pageControl instanceof Composite) {
                ((Composite)pageControl).layout(false, true);
            }
        }
        this.fReplaceButton.setVisible(this.fCurrentPage instanceof IReplacePage);
        this.notifyPageChanged();
    }

    private int getPreferredPageIndex() {
        Object element = null;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            element = ((IStructuredSelection)selection).getFirstElement();
        }
        if (element == null) {
            element = this.getActiveEditorInput();
        }
        int result = 0;
        int level = 0;
        int size = this.fDescriptors.size();
        int i = 0;
        while (i < size) {
            SearchPageDescriptor descriptor = this.fDescriptors.get(i);
            if (this.fInitialPageId != null && this.fInitialPageId.equals(descriptor.getId())) {
                return i;
            }
            int newLevel = descriptor.computeScore(element);
            if (newLevel > level) {
                level = newLevel;
                result = i;
            }
            ++i;
        }
        return result;
    }

    @Override
    public IRunnableContext getRunnableContext() {
        return this;
    }

    @Override
    public int getSelectedScope() {
        if (this.fScopeParts[this.fCurrentIndex] == null) {
            return 0;
        }
        return this.fScopeParts[this.fCurrentIndex].getSelectedScope();
    }

    @Override
    public IWorkingSet[] getSelectedWorkingSets() {
        if (this.fScopeParts[this.fCurrentIndex] == null) {
            return null;
        }
        return this.fScopeParts[this.fCurrentIndex].getSelectedWorkingSets();
    }

    public String[] getEnclosingProjectNames() {
        return this.fCurrentEnclosingProject;
    }

    @Override
    public String[] getSelectedProjectNames() {
        if (this.getSelectedScope() == 3) {
            return this.getEnclosingProjectNames();
        }
        return null;
    }

    @Override
    public void setSelectedScope(int scope) {
        if (this.fScopeParts[this.fCurrentIndex] != null) {
            this.fScopeParts[this.fCurrentIndex].setSelectedScope(scope);
        }
    }

    @Override
    public void setActiveEditorCanProvideScopeSelection(boolean state) {
        if (this.fScopeParts[this.fCurrentIndex] != null) {
            this.fScopeParts[this.fCurrentIndex].setActiveEditorCanProvideScopeSelection(state);
        }
    }

    @Override
    public IEditorInput getActiveEditorInput() {
        IEditorPart editor = this.getActiveEditor();
        if (editor == null) {
            return null;
        }
        if (editor instanceof MultiPageEditorPart) {
            Object page = ((MultiPageEditorPart)editor).getSelectedPage();
            if (page instanceof IEditorPart) {
                editor = (IEditorPart)page;
            } else {
                return null;
            }
        }
        return editor.getEditorInput();
    }

    @Override
    public boolean hasValidScope() {
        return this.getSelectedScope() != 2 || this.getSelectedWorkingSets() != null;
    }

    @Override
    public void setSelectedWorkingSets(IWorkingSet[] workingSets) {
        if (this.fScopeParts[this.fCurrentIndex] != null) {
            this.fScopeParts[this.fCurrentIndex].setSelectedWorkingSets(workingSets);
        }
    }

    @Override
    public void setPerformActionEnabled(boolean state) {
        this.fLastEnableState = state;
        super.setPerformActionEnabled(state && this.hasValidScope());
    }

    public void notifyScopeSelectionChanged() {
        this.setPerformActionEnabled(this.fLastEnableState);
    }

    private Control createPageControl(Composite parent, final SearchPageDescriptor descriptor) {
        final Composite pageWrapper = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageWrapper.setLayout((Layout)layout);
        SearchDialog.applyDialogFont((Control)pageWrapper);
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                ISearchPage page = descriptor.createObject(SearchDialog.this);
                if (page != null) {
                    page.createControl(pageWrapper);
                }
            }

            public void handleException(Throwable ex) {
                if (ex instanceof CoreException) {
                    ExceptionHandler.handle((CoreException)ex, SearchDialog.this.getShell(), SearchMessages.Search_Error_createSearchPage_title, Messages.format(SearchMessages.Search_Error_createSearchPage_message, descriptor.getLabel()));
                } else {
                    ExceptionHandler.displayMessageDialog(ex, SearchDialog.this.getShell(), SearchMessages.Search_Error_createSearchPage_title, Messages.format(SearchMessages.Search_Error_createSearchPage_message, descriptor.getLabel()));
                }
            }
        }));
        ISearchPage page = descriptor.getPage();
        if (page == null || page.getControl() == null) {
            Composite container = new Composite(parent, 0);
            Label label = new Label(container, 64);
            label.setText(Messages.format(SearchMessages.SearchDialog_error_pageCreationFailed, descriptor.getLabel()));
            container.setLayout((Layout)new GridLayout());
            label.setLayoutData((Object)new GridData());
            return container;
        }
        page.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
        boolean showScope = descriptor.showScopeSection();
        if (showScope) {
            Composite c = new Composite(pageWrapper, 0);
            c.setLayoutData((Object)new GridData(4, 1, true, false));
            c.setLayout((Layout)new GridLayout());
            int index = this.fDescriptors.indexOf(descriptor);
            this.fScopeParts[index] = new ScopePart(this, descriptor.canSearchInProjects(), descriptor.canSearchInOpenedEditors());
            Composite part = this.fScopeParts[index].createPart(c);
            SearchDialog.applyDialogFont((Control)part);
            part.setLayoutData((Object)new GridData(4, 1, true, false));
            this.fScopeParts[index].setVisible(true);
        }
        return pageWrapper;
    }

    private void resizeDialogIfNeeded(Point oldSize, Point newSize) {
        if (oldSize == null || newSize == null) {
            return;
        }
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        if (this.mustResize(oldSize, newSize)) {
            if (newSize.x > oldSize.x) {
                shellSize.x += newSize.x - oldSize.x;
            }
            if (newSize.y > oldSize.y) {
                shellSize.y += newSize.y - oldSize.y;
            }
            shell.setSize(shellSize);
            shell.layout(true);
        }
    }

    private boolean mustResize(Point currentSize, Point newSize) {
        return currentSize.x < newSize.x || currentSize.y < newSize.y;
    }

    public boolean close() {
        for (SearchPageDescriptor desc : this.fDescriptors) {
            desc.dispose();
        }
        return super.close();
    }

    public Object getSelectedPage() {
        return this.fCurrentPage;
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        if (this.fPageChangeListeners == null) {
            this.fPageChangeListeners = new ListenerList();
        }
        this.fPageChangeListeners.add((Object)listener);
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.fPageChangeListeners.remove((Object)listener);
    }

    private void notifyPageChanged() {
        if (this.fPageChangeListeners != null && !this.fPageChangeListeners.isEmpty()) {
            final PageChangedEvent event = new PageChangedEvent((IPageChangeProvider)this, this.getSelectedPage());
            for (final IPageChangedListener l : this.fPageChangeListeners) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.pageChanged(event);
                    }
                });
            }
        }
    }

    private class TabFolderLayout
    extends Layout {
        private TabFolderLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children;
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = 0;
            int y = 0;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                Point size = element.computeSize(-1, -1, flushCache);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
                ++n2;
            }
            Point minSize = SearchDialog.this.getMinSize();
            x = Math.max(x, minSize.x);
            y = Math.max(y, minSize.y);
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children;
            Rectangle rect = composite.getClientArea();
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                element.setBounds(rect);
                ++n2;
            }
        }
    }
}

