/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEManager;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.bnd.FileResource;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleFragmentModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.text.IModelTextChangeListener;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleObject;
import org.eclipse.pde.internal.core.text.bundle.SingleManifestHeader;
import org.eclipse.pde.internal.core.text.plugin.FragmentModel;
import org.eclipse.pde.internal.core.text.plugin.PluginModel;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.ManifestUtils;
import org.eclipse.pde.internal.core.util.PatternConstructor;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.pde.internal.ui.wizards.tools.IOrganizeManifestsSettings;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.osgi.resource.Resource;
import org.osgi.service.prefs.BackingStoreException;

public class OrganizeManifest
implements IOrganizeManifestsSettings {
    private static String F_NL_PREFIX = "$nl$";
    private static String[] F_ICON_EXTENSIONS = new String[]{"BMP", "ICO", "JPEG", "JPG", "GIF", "PNG", "TIFF"};

    public static void organizeRequireBundles(IBundle bundle, boolean removeImports) {
        if (!(bundle instanceof Bundle)) {
            return;
        }
        RequireBundleHeader header = (RequireBundleHeader)((Bundle)bundle).getManifestHeader("Require-Bundle");
        if (header != null) {
            RequireBundleObject[] bundles;
            RequireBundleObject[] requireBundleObjectArray = bundles = header.getRequiredBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                RequireBundleObject requiredBundle = requireBundleObjectArray[n2];
                String pluginId = requiredBundle.getId();
                if (PluginRegistry.findModel((String)pluginId) == null) {
                    if (removeImports) {
                        header.removeBundle(requiredBundle);
                    } else {
                        requiredBundle.setOptional(true);
                    }
                }
                ++n2;
            }
        }
    }

    public static void organizeExportPackages(IBundle bundle, IProject project, boolean addMissing, boolean removeUnresolved) {
        ExportPackageObject[] currentPkgs;
        if (!addMissing && !removeUnresolved) {
            return;
        }
        if (!(bundle instanceof Bundle)) {
            return;
        }
        ExportPackageHeader header = (ExportPackageHeader)bundle.getManifestHeader("Export-Package");
        if (header == null) {
            bundle.setHeader("Export-Package", "");
            header = (ExportPackageHeader)bundle.getManifestHeader("Export-Package");
            currentPkgs = new ExportPackageObject[]{};
        } else {
            currentPkgs = header.getPackages();
        }
        IManifestHeader bundleClasspathheader = bundle.getManifestHeader("Bundle-ClassPath");
        IPackageFragmentRoot[] roots = ManifestUtils.findPackageFragmentRoots((IManifestHeader)bundleClasspathheader, (IProject)project);
        HashSet<String> packages = new HashSet<String>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            try {
                if (ManifestUtils.isImmediateRoot((IPackageFragmentRoot)root)) {
                    IJavaElement[] elements;
                    IJavaElement[] iJavaElementArray = elements = root.getChildren();
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IJavaElement element = iJavaElementArray[n4];
                        if (element instanceof IPackageFragment) {
                            IPackageFragment fragment = (IPackageFragment)element;
                            String name = fragment.getElementName();
                            if (name.length() == 0) {
                                name = ".";
                            }
                            if (fragment.hasChildren() || fragment.getNonJavaResources().length > 0) {
                                if (addMissing && !header.hasPackage(name)) {
                                    header.addPackage((PackageObject)new ExportPackageObject((ManifestHeader)header, fragment, "version"));
                                } else {
                                    packages.add(name);
                                }
                            }
                        }
                        ++n4;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            ++n2;
        }
        if (removeUnresolved) {
            int i = 0;
            while (i < currentPkgs.length) {
                if (!packages.contains(currentPkgs[i].getName())) {
                    header.removePackage((PackageObject)currentPkgs[i]);
                }
                ++i;
            }
        }
    }

    public static void markPackagesInternal(IBundle bundle, String packageFilter) {
        if (packageFilter == null || bundle == null || !(bundle instanceof Bundle)) {
            return;
        }
        ExportPackageHeader header = (ExportPackageHeader)bundle.getManifestHeader("Export-Package");
        if (header == null) {
            return;
        }
        ExportPackageObject[] currentPkgs = header.getPackages();
        Pattern pat = PatternConstructor.createPattern((String)packageFilter, (boolean)false);
        int i = 0;
        while (i < currentPkgs.length) {
            String values = currentPkgs[i].getValueComponents()[0];
            if (!currentPkgs[i].isInternal() && currentPkgs[i].getFriends().length == 0 && pat.matcher(values).matches()) {
                currentPkgs[i].setInternal(true);
            }
            ++i;
        }
    }

    public static void organizeImportPackages(IBundle bundle, boolean removeImports) {
        if (!(bundle instanceof Bundle)) {
            return;
        }
        ImportPackageHeader header = (ImportPackageHeader)((Bundle)bundle).getManifestHeader("Import-Package");
        if (header == null) {
            return;
        }
        ImportPackageObject[] importedPackages = header.getPackages();
        Set<String> availablePackages = OrganizeManifest.getAvailableExportedPackages();
        ImportPackageObject[] importPackageObjectArray = importedPackages;
        int n = importedPackages.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageObject importedPackage = importPackageObjectArray[n2];
            String pkgName = importedPackage.getName();
            if (!availablePackages.contains(pkgName)) {
                if (removeImports) {
                    header.removePackage((PackageObject)importedPackage);
                } else {
                    importedPackage.setOptional(true);
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void computeImportPackages(IBundlePluginModelBase pluginModel, IProject project, IProgressMonitor monitor) throws CoreException {
        Throwable buildProperties;
        RequireBundleObject[] bundles;
        RequireBundleHeader header;
        IBundle bundle = pluginModel.getBundleModel().getBundle();
        IEclipsePreferences pref = new ProjectScope(project).getNode("org.eclipse.pde.core");
        pref.putBoolean("resolve.requirebundle", false);
        try {
            pref.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        IBuildModel buildModel = PluginRegistry.createBuildModel((IPluginModelBase)pluginModel);
        if (buildModel != null && (header = (RequireBundleHeader)bundle.getManifestHeader("Require-Bundle")) != null && (bundles = header.getRequiredBundles()).length > 0) {
            IBuild build = buildModel.getBuild();
            IBuildEntry entry = build.getEntry("additional.bundles");
            if (entry == null) {
                entry = buildModel.getFactory().createEntry("additional.bundles");
                build.add(entry);
            }
            RequireBundleObject[] requireBundleObjectArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                RequireBundleObject requiredBundle = requireBundleObjectArray[n2];
                String pluginId = requiredBundle.getId();
                header.removeBundle(requiredBundle);
                if (!entry.contains(pluginId)) {
                    entry.addToken(pluginId);
                }
                ++n2;
            }
            buildProperties = PDEProject.getBuildProperties((IProject)project);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Throwable throwable = null;
            requireBundleObjectArray = null;
            try (PrintWriter writer = new PrintWriter(stream);){
                build.write("", writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                } else {
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (buildProperties.exists()) {
                buildProperties.setContents(new ByteArrayInputStream(stream.toByteArray()), 3, monitor);
            } else {
                buildProperties.create(new ByteArrayInputStream(stream.toByteArray()), true, monitor);
            }
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] classpath = javaProject.getResolvedClasspath(true);
        IPath outputLocation = javaProject.getOutputLocation();
        IWorkspaceRoot workspaceRoot = project.getWorkspace().getRoot();
        try {
            buildProperties = null;
            Object var11_17 = null;
            try {
                Jar jar = new Jar(project.getProject().getName());
                try {
                    try (Analyzer analyzer = new Analyzer(jar);){
                        analyzer.setImportPackage("*");
                        IFolder folder = workspaceRoot.getFolder(outputLocation);
                        FileResource.addResources((Jar)jar, (IContainer)folder, null);
                        IClasspathEntry[] iClasspathEntryArray = classpath;
                        int n = classpath.length;
                        int n3 = 0;
                        while (n3 < n) {
                            IPath location;
                            File file;
                            IClasspathEntry cp = iClasspathEntryArray[n3];
                            if (cp.getEntryKind() == 1 && (file = cp.getPath().toFile()) != null && file.exists()) {
                                analyzer.addClasspath(file);
                            }
                            if (cp.getEntryKind() == 3 && !cp.isTest() && (location = cp.getOutputLocation()) != null) {
                                IFolder folder2 = workspaceRoot.getFolder(location);
                                FileResource.addResources((Jar)jar, (IContainer)folder2, null);
                            }
                            ++n3;
                        }
                        Manifest manifest = analyzer.calcManifest();
                        String calculatedImportPackage = manifest.getMainAttributes().getValue("Import-Package");
                        if (calculatedImportPackage == null || calculatedImportPackage.isBlank()) {
                            bundle.setHeader("Import-Package", null);
                        } else {
                            Parameters header2 = OSGiHeader.parseHeader((String)calculatedImportPackage);
                            StringBuilder buffer = new StringBuilder();
                            for (Map.Entry entry : header2.entrySet()) {
                                if (buffer.length() > 0) {
                                    buffer.append(",\n ");
                                }
                                buffer.append((String)entry.getKey());
                                Attrs value = (Attrs)entry.getValue();
                                String attrs = value.toString();
                                if (attrs.isEmpty()) continue;
                                buffer.append(";");
                                buffer.append(attrs);
                            }
                            bundle.setHeader("Import-Package", buffer.toString());
                        }
                    }
                    if (jar == null) return;
                }
                catch (Throwable throwable) {
                    if (buildProperties == null) {
                        buildProperties = throwable;
                    } else if (buildProperties != throwable) {
                        buildProperties.addSuppressed(throwable);
                    }
                    if (jar == null) throw buildProperties;
                    jar.close();
                    throw buildProperties;
                }
                jar.close();
                return;
            }
            catch (Throwable throwable) {
                if (buildProperties == null) {
                    buildProperties = throwable;
                    throw buildProperties;
                } else {
                    if (buildProperties == throwable) throw buildProperties;
                    buildProperties.addSuppressed(throwable);
                }
                throw buildProperties;
            }
        }
        catch (Exception e) {
            throw new CoreException(Status.error((String)"Error generating manifest!", (Throwable)e));
        }
    }

    private static final Set<String> getAvailableExportedPackages() {
        State state = TargetPlatformHelper.getState();
        ExportPackageDescription[] packages = state.getExportedPackages();
        HashSet<String> set = new HashSet<String>();
        ExportPackageDescription[] exportPackageDescriptionArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription exportedPackage = exportPackageDescriptionArray[n2];
            set.add(exportedPackage.getName());
            ++n2;
        }
        return set;
    }

    public static void removeUnneededLazyStart(IBundle bundle) {
        if (!(bundle instanceof Bundle)) {
            return;
        }
        if (bundle.getHeader("Bundle-Activator") == null && bundle.getHeader("Service-Component") == null) {
            String[] remove;
            String[] stringArray = remove = new String[]{"Eclipse-LazyStart", "Eclipse-AutoStart", "Bundle-ActivationPolicy"};
            int n = remove.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                IManifestHeader lazy = ((Bundle)bundle).getManifestHeader(element);
                if (lazy instanceof SingleManifestHeader) {
                    ((SingleManifestHeader)lazy).setMainComponent(null);
                }
                ++n2;
            }
        }
    }

    public static Change deleteUselessPluginFile(IProject project, IPluginModelBase modelBase) {
        if (modelBase == null) {
            return null;
        }
        IExtensions ext = modelBase.getExtensions();
        if (ext.getExtensionPoints().length > 0 || ext.getExtensions().length > 0) {
            return null;
        }
        IFile pluginFile = modelBase instanceof IBundleFragmentModel ? PDEProject.getFragmentXml((IProject)project) : PDEProject.getPluginXml((IProject)project);
        return new DeleteResourceChange(pluginFile.getFullPath(), true);
    }

    public static TextFileChange[] removeUnusedKeys(final IProject project, final IBundle bundle, final IPluginModelBase modelBase) {
        IFile propertiesFile;
        String localization = bundle.getLocalization();
        if (localization == null) {
            localization = "plugin";
        }
        if (!(propertiesFile = project.getFile(localization + ".properties")).exists()) {
            return new TextFileChange[0];
        }
        return PDEModelUtility.changesForModelModication(new ModelModification(propertiesFile){

            @Override
            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (!(model instanceof IBuildModel)) {
                    return;
                }
                IBuild build = ((IBuildModel)model).getBuild();
                IBuildEntry[] entries = build.getBuildEntries();
                ArrayList<String> allKeys = new ArrayList<String>(entries.length);
                int i = 0;
                while (i < entries.length) {
                    if (!allKeys.contains(entries[i].getName())) {
                        allKeys.add(entries[i].getName());
                    }
                    ++i;
                }
                ArrayList<String> usedkeys = new ArrayList<String>();
                OrganizeManifest.findTranslatedStrings(project, modelBase, bundle, usedkeys);
                allKeys.removeAll(usedkeys);
                if (allKeys.isEmpty()) {
                    return;
                }
                IBuildEntry[] iBuildEntryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildEntry buildEntry = iBuildEntryArray[n2];
                    String[] tokens = buildEntry.getTokens();
                    if (tokens != null && tokens.length != 0) {
                        Object entry = tokens[0];
                        int k = 1;
                        while (k < tokens.length) {
                            entry = (String)entry + "," + tokens[k];
                            ++k;
                        }
                        if (((String)entry).indexOf(37) != ((String)entry).lastIndexOf(37)) {
                            int j = 0;
                            while (j < allKeys.size()) {
                                String akey = "%" + (String)allKeys.get(j) + "%";
                                if (((String)entry).contains(akey)) {
                                    allKeys.remove(allKeys.get(j--));
                                }
                                if (allKeys.isEmpty()) {
                                    return;
                                }
                                ++j;
                            }
                        }
                    }
                    ++n2;
                }
                int i2 = 0;
                while (i2 < allKeys.size()) {
                    IBuildEntry entry = build.getEntry((String)allKeys.get(i2));
                    build.remove(entry);
                    ++i2;
                }
            }
        }, null);
    }

    private static void findTranslatedStrings(IProject project, IPluginModelBase pluginModel, IBundle bundle, ArrayList<String> list) {
        OrganizeManifest.findTranslatedXMLStrings(pluginModel, list);
        OrganizeManifest.findTranslatedMFStrings(bundle, list);
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        BundleDescription bundleDesc = model.getBundleDescription();
        HostSpecification hostSpec = bundleDesc.getHost();
        if (hostSpec != null) {
            BundleDescription[] hosts;
            BundleDescription[] bundleDescriptionArray = hosts = hostSpec.getHosts();
            int n = hosts.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription host = bundleDescriptionArray[n2];
                IPluginModelBase hostModel = PluginRegistry.findModel((Resource)host);
                if (hostModel != null) {
                    OrganizeManifest.findTranslatedXMLStrings(OrganizeManifest.getTextModel(hostModel, false), list);
                    OrganizeManifest.findTranslatedMFStrings(OrganizeManifest.getTextBundle(hostModel), list);
                }
                ++n2;
            }
        } else {
            IFragmentModel[] fragmentModels;
            IFragmentModel[] iFragmentModelArray = fragmentModels = PDEManager.findFragmentsFor((IPluginModelBase)model);
            int n = fragmentModels.length;
            int n3 = 0;
            while (n3 < n) {
                IFragmentModel fragmentModel = iFragmentModelArray[n3];
                OrganizeManifest.findTranslatedXMLStrings(OrganizeManifest.getTextModel((IPluginModelBase)fragmentModel, true), list);
                OrganizeManifest.findTranslatedMFStrings(OrganizeManifest.getTextBundle((IPluginModelBase)fragmentModel), list);
                ++n3;
            }
        }
    }

    private static IPluginModelBase getTextModel(IPluginModelBase model, boolean fragment) {
        if (model instanceof PluginModel || model instanceof FragmentModel) {
            return model;
        }
        if (model != null) {
            if (!OrganizeManifest.fileExists(model.getInstallLocation(), fragment ? "fragment.xml" : "plugin.xml")) {
                return null;
            }
            Document doc = CoreUtility.getTextDocument((File)new File(model.getInstallLocation()), (String)(fragment ? "fragment.xml" : "plugin.xml"));
            Object returnModel = fragment ? new FragmentModel((IDocument)doc, false) : new PluginModel((IDocument)doc, false);
            try {
                returnModel.load();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (returnModel.isLoaded()) {
                return returnModel;
            }
        }
        return null;
    }

    private static IBundle getTextBundle(IPluginModelBase model) {
        if (model != null) {
            if (!OrganizeManifest.fileExists(model.getInstallLocation(), "META-INF/MANIFEST.MF")) {
                return null;
            }
            Document doc = CoreUtility.getTextDocument((File)new File(model.getInstallLocation()), (String)"META-INF/MANIFEST.MF");
            BundleModel bundleModel = new BundleModel((IDocument)doc, false);
            try {
                bundleModel.load();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (bundleModel.isLoaded()) {
                return bundleModel.getBundle();
            }
        }
        return null;
    }

    private static void findTranslatedXMLStrings(IPluginModelBase model, ArrayList<String> list) {
        IPluginExtension[] extensions;
        IPluginExtensionPoint[] points;
        if (model == null) {
            return;
        }
        IPluginExtensionPoint[] iPluginExtensionPointArray = points = model.getPluginBase().getExtensionPoints();
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtensionPoint point = iPluginExtensionPointArray[n2];
            String value = OrganizeManifest.getTranslatedKey(point.getName());
            if (value != null && !list.contains(value)) {
                list.add(value);
            }
            ++n2;
        }
        IPluginExtension[] iPluginExtensionArray = extensions = model.getPluginBase().getExtensions();
        int n3 = extensions.length;
        n = 0;
        while (n < n3) {
            IPluginExtension extension = iPluginExtensionArray[n];
            if (extension instanceof IDocumentElementNode) {
                OrganizeManifest.inspectElementForTranslation((IDocumentElementNode)extension, list);
            }
            ++n;
        }
    }

    private static void inspectElementForTranslation(IDocumentElementNode parent, ArrayList<String> list) {
        IPluginObject[] children;
        IDocumentAttributeNode[] attributes;
        IDocumentTextNode text = parent.getTextNode();
        String textValue = OrganizeManifest.getTranslatedKey(text != null ? text.getText() : null);
        if (textValue != null && !list.contains(textValue)) {
            list.add(textValue);
        }
        IDocumentAttributeNode[] iDocumentAttributeNodeArray = attributes = parent.getNodeAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentAttributeNode attribute = iDocumentAttributeNodeArray[n2];
            String attrValue = OrganizeManifest.getTranslatedKey(attribute.getAttributeValue());
            if (attrValue != null && !list.contains(attrValue)) {
                list.add(attrValue);
            }
            ++n2;
        }
        if (!(parent instanceof IPluginParent)) {
            return;
        }
        IPluginObject[] iPluginObjectArray = children = ((IPluginParent)parent).getChildren();
        int n3 = children.length;
        n = 0;
        while (n < n3) {
            IPluginObject element = iPluginObjectArray[n];
            if (element instanceof IDocumentElementNode) {
                OrganizeManifest.inspectElementForTranslation((IDocumentElementNode)element, list);
            }
            ++n;
        }
    }

    private static void findTranslatedMFStrings(IBundle bundle, ArrayList<String> list) {
        if (bundle == null) {
            return;
        }
        String[] stringArray = ICoreConstants.TRANSLATABLE_HEADERS;
        int n = ICoreConstants.TRANSLATABLE_HEADERS.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String key = OrganizeManifest.getTranslatedKey(bundle.getHeader(element));
            if (key != null && !list.contains(key)) {
                list.add(key);
            }
            ++n2;
        }
    }

    private static String getTranslatedKey(String value) {
        if (value != null && value.length() > 1 && value.charAt(0) == '%' && value.charAt(1) != '%') {
            return value.substring(1);
        }
        return null;
    }

    private static boolean fileExists(String container, String filename) {
        return new File(container + filename).exists();
    }

    public static void prefixIconPaths(IPluginModelBase model) {
        IPluginExtension[] extensions;
        if (model == null) {
            return;
        }
        SchemaRegistry registry = PDECore.getDefault().getSchemaRegistry();
        IPluginExtension[] iPluginExtensionArray = extensions = model.getPluginBase().getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            ISchema schema = registry.getSchema(extension.getPoint());
            if (schema != null) {
                OrganizeManifest.inspectElementsIconPaths(schema, (IPluginParent)extension);
            }
            ++n2;
        }
    }

    private static void inspectElementsIconPaths(ISchema schema, IPluginParent parent) {
        IPluginObject[] children;
        IPluginObject[] iPluginObjectArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginObject childObject = iPluginObjectArray[n2];
            IPluginElement child = (IPluginElement)childObject;
            ISchemaElement schemaElement = schema.findElement(child.getName());
            if (schemaElement != null) {
                IPluginAttribute[] attributes;
                IPluginAttribute[] iPluginAttributeArray = attributes = child.getAttributes();
                int n3 = attributes.length;
                int n4 = 0;
                while (n4 < n3) {
                    int fileExtIndex;
                    String value;
                    IPluginAttribute attribute = iPluginAttributeArray[n4];
                    ISchemaAttribute attInfo = schemaElement.getAttribute(attribute.getName());
                    if (attInfo != null && attInfo.getKind() == 2 && !(value = attribute.getValue()).startsWith(F_NL_PREFIX) && (fileExtIndex = value.lastIndexOf(46)) != -1) {
                        value = value.substring(fileExtIndex + 1);
                        String[] stringArray = F_ICON_EXTENSIONS;
                        int n5 = F_ICON_EXTENSIONS.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String iconExtension = stringArray[n6];
                            if (value.equalsIgnoreCase(iconExtension)) {
                                IPath path = IPath.fromOSString((String)F_NL_PREFIX);
                                Object newValue = attribute.getValue();
                                if (((String)newValue).charAt(0) != '/') {
                                    path = path.addTrailingSeparator();
                                }
                                newValue = path.toString() + (String)newValue;
                                try {
                                    child.setAttribute(attribute.getName(), (String)newValue);
                                }
                                catch (CoreException coreException) {}
                                break;
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            OrganizeManifest.inspectElementsIconPaths(schema, (IPluginParent)child);
            ++n2;
        }
    }

    protected static MultiTextEdit getTextEdit(IModelTextChangeListener listener) {
        if (listener == null) {
            return null;
        }
        TextEdit[] edits = listener.getTextOperations();
        if (edits.length == 0) {
            return null;
        }
        MultiTextEdit multiEdit = new MultiTextEdit();
        multiEdit.addChildren(edits);
        return multiEdit;
    }
}

