/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class DebugTypeSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String SETTINGS_ID = JDIDebugUIPlugin.getUniqueIdentifier() + ".MAIN_METHOD_SELECTION_DIALOG";
    private IType[] fTypes = null;

    public DebugTypeSelectionDialog(Shell shell, IType[] elements, String title) {
        super(shell, false);
        this.setTitle(title);
        this.fTypes = elements;
        this.setMessage(LauncherMessages.JavaMainTab_Choose_a_main__type_to_launch__12);
        this.setInitialPattern("**");
        this.setListLabelProvider(new DebugTypeLabelProvider());
        this.setDetailsLabelProvider(new DebugTypeDetailsLabelProvider());
        this.setSelectionHistory(new DebugTypeSelectionHistory());
    }

    protected Control createDialogArea(Composite parent) {
        Control ctrl = super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(ctrl, IJavaDebugHelpContextIds.SELECT_MAIN_METHOD_DIALOG);
        return ctrl;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGS_ID);
        if (section == null) {
            section = settings.addNewSection(SETTINGS_ID);
        }
        return section;
    }

    protected Comparator getItemsComparator() {
        Comparator<Object> comp = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof IType && o2 instanceof IType) {
                    return ((IType)o1).getElementName().compareTo(((IType)o2).getElementName());
                }
                return -1;
            }
        };
        return comp;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new DebugTypeItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        if (this.fTypes != null && this.fTypes.length > 0) {
            IType[] iTypeArray = this.fTypes;
            int n = this.fTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (itemsFilter.isConsistentItem((Object)type)) {
                    contentProvider.add((Object)type, itemsFilter);
                }
                ++n2;
            }
        }
    }

    public String getElementName(Object item) {
        if (item instanceof IType) {
            return ((IType)item).getElementName();
        }
        return null;
    }

    class DebugTypeDetailsLabelProvider
    extends DebugTypeLabelProvider {
        DebugTypeDetailsLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            IType type;
            String name;
            if (element instanceof IType && (name = this.getDeclaringContainerName(type = (IType)element)) != null) {
                if (name.equals(LauncherMessages.MainMethodLabelProvider_0)) {
                    IJavaProject project = type.getJavaProject();
                    if (project != null) {
                        try {
                            return project.getOutputLocation().toOSString().substring(1) + " - " + name;
                        }
                        catch (JavaModelException e) {
                            JDIDebugUIPlugin.log(e);
                        }
                    }
                } else {
                    return name;
                }
            }
            return null;
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof IType) {
                return super.getImage(this.getDeclaringContainer((IType)element));
            }
            return super.getImage(element);
        }
    }

    class DebugTypeItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        DebugTypeItemsFilter() {
            super((FilteredItemsSelectionDialog)DebugTypeSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return item instanceof IType;
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof IType) || !Arrays.asList(DebugTypeSelectionDialog.this.fTypes).contains(item)) {
                return false;
            }
            return this.matches(((IType)item).getElementName());
        }
    }

    public class DebugTypeLabelProvider
    implements ILabelProvider {
        HashMap<ImageDescriptor, Image> fImageMap = new HashMap();

        public Image getImage(Object element) {
            IWorkbenchAdapter adapter;
            if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
                ImageDescriptor descriptor = adapter.getImageDescriptor(element);
                Image image = this.fImageMap.get(descriptor);
                if (image == null) {
                    boolean returnMissingImageOnError = false;
                    image = descriptor.createImage(returnMissingImageOnError);
                    if (image != null) {
                        this.fImageMap.put(descriptor, image);
                    } else {
                        returnMissingImageOnError = true;
                        image = descriptor.createImage(returnMissingImageOnError);
                    }
                }
                return image;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IType) {
                IType type = (IType)element;
                Object label = type.getTypeQualifiedName();
                String container = this.getDeclaringContainerName(type);
                if (container != null && !"".equals(container)) {
                    label = (String)label + " - " + container;
                }
                return label;
            }
            return null;
        }

        protected String getDeclaringContainerName(IType type) {
            IType outer = type.getDeclaringType();
            if (outer != null) {
                return outer.getFullyQualifiedName('.');
            }
            String name = type.getPackageFragment().getElementName();
            if ("".equals(name)) {
                name = LauncherMessages.MainMethodLabelProvider_0;
            }
            return name;
        }

        protected IJavaElement getDeclaringContainer(IType type) {
            IType outer = type.getDeclaringType();
            if (outer == null) {
                outer = type.getPackageFragment();
            }
            return outer;
        }

        public void dispose() {
            this.fImageMap.values().forEach(Resource::dispose);
            this.fImageMap.clear();
            this.fImageMap = null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class DebugTypeSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        DebugTypeSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            IJavaElement element = JavaCore.create((String)memento.getTextData());
            return element instanceof IType ? element : null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
            if (item instanceof IType) {
                memento.putTextData(((IType)item).getHandleIdentifier());
            }
        }
    }
}

