/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.dialogs;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.GroupContext;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.swt.widgets.Shell;

public class RemoveProjectReferencesDialog
extends MessageDialogWithToggle {
    private static IPreferenceStore prefStore = Q7UIPlugin.getDefault().getPreferenceStore();
    private final List<String> references;
    private final IQ7NamedElement element;
    private static RemoveProjectReferencesDialog instance;

    public static boolean open(Shell parentShell, IQ7NamedElement element, List<String> references) {
        String value = prefStore.getString("remove_project_context_references");
        if ("always".equals(value)) {
            RemoveProjectReferencesDialog.addMissingReferences(element, references);
            return true;
        }
        if (instance != null && instance.getShell() != null && !instance.getShell().isDisposed()) {
            return false;
        }
        instance = new RemoveProjectReferencesDialog(parentShell, element, references);
        return instance.open() == 2;
    }

    private RemoveProjectReferencesDialog(Shell parentShell, IQ7NamedElement element, List<String> references) {
        super(parentShell, "Project Context and Verification References", null, null, 0, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, "Always remove default project context and verification references automatically.", false);
        this.element = element;
        this.references = references;
        this.message = this.generateMessage(references);
        this.setShellStyle(0x10000000);
    }

    private String generateMessage(List<String> references) {
        StringBuilder label = new StringBuilder("Would you like to remove default project context/verification references?\n\n");
        try {
            for (String e : references) {
                List target = this.element.getQ7Project().find(IQ7NamedElement.class, e);
                if (target.size() != 1) continue;
                label.append("    ").append(((IQ7NamedElement)target.get(0)).getNamedElement().getName()).append(" (").append(((IQ7NamedElement)target.get(0)).getPath()).append(")").append("\n");
            }
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
        return label.toString();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2) {
            RemoveProjectReferencesDialog.addMissingReferences(this.element, this.references);
        }
        if (this.getToggleState()) {
            prefStore.setValue("remove_project_context_references", "always");
        }
        this.setReturnCode(buttonId);
        this.close();
    }

    private static void addMissingReferences(final IQ7NamedElement element, final List<String> references) {
        Job job = new Job("Fix project references"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    NamedElement namedElement = element.getNamedElement();
                    EList contexts = null;
                    if (namedElement instanceof Scenario) {
                        contexts = ((Scenario)namedElement).getContexts();
                        ((Scenario)namedElement).getVerifications().removeAll((Collection)references);
                    }
                    if (namedElement instanceof GroupContext) {
                        contexts = ((GroupContext)namedElement).getContextReferences();
                    }
                    if (contexts != null) {
                        contexts.removeAll((Collection)references);
                    }
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

