/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.tags;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EObjectObservableList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.search.tags.TagsContentAssist;
import org.eclipse.rcptt.core.search.tags.TagsSearch;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.core.tags.TagsPackage;
import org.eclipse.rcptt.core.utils.TagsUtil;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.commons.SearchControl;
import org.eclipse.rcptt.ui.utils.ModelUtils;
import org.eclipse.rcptt.util.StringUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;

public class TagsFilterComposite {
    private static final String TOOLTIP_FILTER = "E.g. tag1 OR (tag2 AND !tag3)";
    public IObservableList tags;
    private SearchControl searchControl;
    private TreeViewer tagsViewer;
    private TableViewer listViewer;
    private AutocompleteContentProposalAdapter proposalAdapter;
    private boolean isHorizontal;

    public TagsFilterComposite(Composite parent, boolean isHorizontal) {
        Composite panel;
        this.isHorizontal = isHorizontal;
        if (isHorizontal) {
            panel = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).margins(0, 0).applyTo(panel);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)panel);
        } else {
            panel = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(panel);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)panel);
        }
        this.createFilterControl(panel);
        this.createTreeControl(panel);
        this.createListControl(panel);
    }

    public TreeViewer getTagsViewer() {
        return this.tagsViewer;
    }

    public TableViewer getListViewer() {
        return this.listViewer;
    }

    public void updateList() {
        String string = this.searchControl.getFilterString();
        if (string == null) {
            string = "";
        }
        if ((string = string.trim()).isEmpty()) {
            this.listViewer.setInput(null);
        } else {
            this.listViewer.setInput((Object)TagsSearch.findAllByExpression((String)string));
        }
    }

    private void createFilterControl(Composite panel) {
        this.searchControl = new SearchControl(panel);
        if (this.isHorizontal) {
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.searchControl);
        } else {
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.searchControl);
        }
        this.searchControl.setInitialText("Tag name");
        this.searchControl.getFilterControl().setToolTipText(TOOLTIP_FILTER);
        this.proposalAdapter = new AutocompleteContentProposalAdapter((Control)this.searchControl.getFilterControl(), (IControlContentAdapter)new TextContentAdapter(), new AutocompleteContentProposalProvider(), null, null);
        this.proposalAdapter.setPropagateKeys(true);
        this.proposalAdapter.setProposalAcceptanceStyle(2);
        this.proposalAdapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                TagsFilterComposite.this.selectAutocompleteOffer();
            }
        });
        this.searchControl.getFilterControl().addListener(1, new Listener(){

            public void handleEvent(Event event) {
                switch (event.keyCode) {
                    case 32: {
                        if ((event.stateMask & 0x40000) != 262144) break;
                        TagsFilterComposite.this.proposalAdapter.showProposals();
                        event.doit = false;
                        break;
                    }
                    case 13: {
                        TagsFilterComposite.this.selectAutocompleteOffer();
                    }
                }
            }
        });
    }

    private void selectAutocompleteOffer() {
        this.updateList();
        this.tagsViewer.setSelection(null);
        int index = this.listViewer.getTable().getItemCount();
        ArrayList<Object> toSelect = new ArrayList<Object>();
        while (--index >= 0) {
            toSelect.add(this.listViewer.getElementAt(index));
        }
        this.listViewer.setSelection((ISelection)new StructuredSelection(toSelect), true);
    }

    private void createTreeControl(Composite panel) {
        Tree tree = new Tree(panel, 2050);
        if (this.isHorizontal) {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)tree);
        } else {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(-1, 220).applyTo((Control)tree);
        }
        ObservableListTreeContentProvider treeContentProvider = new ObservableListTreeContentProvider(new IObservableFactory(){

            public IObservable createObservable(Object target) {
                if (target instanceof IObservable) {
                    return (IObservable)target;
                }
                if (target instanceof Tag) {
                    Tag tag = (Tag)target;
                    return new EObjectObservableList((EObject)tag, (EStructuralFeature)TagsPackage.Literals.TAG__TAGS);
                }
                return null;
            }
        }, null);
        LabelProvider treeLabelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return Images.getImage("icons/tag.gif");
            }

            public String getText(Object element) {
                Tag tag = (Tag)element;
                String value = tag.getValue().trim();
                if (value.length() == 0) {
                    return Messages.bind((String)Messages.TagsView_UntaggedLabelFormat, (Object)TagsUtil.getDistinctTagRefsCount((Tag)tag));
                }
                return Messages.bind((String)Messages.TagsView_TagLabelFormat, (Object)value, (Object)TagsUtil.getDistinctTagRefsCount((Tag)tag));
            }
        };
        this.tagsViewer = new TreeViewer(tree);
        this.tagsViewer.setContentProvider((IContentProvider)treeContentProvider);
        this.tagsViewer.setLabelProvider((IBaseLabelProvider)treeLabelProvider);
        this.tagsViewer.setSorter(new ViewerSorter());
        this.tagsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagsFilterComposite.this.updateFilterControl((IStructuredSelection)event.getSelection());
            }
        });
        this.tagsViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TagsFilterComposite.this.tags != null) {
                    TagsFilterComposite.this.tags.dispose();
                }
            }
        });
    }

    private void createListControl(Composite panel) {
        this.listViewer = new TableViewer(panel, 2050);
        if (this.isHorizontal) {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)this.listViewer.getTable());
        } else {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.listViewer.getTable());
        }
        IStructuredContentProvider listContentProvider = new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Tag) {
                    EList refs = ((Tag)inputElement).getRefs();
                    return refs.toArray(new Object[refs.size()]);
                }
                if (inputElement instanceof IQ7NamedElement[]) {
                    Object[] list = (IQ7NamedElement[])inputElement;
                    return list;
                }
                return new Object[0];
            }
        };
        LabelProvider listLabelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IQ7NamedElement) {
                    return ModelUtils.getImage((IQ7Element)((IQ7NamedElement)element));
                }
                return Images.getImage("icons/unknown.gif");
            }

            public String getText(Object element) {
                if (element instanceof IQ7NamedElement) {
                    return ModelUtils.getText((IQ7Element)((IQ7NamedElement)element));
                }
                return element != null ? element.toString() : "null";
            }
        };
        this.listViewer.setContentProvider((IContentProvider)listContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)listLabelProvider);
        this.listViewer.setSorter(new ViewerSorter());
    }

    private void updateFilterControl(IStructuredSelection selection) {
        if (selection.size() >= 1) {
            ArrayList<Object> tags = new ArrayList<Object>();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof Tag) {
                    String tagName = ((Tag)o).getPath();
                    if (tagName.matches(".*[ ()!].*")) {
                        tags.add("\"" + tagName + "\"");
                    } else {
                        tags.add(tagName);
                    }
                }
                ++n2;
            }
            this.proposalAdapter.setEnabled(false);
            this.searchControl.getFilterControl().setText(StringUtils.join((String)" OR ", tags));
            this.proposalAdapter.setEnabled(true);
            if (selection.size() == 1) {
                this.listViewer.setInput(selection.getFirstElement());
            } else {
                this.updateList();
            }
        }
    }

    public class AutocompleteContentProposalAdapter
    extends ContentProposalAdapter {
        public AutocompleteContentProposalAdapter(Control control, IControlContentAdapter controlContentAdapter, IContentProposalProvider proposalProvider, KeyStroke keyStroke, char[] autoActivationCharacters) {
            super(control, controlContentAdapter, proposalProvider, keyStroke, autoActivationCharacters);
        }

        public void showProposals() {
            this.openProposalPopup();
        }
    }

    public class AutocompleteContentProposalProvider
    implements IContentProposalProvider {
        public IContentProposal[] getProposals(String contents, int position) {
            ArrayList proposals = TagsContentAssist.getOffers((String)TagsFilterComposite.this.searchControl.getFilterString(), (List)TagsFilterComposite.this.tags);
            IContentProposal[] contentProposals = new IContentProposal[proposals.size()];
            int i = 0;
            while (i < proposals.size()) {
                contentProposals[i] = new ContentProposal((String)proposals.get(i));
                ++i;
            }
            return contentProposals;
        }
    }
}

