/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.util.reflection;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class ClassUtil {
    private static Map convertor = new HashMap();

    static {
        convertor.put(Boolean.TYPE, Boolean.class);
        convertor.put(Byte.TYPE, Byte.class);
        convertor.put(Character.TYPE, Character.class);
        convertor.put(Double.TYPE, Double.class);
        convertor.put(Float.TYPE, Float.class);
        convertor.put(Integer.TYPE, Integer.class);
        convertor.put(Long.TYPE, Long.class);
        convertor.put(Short.TYPE, Short.class);
    }

    public static Method getMethod(Class aClass, String aMethodName, Class[] someParameterTypes) throws NoSuchMethodException {
        if (someParameterTypes == null || someParameterTypes.length == 0) {
            return aClass.getMethod(aMethodName, null);
        }
        return ClassUtil.getMethod(aClass.getMethods(), aMethodName, someParameterTypes);
    }

    public static Method getDeclaredMethod(Class aClass, String aMethodName, Class[] someParameterTypes) throws NoSuchMethodException {
        if (someParameterTypes == null || someParameterTypes.length == 0) {
            return aClass.getDeclaredMethod(aMethodName, null);
        }
        return ClassUtil.getMethod(aClass.getDeclaredMethods(), aMethodName, someParameterTypes);
    }

    private static Method getMethod(Method[] candidates, String aMethodName, Class[] someParameterTypes) throws NoSuchMethodException {
        int parameterCount = someParameterTypes.length;
        aMethodName = aMethodName.intern();
        TreeSet<Method> matches = new TreeSet<Method>(new MethodComparator(someParameterTypes));
        int i = 0;
        while (i < candidates.length) {
            block5: {
                Method candidate = candidates[i];
                String candidateMethodName = candidate.getName().intern();
                Class<?>[] candidateParameterTypes = candidate.getParameterTypes();
                int candidateParameterCount = candidateParameterTypes.length;
                if (candidateParameterCount == parameterCount && aMethodName == candidateMethodName) {
                    int j = 0;
                    while (j < candidateParameterCount) {
                        Class<?> clazzA = candidateParameterTypes[j];
                        Class clazzB = someParameterTypes[j];
                        if (clazzB == null || ClassUtil.isAssignableFrom(clazzA, clazzB)) {
                            ++j;
                            continue;
                        }
                        break block5;
                    }
                    matches.add(candidate);
                }
            }
            ++i;
        }
        if (matches.size() == 0) {
            throw new NoSuchMethodException("No such method: " + aMethodName + "(" + String.valueOf(Arrays.asList(someParameterTypes)) + ")");
        }
        return (Method)matches.first();
    }

    private static boolean isAssignableFrom(Class clazzA, Class clazzB) {
        if (!(clazzA.isPrimitive() ^ clazzB.isPrimitive())) {
            return clazzA.isAssignableFrom(clazzB);
        }
        if (clazzA.isPrimitive()) {
            Class oClazzA = (Class)convertor.get(clazzA);
            return oClazzA.isAssignableFrom(clazzB);
        }
        Class oClazzB = (Class)convertor.get(clazzB);
        return clazzA.isAssignableFrom(oClazzB);
    }

    private static class MethodComparator
    implements Comparator {
        private final Class[] parameterTypes;

        public MethodComparator(Class[] someParameterTypes) {
            this.parameterTypes = someParameterTypes;
        }

        public int compare(Object object1, Object object2) {
            Object[] pt2;
            Object[] pt1 = ((Method)object1).getParameterTypes();
            if (Arrays.equals(pt1, pt2 = ((Method)object2).getParameterTypes())) {
                return 0;
            }
            if (Arrays.equals(this.parameterTypes, pt1)) {
                return -1;
            }
            return 1;
        }
    }
}

