/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.pde.ds.ui";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerImageDescriptor(registry, "icons/obj16/class_obj.png");
        this.registerImageDescriptor(registry, "icons/obj16/properties_obj.png");
        this.registerImageDescriptor(registry, "icons/obj16/property_obj.png");
        this.registerImageDescriptor(registry, "icons/obj16/int_obj.png");
        this.registerImageDescriptor(registry, "icons/obj16/reference_obj.png");
        this.registerImageDescriptor(registry, "icons/obj16/reference_zero_n_obj.png");
        this.registerImageDescriptor(registry, "icons/obj16/reference_zero_one_obj.png");
        this.registerImageDescriptor(registry, "icons/obj16/reference_one_n_obj.png");
        this.registerImageDescriptor(registry, "icons/obj16/component_obj.png");
        this.registerImageDescriptor(registry, "icons/obj16/service_obj.png");
        this.registerImageDescriptor(registry, "icons/obj16/services_obj.png");
        this.registerImageDescriptor(registry, "icons/obj16/ds_obj.png");
        this.registerImageDescriptor(registry, "icons/obj16/attribute_obj.png");
        this.registerImageDescriptor(registry, "icons/ovr16/synch_co.png");
        this.registerImageDescriptor(registry, "icons/obj16/details_obj.png");
        this.registerImageDescriptor(registry, "icons/wizban/defcon_wiz.png");
    }

    private void registerImageDescriptor(ImageRegistry registry, String id) {
        ResourceLocator.imageDescriptorFromBundle((String)PLUGIN_ID, (String)id).ifPresent(d -> registry.put(id, d));
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = Activator.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static void logException(Throwable e, String title, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = Status.error((String)message, (Throwable)e);
        }
        ResourcesPlugin.getPlugin().getLog().log(status);
        Display display = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
        IStatus fstatus = status;
        display.asyncExec(() -> {
            int n = ErrorDialog.openError(null, (String)title, null, (IStatus)fstatus);
        });
    }

    public static void logException(Throwable e) {
        Activator.logException(e, null, null);
    }
}

