/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.css.properties.css2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.dom.properties.Gradient;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.properties.AbstractCSSPropertySWTHandler;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyFormHandler
extends AbstractCSSPropertySWTHandler {
    public static final String TB_TOGGLE_HOVER = "tb-toggle-hover-color";
    public static final String TB_TOGGLE = "tb-toggle-color";
    public static final String H_HOVER_FULL = "h-hover-full-color";
    public static final String H_HOVER_LIGHT = "h-hover-light-color";
    public static final String H_BOTTOM_KEYLINE_2 = "h-bottom-keyline-2-color";
    public static final String H_BOTTOM_KEYLINE_1 = "h-bottom-keyline-1-color";
    public static final String TEXT_BACKGROUND_COLOR = "text-background-color";
    private static final Map<String, String> propertyToHeadProperty = new HashMap<String, String>();

    static {
        propertyToHeadProperty.put(H_BOTTOM_KEYLINE_1, "org.eclipse.ui.forms.H_BOTTOM_KEYLINE1");
        propertyToHeadProperty.put(H_BOTTOM_KEYLINE_2, "org.eclipse.ui.forms.H_BOTTOM_KEYLINE2");
        propertyToHeadProperty.put(H_HOVER_LIGHT, "org.eclipse.ui.forms.H_H_HOVER_LIGHT");
        propertyToHeadProperty.put(H_HOVER_FULL, "org.eclipse.ui.forms.H_H_HOVER_FULL");
        propertyToHeadProperty.put(TB_TOGGLE, "org.eclipse.ui.forms.TB_TOGGLE");
        propertyToHeadProperty.put(TB_TOGGLE_HOVER, "org.eclipse.ui.forms.TB_TOGGLE_HOVER");
    }

    protected void applyCSSProperty(Control control, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(control instanceof Form)) {
            return;
        }
        Form form = (Form)control;
        if (TEXT_BACKGROUND_COLOR.equals(property)) {
            if (value.getCssValueType() == 1) {
                Color color = (Color)engine.convert(value, Color.class, (Object)form.getDisplay());
                form.setTextBackground(new Color[]{color}, new int[]{100}, true);
            } else if (value.getCssValueType() == 2) {
                Gradient grad = (Gradient)engine.convert(value, Gradient.class, (Object)form.getDisplay());
                if (grad == null) {
                    return;
                }
                List values = grad.getValues();
                ArrayList<Color> colors = new ArrayList<Color>(values.size());
                for (CSSPrimitiveValue cssValue : values) {
                    if (cssValue == null || cssValue.getCssValueType() != 1) continue;
                    Color color = (Color)engine.convert((CSSValue)cssValue, Color.class, (Object)form.getDisplay());
                    colors.add(color);
                }
                if (colors.size() > 0) {
                    List list = grad.getPercents();
                    int[] percents = new int[list.size()];
                    int i = 0;
                    while (i < percents.length) {
                        percents[i] = (Integer)list.get(i);
                        ++i;
                    }
                    form.setTextBackground(colors.toArray(new Color[0]), percents, grad.getVerticalGradient());
                }
            }
        } else {
            String headProperty = propertyToHeadProperty.get(property);
            if (headProperty != null && value.getCssValueType() == 1) {
                Color color = (Color)engine.convert(value, Color.class, (Object)form.getDisplay());
                form.setHeadColor(headProperty, color);
            }
        }
    }

    protected String retrieveCSSProperty(Control control, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

