/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;

public class AddInferredLambdaParameterTypesFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public AddInferredLambdaParameterTypesFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation) {
        super(name, compilationUnit, operation);
    }

    public static AddInferredLambdaParameterTypesFixCore createAddInferredLambdaParameterTypesFix(CompilationUnit compilationUnit, ASTNode node) {
        IMethodBinding methodBinding;
        LambdaExpression lambda = null;
        boolean isLambdaParamVarType = false;
        ASTNode parent = node.getParent();
        if (node instanceof LambdaExpression) {
            lambda = (LambdaExpression)node;
        } else if ((node.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY || node.getLocationInParent() == SingleVariableDeclaration.NAME_PROPERTY) && parent.getLocationInParent() == LambdaExpression.PARAMETERS_PROPERTY) {
            lambda = (LambdaExpression)parent.getParent();
        }
        if (lambda == null) {
            return null;
        }
        List lambdaParameters = lambda.parameters();
        int noOfLambdaParams = lambdaParameters.size();
        if (noOfLambdaParams == 0) {
            return null;
        }
        VariableDeclaration firstLambdaParam = (VariableDeclaration)lambdaParameters.get(0);
        if (firstLambdaParam instanceof SingleVariableDeclaration) {
            IJavaProject javaProject;
            IJavaElement root = compilationUnit.getJavaElement();
            if (root != null && (javaProject = root.getJavaProject()) != null && JavaModelUtil.is11OrHigher(javaProject) && ((SingleVariableDeclaration)firstLambdaParam).getType().isVar()) {
                isLambdaParamVarType = true;
            }
            if (!isLambdaParamVarType) {
                return null;
            }
        }
        if ((methodBinding = lambda.resolveMethodBinding()) == null) {
            return null;
        }
        String label = CorrectionMessages.QuickAssistProcessor_add_inferred_lambda_parameter_types;
        if (isLambdaParamVarType) {
            label = CorrectionMessages.QuickAssistProcessor_replace_var_with_inferred_lambda_parameter_types;
        }
        return new AddInferredLambdaParameterTypesFixCore(label, compilationUnit, new AddInferredLambdaParameterTypesProposalOperation(lambda, methodBinding, noOfLambdaParams, lambdaParameters));
    }

    private static class AddInferredLambdaParameterTypesProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private LambdaExpression lambda;
        private IMethodBinding methodBinding;
        private int noOfLambdaParams;
        private List<VariableDeclaration> lambdaParameters;

        public AddInferredLambdaParameterTypesProposalOperation(LambdaExpression lambda, IMethodBinding methodBinding, int noOfLambdaParams, List<VariableDeclaration> lambdaParameters) {
            this.lambda = lambda;
            this.methodBinding = methodBinding;
            this.noOfLambdaParams = noOfLambdaParams;
            this.lambdaParameters = lambdaParameters;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            AST ast = cuRewrite.getAST();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            rewrite.set((ASTNode)this.lambda, (StructuralPropertyDescriptor)LambdaExpression.PARENTHESES_PROPERTY, (Object)Boolean.TRUE, null);
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)this.lambda, importRewrite);
            ITypeBinding[] parameterTypes = this.methodBinding.getParameterTypes();
            int i = 0;
            while (i < this.noOfLambdaParams) {
                VariableDeclaration param = this.lambdaParameters.get(i);
                SingleVariableDeclaration newParam = ast.newSingleVariableDeclaration();
                newParam.setName(ast.newSimpleName(param.getName().getIdentifier()));
                ITypeBinding type = StubUtility2Core.replaceWildcardsAndCaptures(parameterTypes[i]);
                newParam.setType(importRewrite.addImport(type, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.PARAMETER));
                rewrite.replace((ASTNode)param, (ASTNode)newParam, null);
                ++i;
            }
        }
    }
}

