/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public class UpdateClasspathJob {
    private UpdateClasspathJob() {
    }

    public static Job scheduleFor(final List<IPluginModelBase> models, boolean user) {
        WorkspaceJob job = new WorkspaceJob(PDEUIMessages.UpdateClasspathJob_title){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)PDEUIMessages.UpdateClasspathJob_task, (int)models.size());
                for (IPluginModelBase model : models) {
                    UpdateClasspathJob.updateClasspath(model, mon.split(1));
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(user);
        job.setPriority(30);
        job.schedule();
        return job;
    }

    private static void updateClasspath(IPluginModelBase model, SubMonitor monitor) throws CoreException {
        try {
            IProjectDescription projDesc;
            monitor.subTask(model.getPluginBase().getId());
            IProject project = model.getUnderlyingResource().getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature") && (projDesc = project.getDescription()) != null) {
                projDesc.setReferencedProjects(new IProject[0]);
                project.setDescription(projDesc, null);
                IFile file = project.getFile(".project");
                if (file.exists()) {
                    file.deleteMarkers("org.eclipse.pde.core.problem", true, 0);
                }
                ClasspathComputer.setClasspath((IProject)project, (IPluginModelBase)model);
            }
        }
        catch (CoreException e) {
            String message = PDEUIMessages.UpdateClasspathJob_error_message;
            PDEPlugin.logException(e, PDEUIMessages.UpdateClasspathJob_error_title, message);
            throw new CoreException(Status.error((String)message, (Throwable)e));
        }
    }
}

