/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.internal.IRepositoryCommit;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.commit.command.CommitCommandHandler;
import org.eclipse.egit.ui.internal.repository.CreateBranchWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateBranchHandler
extends CommitCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<IRepositoryCommit> commits = this.getCommits(event);
        if (commits.size() == 1) {
            String base;
            IRepositoryCommit commit = commits.get(0);
            List<Ref> branches = this.getBranches(commit);
            if (branches.isEmpty()) {
                base = commit.getRevCommit().getName();
            } else {
                Collections.sort(branches, new Comparator<Ref>(){

                    @Override
                    public int compare(Ref o1, Ref o2) {
                        String refName1 = o1.getName();
                        String refName2 = o2.getName();
                        if (refName1.startsWith("refs/remotes/")) {
                            if (refName2.startsWith("refs/heads/")) {
                                return -1;
                            }
                            return CommonUtils.STRING_ASCENDING_COMPARATOR.compare(refName1, refName2);
                        }
                        if (refName2.startsWith("refs/remotes/")) {
                            return 1;
                        }
                        return CommonUtils.STRING_ASCENDING_COMPARATOR.compare(refName1, refName2);
                    }
                });
                Ref branch = branches.get(0).getLeaf();
                base = branch.getName();
            }
            WizardDialog dlg = new WizardDialog(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), (IWizard)new CreateBranchWizard(commit.getRepository(), base));
            dlg.setHelpAvailable(false);
            dlg.open();
        }
        return null;
    }

    private List<Ref> getBranches(IRepositoryCommit commit) {
        RevCommit c = commit.getRevCommit();
        if (!(c instanceof PlotCommit)) {
            return Collections.emptyList();
        }
        PlotCommit p = (PlotCommit)c;
        ArrayList<Ref> result = new ArrayList<Ref>();
        int refCount = p.getRefCount();
        int i = 0;
        while (i < refCount) {
            Ref ref = p.getRef(i);
            String refName = ref.getName();
            if (refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/")) {
                result.add(ref);
            }
            ++i;
        }
        return result;
    }
}

