/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.bundle;

import java.util.Comparator;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.text.bundle.CompositeManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PDEManifestElement;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.osgi.framework.BundleException;

public abstract class BasePackageHeader
extends CompositeManifestHeader {
    private static final long serialVersionUID = 1L;

    public BasePackageHeader(String name, String value, IBundle bundle, String lineDelimiter) {
        super(name, value, bundle, lineDelimiter, Comparator.naturalOrder());
    }

    protected String getVersionAttribute() {
        int manifestVersion = BundlePluginBase.getBundleManifestVersion(this.getBundle());
        return manifestVersion < 2 ? "specification-version" : "version";
    }

    public void addPackage(PackageObject object) {
        this.addManifestElement(object);
    }

    public Object removePackage(PackageObject object) {
        return this.removeManifestElement(object);
    }

    public boolean hasPackage(String packageName) {
        return this.hasElement(packageName);
    }

    public Object removePackage(String name) {
        return this.removeManifestElement(name);
    }

    public boolean renamePackage(String oldName, String newName) {
        if (this.hasPackage(oldName)) {
            PackageObject object = (PackageObject)this.removeManifestElement(oldName);
            object.setName(newName);
            this.addManifestElement(object);
            return true;
        }
        return false;
    }

    @Override
    protected void processValue(String value) {
        try {
            ManifestElement[] elements;
            ManifestElement[] manifestElementArray = elements = ManifestElement.parseHeader((String)this.fName, (String)value);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement element = manifestElementArray[n2];
                if (element.getValueComponents().length > 1) {
                    String[] stringArray = element.getValueComponents();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String valueComponent = stringArray[n4];
                        PDEManifestElement elem = this.createElement(element);
                        elem.setValueComponents(new String[]{valueComponent});
                        this.addManifestElement(elem, false);
                        ++n4;
                    }
                } else {
                    this.addManifestElement(this.createElement(element), false);
                }
                ++n2;
            }
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
    }
}

