/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.internal.commands;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.data.commands.ExcludeColumns;
import org.eclipse.rcptt.ecl.data.internal.commands.SelectColumnsService;
import org.eclipse.rcptt.ecl.data.objects.ObjectsFactory;
import org.eclipse.rcptt.ecl.data.objects.Row;
import org.eclipse.rcptt.ecl.data.objects.Table;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class ExcludeColumnsService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof ExcludeColumns)) {
            return Status.CANCEL_STATUS;
        }
        ExcludeColumns ec = (ExcludeColumns)command;
        Table source = ec.getTable();
        EList<String> srcColumns = source.getColumns();
        EList<String> excludeColumns = ec.getColumns();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<String> destColumns = new ArrayList<String>();
        int i = 0;
        while (i < srcColumns.size()) {
            String srcColumn = (String)srcColumns.get(i);
            if (!excludeColumns.contains(srcColumn)) {
                indices.add(i);
                destColumns.add(srcColumn);
            }
            ++i;
        }
        Table result = ObjectsFactory.eINSTANCE.createTable();
        result.getColumns().addAll(destColumns);
        for (Row row : source.getRows()) {
            result.getRows().add((Object)SelectColumnsService.extractSubrow(row, indices));
        }
        context.getOutput().write((Object)result);
        return Status.OK_STATUS;
    }
}

